/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.handlers.security.CachedAuthenticatedSessionHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;

public class UndertowUserSessionManagement
implements SessionListener {
    private static final Logger log = Logger.getLogger(UndertowUserSessionManagement.class);
    private static final String AUTH_SESSION_NAME = CachedAuthenticatedSessionHandler.class.getName() + ".AuthenticatedSession";
    protected ConcurrentHashMap<String, UserSessions> userSessionMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, UserSessions> keycloakSessionMap = new ConcurrentHashMap();
    protected volatile boolean registered;

    public synchronized int getActiveSessions() {
        return this.keycloakSessionMap.size();
    }

    public synchronized Long getUserLoginTime(String username) {
        UserSessions sessions = this.userSessionMap.get(username);
        if (sessions == null) {
            return null;
        }
        return sessions.getLoggedIn();
    }

    public synchronized Set<String> getActiveUsers() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.userSessionMap.keySet());
        return set;
    }

    public synchronized void login(SessionManager manager, String sessionId, String username, String keycloakSessionId) {
        UserSessions sessions = this.userSessionMap.get(username);
        if (sessions == null) {
            sessions = new UserSessions();
            sessions.user = username;
            this.userSessionMap.put(username, sessions);
        }
        sessions.httpSessionToKeycloakSession.put(sessionId, keycloakSessionId);
        sessions.keycloakSessionToHttpSession.put(keycloakSessionId, sessionId);
        this.keycloakSessionMap.put(keycloakSessionId, sessions);
        if (!this.registered) {
            manager.registerSessionListener((SessionListener)this);
            this.registered = true;
        }
    }

    public synchronized void logoutAll(SessionManager manager) {
        for (String user : this.userSessionMap.keySet()) {
            this.logoutUser(manager, user);
        }
    }

    public synchronized void logoutUser(SessionManager manager, String user) {
        log.debug((Object)("logoutUser: " + user));
        UserSessions sessions = null;
        sessions = this.userSessionMap.remove(user);
        if (sessions == null) {
            log.debug((Object)("no session for user: " + user));
            return;
        }
        log.debug((Object)"found session for user");
        for (Map.Entry<String, String> entry : sessions.httpSessionToKeycloakSession.entrySet()) {
            log.debug((Object)("invalidating session for user: " + user));
            String sessionId = entry.getKey();
            String keycloakSessionId = entry.getValue();
            Session session = manager.getSession(sessionId);
            try {
                session.invalidate(null);
            }
            catch (Exception e) {
                log.warn((Object)"Session already invalidated.");
            }
            this.keycloakSessionMap.remove(keycloakSessionId);
        }
    }

    public synchronized void logoutKeycloakSession(SessionManager manager, String keycloakSessionId) {
        log.debug((Object)("logoutKeycloakSession: " + keycloakSessionId));
        UserSessions sessions = this.keycloakSessionMap.remove(keycloakSessionId);
        if (sessions == null) {
            log.debug((Object)("no session for keycloak session id: " + keycloakSessionId));
            return;
        }
        String sessionId = sessions.keycloakSessionToHttpSession.remove(keycloakSessionId);
        if (sessionId == null) {
            log.debug((Object)("no session for keycloak session id: " + keycloakSessionId));
        }
        sessions.httpSessionToKeycloakSession.remove(sessionId);
        Session session = manager.getSession(sessionId);
        try {
            session.invalidate(null);
        }
        catch (Exception e) {
            log.warn((Object)"Session already invalidated.");
        }
        if (sessions.keycloakSessionToHttpSession.size() == 0) {
            this.userSessionMap.remove(sessions.user);
        }
    }

    public void sessionCreated(Session session, HttpServerExchange exchange) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(Session session, HttpServerExchange exchange, SessionListener.SessionDestroyedReason reason) {
        String username = this.getUsernameFromSession(session);
        if (username == null) {
            return;
        }
        String sessionId = session.getId();
        UserSessions userSessions = this.userSessionMap.get(username);
        if (userSessions == null) {
            return;
        }
        UndertowUserSessionManagement undertowUserSessionManagement = this;
        synchronized (undertowUserSessionManagement) {
            String keycloakSessionId = userSessions.httpSessionToKeycloakSession.remove(sessionId);
            if (keycloakSessionId != null) {
                userSessions.keycloakSessionToHttpSession.remove(keycloakSessionId);
                this.keycloakSessionMap.remove(keycloakSessionId);
            }
            if (userSessions.httpSessionToKeycloakSession.size() == 0) {
                this.userSessionMap.remove(username);
            }
        }
    }

    protected String getUsernameFromSession(Session session) {
        AuthenticatedSessionManager.AuthenticatedSession authSession = (AuthenticatedSessionManager.AuthenticatedSession)session.getAttribute(AUTH_SESSION_NAME);
        if (authSession == null) {
            return null;
        }
        return authSession.getAccount().getPrincipal().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionIdChanged(Session session, String oldSessionId) {
        String username = this.getUsernameFromSession(session);
        if (username == null) {
            return;
        }
        String sessionId = session.getId();
        UserSessions userSessions = this.userSessionMap.get(username);
        if (userSessions == null) {
            return;
        }
        UndertowUserSessionManagement undertowUserSessionManagement = this;
        synchronized (undertowUserSessionManagement) {
            String keycloakSessionId = userSessions.httpSessionToKeycloakSession.remove(oldSessionId);
            if (keycloakSessionId != null) {
                userSessions.keycloakSessionToHttpSession.remove(keycloakSessionId);
                userSessions.keycloakSessionToHttpSession.put(keycloakSessionId, sessionId);
                userSessions.httpSessionToKeycloakSession.put(sessionId, keycloakSessionId);
            }
        }
    }

    public void attributeAdded(Session session, String name, Object value) {
    }

    public void attributeUpdated(Session session, String name, Object newValue, Object oldValue) {
    }

    public void attributeRemoved(Session session, String name, Object oldValue) {
    }

    public static class UserSessions {
        protected String user;
        protected long loggedIn = System.currentTimeMillis();
        protected Map<String, String> keycloakSessionToHttpSession = new HashMap<String, String>();
        protected Map<String, String> httpSessionToKeycloakSession = new HashMap<String, String>();

        public long getLoggedIn() {
            return this.loggedIn;
        }
    }
}

