/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.util.ldap;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.comparators.NormalizingComparator;
import org.apache.directory.api.ldap.model.schema.registries.ComparatorRegistry;
import org.apache.directory.api.ldap.model.schema.registries.SchemaLoader;
import org.apache.directory.api.ldap.schemaextractor.impl.DefaultSchemaLdifExtractor;
import org.apache.directory.api.ldap.schemaloader.LdifSchemaLoader;
import org.apache.directory.api.ldap.schemamanager.impl.DefaultSchemaManager;
import org.apache.directory.api.util.exception.Exceptions;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.api.CacheService;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InstanceLayout;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.schema.SchemaPartition;
import org.apache.directory.server.core.factory.DirectoryServiceFactory;
import org.apache.directory.server.core.factory.LdifPartitionFactory;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.core.partition.ldif.LdifPartition;
import org.apache.directory.server.i18n.I18n;
import org.jboss.logging.Logger;

class FileDirectoryServiceFactory
implements DirectoryServiceFactory {
    private static final Logger LOG = Logger.getLogger(FileDirectoryServiceFactory.class);
    private DirectoryService directoryService;
    private PartitionFactory partitionFactory;

    public FileDirectoryServiceFactory() {
        try {
            this.directoryService = new DefaultDirectoryService();
            this.directoryService.setShutdownHookEnabled(false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            String typeName = System.getProperty("apacheds.partition.factory");
            if (typeName != null) {
                Class<?> type = Class.forName(typeName);
                this.partitionFactory = (PartitionFactory)type.newInstance();
            } else {
                this.partitionFactory = new LdifPartitionFactory();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error instantiating custom partiton factory", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public FileDirectoryServiceFactory(DirectoryService directoryService, PartitionFactory partitionFactory) {
        this.directoryService = directoryService;
        this.partitionFactory = partitionFactory;
    }

    public void init(String name) throws Exception {
        if (this.directoryService != null && this.directoryService.isStarted()) {
            return;
        }
        this.build(name);
    }

    private void buildInstanceDirectory(String name) throws IOException {
        String instanceDirectory = System.getProperty("workingDirectory");
        if (instanceDirectory == null) {
            instanceDirectory = System.getProperty("java.io.tmpdir") + "/server-work-" + name;
        }
        InstanceLayout instanceLayout = new InstanceLayout(instanceDirectory);
        this.directoryService.setInstanceLayout(instanceLayout);
    }

    private void initSchema() throws Exception {
        File workingDirectory = this.directoryService.getInstanceLayout().getPartitionsDirectory();
        File schemaRepository = new File(workingDirectory, "schema");
        DefaultSchemaLdifExtractor extractor = new DefaultSchemaLdifExtractor(workingDirectory);
        try {
            extractor.extractOrCopy();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LdifSchemaLoader loader = new LdifSchemaLoader(schemaRepository);
        DefaultSchemaManager schemaManager = new DefaultSchemaManager((SchemaLoader)loader);
        schemaManager.loadAllEnabled();
        ComparatorRegistry comparatorRegistry = schemaManager.getComparatorRegistry();
        for (LdapComparator comparator : comparatorRegistry) {
            if (!(comparator instanceof NormalizingComparator)) continue;
            ((NormalizingComparator)comparator).setOnServer();
        }
        this.directoryService.setSchemaManager((SchemaManager)schemaManager);
        LdifPartition ldifPartition = new LdifPartition((SchemaManager)schemaManager, this.directoryService.getDnFactory());
        ldifPartition.setPartitionPath(new File(workingDirectory, "schema").toURI());
        SchemaPartition schemaPartition = new SchemaPartition((SchemaManager)schemaManager);
        schemaPartition.setWrappedPartition((Partition)ldifPartition);
        this.directoryService.setSchemaPartition(schemaPartition);
        List errors = schemaManager.getErrors();
        if (errors.size() != 0) {
            throw new Exception(I18n.err((I18n)I18n.ERR_317, (Object[])new Object[]{Exceptions.printErrors((List)errors)}));
        }
    }

    private void initSystemPartition() throws Exception {
        Partition systemPartition = this.partitionFactory.createPartition(this.directoryService.getSchemaManager(), this.directoryService.getDnFactory(), "system", "ou=system", 500, new File(this.directoryService.getInstanceLayout().getPartitionsDirectory(), "system"));
        systemPartition.setSchemaManager(this.directoryService.getSchemaManager());
        this.partitionFactory.addIndex(systemPartition, "objectClass", 100);
        this.directoryService.setSystemPartition(systemPartition);
    }

    private void build(String name) throws Exception {
        this.directoryService.setInstanceId(name);
        this.buildInstanceDirectory(name);
        CacheService cacheService = new CacheService();
        cacheService.initialize(this.directoryService.getInstanceLayout());
        this.directoryService.setCacheService(cacheService);
        this.initSchema();
        this.initSystemPartition();
        this.directoryService.startup();
    }

    public DirectoryService getDirectoryService() throws Exception {
        return this.directoryService;
    }

    public PartitionFactory getPartitionFactory() throws Exception {
        return this.partitionFactory;
    }
}

