/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.util.ldap;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.directory.api.ldap.model.cursor.ClosureMonitor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.AttributeTypeOptions;
import org.apache.directory.server.core.api.filtering.EntryFilter;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;

public class RangedAttributeInterceptor
extends BaseInterceptor {
    private final String name;
    private final int max;

    public RangedAttributeInterceptor(String name, int max) {
        this.name = name;
        this.max = max - 1;
    }

    public EntryFilteringCursor search(SearchOperationContext sc) throws LdapException {
        Set attrs = sc.getReturningAttributes();
        Integer lmin = null;
        Integer lmax = this.max;
        if (attrs != null) {
            for (AttributeTypeOptions attr : attrs) {
                if (!attr.getAttributeType().getName().equalsIgnoreCase(this.name)) continue;
                if (attr.getOptions() == null) break;
                for (String option : attr.getOptions()) {
                    String[] ranges;
                    if (!option.startsWith("range=") || (ranges = option.substring(6).split("-")).length != 2) continue;
                    try {
                        lmin = Integer.parseInt(ranges[0]);
                        if (lmin < 0) {
                            lmin = 0;
                        }
                        if ("*".equals(ranges[1])) {
                            lmax = lmin + this.max;
                            continue;
                        }
                        lmax = Integer.parseInt(ranges[1]);
                        if (lmax < lmin) {
                            lmax = lmin;
                            continue;
                        }
                        if (lmax <= lmin + this.max) continue;
                        lmax = lmin + this.max;
                    }
                    catch (NumberFormatException e) {
                        lmin = null;
                        lmax = this.max;
                    }
                }
            }
        }
        return new RangedEntryFilteringCursor(super.next(sc), this.name, lmin, lmax);
    }

    private class RangedEntryFilteringCursor
    implements EntryFilteringCursor {
        private final EntryFilteringCursor c;
        private final String name;
        private final Integer min;
        private final Integer max;

        public RangedEntryFilteringCursor(EntryFilteringCursor c, String name, Integer min, Integer max) {
            this.c = c;
            this.name = name;
            this.min = min;
            this.max = max;
            AttributeType type = new AttributeType(name);
        }

        private Entry prepareEntry(Entry e) {
            Attribute attr = e.get(this.name);
            if (attr != null) {
                int end;
                int start = this.min != null ? this.min : 0;
                start = start < attr.size() ? start : attr.size() - 1;
                int n = end = this.max != null && this.max < attr.size() - 1 ? this.max : attr.size() - 1;
                if (start != 0 || end != attr.size() - 1) {
                    Iterator it = attr.iterator();
                    HashSet<Value> valuesToRemove = new HashSet<Value>(end - start + 1);
                    for (int i = 0; i < attr.size(); ++i) {
                        Value v = (Value)it.next();
                        if (i >= start && i <= end) continue;
                        valuesToRemove.add(v);
                    }
                    attr.setUpId(attr.getUpId() + ";range=" + start + "-" + (end == attr.size() - 1 ? "*" : Integer.valueOf(end)));
                    attr.remove(valuesToRemove.toArray(new Value[0]));
                } else if (this.min != null) {
                    attr.setUpId(attr.getUpId() + ";range=0-*");
                }
            }
            return e;
        }

        public boolean addEntryFilter(EntryFilter ef) {
            return this.c.addEntryFilter(ef);
        }

        public List<EntryFilter> getEntryFilters() {
            return this.c.getEntryFilters();
        }

        public SearchOperationContext getOperationContext() {
            return this.c.getOperationContext();
        }

        public boolean available() {
            return this.c.available();
        }

        public void before(Entry e) throws LdapException, CursorException {
            this.c.before((Object)e);
        }

        public void after(Entry e) throws LdapException, CursorException {
            this.c.after((Object)e);
        }

        public void beforeFirst() throws LdapException, CursorException {
            this.c.beforeFirst();
        }

        public void afterLast() throws LdapException, CursorException {
            this.c.afterLast();
        }

        public boolean first() throws LdapException, CursorException {
            return this.c.first();
        }

        public boolean isFirst() {
            return this.c.isFirst();
        }

        public boolean isBeforeFirst() {
            return this.c.isBeforeFirst();
        }

        public boolean last() throws LdapException, CursorException {
            return this.c.last();
        }

        public boolean isLast() {
            return this.c.isLast();
        }

        public boolean isAfterLast() {
            return this.c.isAfterLast();
        }

        public boolean isClosed() {
            return this.c.isClosed();
        }

        public boolean previous() throws LdapException, CursorException {
            return this.c.previous();
        }

        public boolean next() throws LdapException, CursorException {
            return this.c.next();
        }

        public Entry get() throws CursorException {
            return this.prepareEntry((Entry)this.c.get());
        }

        public void close() throws IOException {
            this.c.close();
        }

        public void close(Exception excptn) throws IOException {
            this.c.close(excptn);
        }

        public void setClosureMonitor(ClosureMonitor cm) {
            this.c.setClosureMonitor(cm);
        }

        public String toString(String string) {
            return this.c.toString(string);
        }

        public Iterator<Entry> iterator() {
            return this.c.iterator();
        }
    }
}

