/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.util.ldap;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapEntryAlreadyExistsException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.jboss.logging.Logger;
import org.keycloak.common.util.FindFile;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.util.ldap.FileDirectoryServiceFactory;
import org.keycloak.util.ldap.InMemoryDirectoryServiceFactory;

public class LDAPEmbeddedServer {
    private static final Logger log = Logger.getLogger(LDAPEmbeddedServer.class);
    public static final String PROPERTY_BASE_DN = "ldap.baseDN";
    public static final String PROPERTY_BIND_HOST = "ldap.host";
    public static final String PROPERTY_BIND_PORT = "ldap.port";
    public static final String PROPERTY_LDIF_FILE = "ldap.ldif";
    public static final String PROPERTY_SASL_PRINCIPAL = "ldap.saslPrincipal";
    public static final String PROPERTY_DSF = "ldap.dsf";
    private static final String DEFAULT_BASE_DN = "dc=keycloak,dc=org";
    private static final String DEFAULT_BIND_HOST = "localhost";
    private static final String DEFAULT_BIND_PORT = "10389";
    private static final String DEFAULT_LDIF_FILE = "classpath:ldap/default-users.ldif";
    private static final String PROPERTY_ENABLE_SSL = "enableSSL";
    private static final String PROPERTY_KEYSTORE_FILE = "keystoreFile";
    private static final String PROPERTY_CERTIFICATE_PASSWORD = "certificatePassword";
    public static final String DSF_INMEMORY = "mem";
    public static final String DSF_FILE = "file";
    public static final String DEFAULT_DSF = "file";
    protected Properties defaultProperties;
    protected String baseDN;
    protected String bindHost;
    protected int bindPort;
    protected String ldifFile;
    protected String ldapSaslPrincipal;
    protected String directoryServiceFactory;
    protected boolean enableSSL = false;
    protected String keystoreFile;
    protected String certPassword;
    protected DirectoryService directoryService;
    protected LdapServer ldapServer;

    public static void main(String[] args) throws Exception {
        Properties defaultProperties = new Properties();
        defaultProperties.put(PROPERTY_DSF, "file");
        LDAPEmbeddedServer.execute(args, defaultProperties);
    }

    public static void execute(String[] args, Properties defaultProperties) throws Exception {
        final LDAPEmbeddedServer ldapEmbeddedServer = new LDAPEmbeddedServer(defaultProperties);
        ldapEmbeddedServer.init();
        ldapEmbeddedServer.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    ldapEmbeddedServer.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public LDAPEmbeddedServer(Properties defaultProperties) {
        this.defaultProperties = defaultProperties;
        this.baseDN = this.readProperty(PROPERTY_BASE_DN, DEFAULT_BASE_DN);
        this.bindHost = this.readProperty(PROPERTY_BIND_HOST, DEFAULT_BIND_HOST);
        String bindPort = this.readProperty(PROPERTY_BIND_PORT, DEFAULT_BIND_PORT);
        this.bindPort = Integer.parseInt(bindPort);
        this.ldifFile = this.readProperty(PROPERTY_LDIF_FILE, DEFAULT_LDIF_FILE);
        this.ldapSaslPrincipal = this.readProperty(PROPERTY_SASL_PRINCIPAL, null);
        this.directoryServiceFactory = this.readProperty(PROPERTY_DSF, "file");
        this.enableSSL = Boolean.valueOf(this.readProperty(PROPERTY_ENABLE_SSL, "false"));
        this.keystoreFile = this.readProperty(PROPERTY_KEYSTORE_FILE, null);
        this.certPassword = this.readProperty(PROPERTY_CERTIFICATE_PASSWORD, null);
    }

    protected String readProperty(String propertyName, String defaultValue) {
        String value = System.getProperty(propertyName);
        if (value == null || value.isEmpty()) {
            value = (String)this.defaultProperties.get(propertyName);
        }
        if (value == null || value.isEmpty()) {
            value = defaultValue;
        }
        return value;
    }

    public void init() throws Exception {
        log.info((Object)("Creating LDAP Directory Service. Config: baseDN=" + this.baseDN + ", bindHost=" + this.bindHost + ", bindPort=" + this.bindPort + ", ldapSaslPrincipal=" + this.ldapSaslPrincipal + ", directoryServiceFactory=" + this.directoryServiceFactory + ", ldif=" + this.ldifFile));
        this.directoryService = this.createDirectoryService();
        log.info((Object)("Importing LDIF: " + this.ldifFile));
        this.importLdif();
        log.info((Object)"Creating LDAP Server");
        this.ldapServer = this.createLdapServer();
    }

    public void start() throws Exception {
        log.info((Object)"Starting LDAP Server");
        this.ldapServer.start();
        log.info((Object)"LDAP Server started");
    }

    protected DirectoryService createDirectoryService() throws Exception {
        Object dsf;
        String dcName = this.baseDN.split(",")[0];
        dcName = dcName.substring(dcName.indexOf("=") + 1);
        if (this.directoryServiceFactory.equals(DSF_INMEMORY)) {
            dsf = new InMemoryDirectoryServiceFactory();
        } else if (this.directoryServiceFactory.equals("file")) {
            dsf = new FileDirectoryServiceFactory();
        } else {
            throw new IllegalStateException("Unknown value of directoryServiceFactory: " + this.directoryServiceFactory);
        }
        DirectoryService service = dsf.getDirectoryService();
        service.setAccessControlEnabled(false);
        service.setAllowAnonymousAccess(false);
        service.getChangeLog().setEnabled(false);
        dsf.init(dcName + "DS");
        SchemaManager schemaManager = service.getSchemaManager();
        PartitionFactory partitionFactory = dsf.getPartitionFactory();
        Partition partition = partitionFactory.createPartition(schemaManager, service.getDnFactory(), dcName, this.baseDN, 1000, new File(service.getInstanceLayout().getPartitionsDirectory(), dcName));
        partition.setCacheService(service.getCacheService());
        partition.initialize();
        partition.setSchemaManager(schemaManager);
        service.addPartition(partition);
        String entryLdif = "dn: " + this.baseDN + "\n" + "dc: " + dcName + "\n" + "objectClass: top\n" + "objectClass: domain\n\n";
        LDAPEmbeddedServer.importLdifContent(service, entryLdif);
        return service;
    }

    protected LdapServer createLdapServer() {
        LdapServer ldapServer = new LdapServer();
        ldapServer.setServiceName("DefaultLdapServer");
        ldapServer.setSearchBaseDn(this.baseDN);
        TcpTransport ldaps = new TcpTransport(this.bindHost, this.bindPort, 3, 50);
        if (this.enableSSL) {
            ldaps.setEnableSSL(true);
            ldapServer.setKeystoreFile(this.keystoreFile);
            ldapServer.setCertificatePassword(this.certPassword);
            TcpTransport ldap = new TcpTransport(this.bindHost, 10389, 3, 50);
            ldapServer.addTransports(new Transport[]{ldap});
        }
        ldapServer.addTransports(new Transport[]{ldaps});
        ldapServer.setDirectoryService(this.directoryService);
        this.directoryService.setAllowAnonymousAccess(false);
        return ldapServer;
    }

    private void importLdif() throws Exception {
        InputStream is;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hostname", this.bindHost);
        if (this.ldapSaslPrincipal != null) {
            map.put("ldapSaslPrincipal", this.ldapSaslPrincipal);
        }
        if ((is = FindFile.findFile((String)this.ldifFile)) == null) {
            throw new IllegalStateException("LDIF file not found on classpath or on file system. Location was: " + this.ldifFile);
        }
        String ldifContent = StrSubstitutor.replace((Object)StreamUtil.readString((InputStream)is), map);
        log.info((Object)("Content of LDIF: " + ldifContent));
        SchemaManager schemaManager = this.directoryService.getSchemaManager();
        LDAPEmbeddedServer.importLdifContent(this.directoryService, ldifContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importLdifContent(DirectoryService directoryService, String ldifContent) throws Exception {
        try (LdifReader ldifReader = new LdifReader(IOUtils.toInputStream((String)ldifContent));){
            for (LdifEntry ldifEntry : ldifReader) {
                try {
                    directoryService.getAdminSession().add((Entry)new DefaultEntry(directoryService.getSchemaManager(), ldifEntry.getEntry()));
                }
                catch (LdapEntryAlreadyExistsException ignore) {
                    log.info((Object)("Entry " + ldifEntry.getDn() + " already exists. Ignoring"));
                }
            }
        }
    }

    public void stop() throws Exception {
        this.stopLdapServer();
        this.shutdownDirectoryService();
    }

    protected void stopLdapServer() {
        log.info((Object)"Stopping LDAP server.");
        this.ldapServer.stop();
    }

    protected void shutdownDirectoryService() throws Exception {
        log.info((Object)"Stopping Directory service.");
        this.directoryService.shutdown();
        File instanceDir = this.directoryService.getInstanceLayout().getInstanceDirectory();
        if (this.directoryServiceFactory.equals(DSF_INMEMORY)) {
            log.infof("Removing Directory service workfiles: %s", (Object)instanceDir.getAbsolutePath());
            FileUtils.deleteDirectory((File)instanceDir);
        } else {
            log.info((Object)("Working LDAP directory not deleted. Delete it manually if you want to start with fresh LDAP data. Directory location: " + instanceDir.getAbsolutePath()));
        }
    }
}

