/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.util.ldap;

import java.net.URL;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.schema.extractor.impl.DefaultSchemaLdifExtractor;
import org.apache.directory.api.ldap.schema.extractor.impl.ResourceMap;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.partition.ldif.AbstractLdifPartition;
import org.jboss.logging.Logger;

class InMemorySchemaPartition
extends AbstractLdifPartition {
    private static final Logger log = Logger.getLogger(InMemorySchemaPartition.class);

    public InMemorySchemaPartition(SchemaManager schemaManager) {
        super(schemaManager);
    }

    protected void doInit() throws InvalidNameException, Exception {
        if (this.initialized) {
            return;
        }
        log.debug((Object)("Initializing schema partition " + this.getId()));
        this.suffixDn.apply(this.schemaManager);
        super.doInit();
        Map resMap = ResourceMap.getResources((Pattern)Pattern.compile("schema[/\\Q\\\\E]ou=schema.*"));
        for (String resourcePath : new TreeSet(resMap.keySet())) {
            if (!resourcePath.endsWith(".ldif")) continue;
            URL resource = DefaultSchemaLdifExtractor.getUniqueResource((String)resourcePath, (String)"Schema LDIF file");
            LdifReader reader = new LdifReader(resource.openStream());
            LdifEntry ldifEntry = reader.next();
            reader.close();
            DefaultEntry entry = new DefaultEntry(this.schemaManager, ldifEntry.getEntry());
            if (entry.get("entryCSN") == null) {
                entry.add("entryCSN", new String[]{AbstractLdifPartition.defaultCSNFactory.newInstance().toString()});
            }
            if (entry.get("entryUUID") == null) {
                entry.add("entryUUID", new String[]{UUID.randomUUID().toString()});
            }
            AddOperationContext addContext = new AddOperationContext(null, (Entry)entry);
            super.add(addContext);
        }
    }
}

