/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.jetty.core;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashSet;
import javax.security.auth.Subject;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.DefaultUserIdentity;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.adapters.AuthenticatedActionsHandler;
import org.keycloak.adapters.KeycloakConfigResolver;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.NodesRegistrationManagement;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.PreAuthActionsHandler;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.jetty.core.JettyCookieTokenStore;
import org.keycloak.adapters.jetty.core.JettyRequestAuthenticator;
import org.keycloak.adapters.jetty.core.OIDCJettyHttpFacade;
import org.keycloak.adapters.jetty.spi.JettyHttpFacade;
import org.keycloak.adapters.jetty.spi.JettyUserSessionManagement;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.UserSessionManagement;
import org.keycloak.enums.TokenStore;
import org.keycloak.representations.adapters.config.AdapterConfig;

public abstract class AbstractKeycloakJettyAuthenticator
extends LoginAuthenticator {
    public static final String TOKEN_STORE_NOTE = "TOKEN_STORE_NOTE";
    protected static final Logger log = Logger.getLogger(AbstractKeycloakJettyAuthenticator.class);
    protected AdapterDeploymentContext deploymentContext;
    protected NodesRegistrationManagement nodesRegistrationManagement;
    protected AdapterConfig adapterConfig;
    protected KeycloakConfigResolver configResolver;
    protected String errorPage;

    private static InputStream getJSONFromServletContext(ServletContext servletContext) {
        String json = servletContext.getInitParameter("org.keycloak.json.adapterConfig");
        if (json == null) {
            return null;
        }
        return new ByteArrayInputStream(json.getBytes());
    }

    public AdapterTokenStore getTokenStore(Request request, HttpFacade facade, KeycloakDeployment resolvedDeployment) {
        Object store = (AdapterTokenStore)request.getAttribute(TOKEN_STORE_NOTE);
        if (store != null) {
            return store;
        }
        store = resolvedDeployment.getTokenStore() == TokenStore.SESSION ? this.createSessionTokenStore(request, resolvedDeployment) : new JettyCookieTokenStore(request, facade, resolvedDeployment);
        request.setAttribute(TOKEN_STORE_NOTE, store);
        return store;
    }

    public abstract AdapterTokenStore createSessionTokenStore(Request var1, KeycloakDeployment var2);

    public abstract JettyUserSessionManagement createSessionManagement(Request var1);

    public void logoutCurrent(Request request) {
        AdapterDeploymentContext deploymentContext = (AdapterDeploymentContext)request.getAttribute(AdapterDeploymentContext.class.getName());
        KeycloakSecurityContext ksc = (KeycloakSecurityContext)request.getAttribute(KeycloakSecurityContext.class.getName());
        if (ksc != null) {
            OIDCJettyHttpFacade facade = new OIDCJettyHttpFacade(request, null);
            KeycloakDeployment deployment = deploymentContext.resolveDeployment((HttpFacade)facade);
            if (ksc instanceof RefreshableKeycloakSecurityContext) {
                ((RefreshableKeycloakSecurityContext)ksc).logout(deployment);
            }
            AdapterTokenStore tokenStore = this.getTokenStore(request, facade, deployment);
            tokenStore.logout();
            request.removeAttribute(KeycloakSecurityContext.class.getName());
        }
    }

    public static UserIdentity createIdentity(KeycloakPrincipal<RefreshableKeycloakSecurityContext> principal) {
        HashSet roles = AdapterUtils.getRolesFromSecurityContext((RefreshableKeycloakSecurityContext)((RefreshableKeycloakSecurityContext)principal.getKeycloakSecurityContext()));
        if (roles == null) {
            roles = new HashSet();
        }
        Subject theSubject = new Subject();
        String[] theRoles = new String[roles.size()];
        roles.toArray(theRoles);
        return new DefaultUserIdentity(theSubject, principal, theRoles);
    }

    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        this.initializeKeycloak();
        this._loginService = new DummyLoginService();
        String error = configuration.getInitParameter("org.eclipse.jetty.security.form_error_page");
        this.setErrorPage(error);
    }

    private void setErrorPage(String path) {
        if (path != null && path.trim().length() != 0) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            this.errorPage = path;
            if (this.errorPage.indexOf(63) > 0) {
                this.errorPage = this.errorPage.substring(0, this.errorPage.indexOf(63));
            }
        }
    }

    public boolean secureResponse(ServletRequest req, ServletResponse res, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }

    public AdapterConfig getAdapterConfig() {
        return this.adapterConfig;
    }

    public void setAdapterConfig(AdapterConfig adapterConfig) {
        this.adapterConfig = adapterConfig;
    }

    public KeycloakConfigResolver getConfigResolver() {
        return this.configResolver;
    }

    public void setConfigResolver(KeycloakConfigResolver configResolver) {
        this.configResolver = configResolver;
    }

    public void initializeKeycloak() {
        InputStream configInputStream;
        String configResolverClass;
        this.nodesRegistrationManagement = new NodesRegistrationManagement();
        Object theServletContext = null;
        ContextHandler.Context currentContext = ContextHandler.getCurrentContext();
        if (currentContext != null) {
            String contextPath = currentContext.getContextPath();
            theServletContext = "".equals(contextPath) ? currentContext : currentContext.getContext(contextPath);
        }
        if (this.configResolver == null && theServletContext != null && (configResolverClass = theServletContext.getInitParameter("keycloak.config.resolver")) != null) {
            try {
                this.configResolver = (KeycloakConfigResolver)ContextHandler.getCurrentContext().getClassLoader().loadClass(configResolverClass).newInstance();
                log.infov("Using {0} to resolve Keycloak configuration on a per-request basis.", (Object)configResolverClass);
            }
            catch (Exception ex) {
                log.infov("The specified resolver {0} could NOT be loaded. Keycloak is unconfigured and will deny all requests. Reason: {1}", new Object[]{configResolverClass, ex.getMessage()});
            }
        }
        if (this.configResolver != null) {
            this.deploymentContext = new AdapterDeploymentContext(this.configResolver);
        } else if (this.adapterConfig != null) {
            KeycloakDeployment kd = KeycloakDeploymentBuilder.build((AdapterConfig)this.adapterConfig);
            this.deploymentContext = new AdapterDeploymentContext(kd);
        } else if (theServletContext != null && (configInputStream = this.getConfigInputStream((ServletContext)theServletContext)) != null) {
            this.deploymentContext = new AdapterDeploymentContext(KeycloakDeploymentBuilder.build((InputStream)configInputStream));
        }
        if (this.deploymentContext == null) {
            this.deploymentContext = new AdapterDeploymentContext(new KeycloakDeployment());
        }
        if (theServletContext != null) {
            theServletContext.setAttribute(AdapterDeploymentContext.class.getName(), (Object)this.deploymentContext);
        }
    }

    private InputStream getConfigInputStream(ServletContext servletContext) {
        InputStream is = AbstractKeycloakJettyAuthenticator.getJSONFromServletContext(servletContext);
        if (is == null) {
            String path = servletContext.getInitParameter("keycloak.config.file");
            if (path == null) {
                is = servletContext.getResourceAsStream("/WEB-INF/keycloak.json");
            } else {
                try {
                    is = new FileInputStream(path);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return is;
    }

    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        Request request;
        OIDCJettyHttpFacade facade;
        KeycloakDeployment deployment;
        if (log.isTraceEnabled()) {
            log.trace((Object)"*** authenticate");
        }
        if ((deployment = this.deploymentContext.resolveDeployment((HttpFacade)(facade = new OIDCJettyHttpFacade(request = this.resolveRequest(req), (HttpServletResponse)res)))) == null || !deployment.isConfigured()) {
            log.debug((Object)"*** deployment isn't configured return false");
            return Authentication.UNAUTHENTICATED;
        }
        PreAuthActionsHandler handler = new PreAuthActionsHandler((UserSessionManagement)this.createSessionManagement(request), this.deploymentContext, (HttpFacade)facade);
        if (handler.handleRequest()) {
            return Authentication.SEND_SUCCESS;
        }
        if (!mandatory) {
            return new DeferredAuthentication((LoginAuthenticator)this);
        }
        AdapterTokenStore tokenStore = this.getTokenStore(request, facade, deployment);
        this.nodesRegistrationManagement.tryRegister(deployment);
        tokenStore.checkCurrentToken();
        JettyRequestAuthenticator authenticator = this.createRequestAuthenticator(request, facade, deployment, tokenStore);
        AuthOutcome outcome = authenticator.authenticate();
        if (outcome == AuthOutcome.AUTHENTICATED) {
            if (facade.isEnded()) {
                return Authentication.SEND_SUCCESS;
            }
            Authentication authentication = this.register(request, authenticator.principal);
            AuthenticatedActionsHandler authenticatedActionsHandler = new AuthenticatedActionsHandler(deployment, (OIDCHttpFacade)facade);
            if (authenticatedActionsHandler.handledRequest()) {
                return Authentication.SEND_SUCCESS;
            }
            return authentication;
        }
        AuthChallenge challenge = authenticator.getChallenge();
        if (challenge != null) {
            challenge.challenge((HttpFacade)facade);
        }
        return Authentication.SEND_CONTINUE;
    }

    protected abstract Request resolveRequest(ServletRequest var1);

    protected JettyRequestAuthenticator createRequestAuthenticator(Request request, JettyHttpFacade facade, KeycloakDeployment deployment, AdapterTokenStore tokenStore) {
        return new JettyRequestAuthenticator(facade, deployment, tokenStore, -1, request);
    }

    public String getAuthMethod() {
        return "KEYCLOAK";
    }

    protected Authentication register(Request request, KeycloakPrincipal<RefreshableKeycloakSecurityContext> principal) {
        request.setAttribute(AdapterDeploymentContext.class.getName(), (Object)this.deploymentContext);
        Authentication authentication = request.getAuthentication();
        if (!(authentication instanceof KeycloakAuthentication)) {
            UserIdentity userIdentity = AbstractKeycloakJettyAuthenticator.createIdentity(principal);
            authentication = this.createAuthentication(userIdentity, request);
            request.setAuthentication(authentication);
        }
        return authentication;
    }

    protected abstract Authentication createAuthentication(UserIdentity var1, Request var2);

    public static abstract class KeycloakAuthentication
    extends UserAuthentication {
        public KeycloakAuthentication(String method, UserIdentity userIdentity) {
            super(method, userIdentity);
        }
    }

    private class DummyLoginService
    implements LoginService {
        private DummyLoginService() {
        }

        public String getName() {
            return null;
        }

        public UserIdentity login(String username, Object credentials) {
            return null;
        }

        public boolean validate(UserIdentity user) {
            return false;
        }

        public IdentityService getIdentityService() {
            return null;
        }

        public void setIdentityService(IdentityService service) {
        }

        public void logout(UserIdentity user) {
        }
    }
}

