/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.api.SecurityNotification;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.undertow.OIDCUndertowHttpFacade;
import org.keycloak.adapters.undertow.UndertowCookieTokenStore;
import org.keycloak.adapters.undertow.UndertowHttpFacade;
import org.keycloak.adapters.undertow.UndertowSessionTokenStore;
import org.keycloak.adapters.undertow.UndertowUserSessionManagement;
import org.keycloak.enums.TokenStore;

public abstract class AbstractUndertowKeycloakAuthMech
implements AuthenticationMechanism {
    public static final AttachmentKey<AuthChallenge> KEYCLOAK_CHALLENGE_ATTACHMENT_KEY = AttachmentKey.create(AuthChallenge.class);
    protected AdapterDeploymentContext deploymentContext;
    protected UndertowUserSessionManagement sessionManagement;
    protected String errorPage;

    public AbstractUndertowKeycloakAuthMech(AdapterDeploymentContext deploymentContext, UndertowUserSessionManagement sessionManagement, String errorPage) {
        this.deploymentContext = deploymentContext;
        this.sessionManagement = sessionManagement;
        this.errorPage = errorPage;
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        UndertowHttpFacade facade;
        AuthChallenge challenge = (AuthChallenge)exchange.getAttachment(KEYCLOAK_CHALLENGE_ATTACHMENT_KEY);
        if (challenge != null && challenge.challenge((HttpFacade)(facade = this.createFacade(exchange)))) {
            return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(exchange.getResponseCode()));
        }
        return new AuthenticationMechanism.ChallengeResult(false);
    }

    public UndertowHttpFacade createFacade(HttpServerExchange exchange) {
        return new OIDCUndertowHttpFacade(exchange);
    }

    protected Integer servePage(HttpServerExchange exchange, String location) {
        AbstractUndertowKeycloakAuthMech.sendRedirect(exchange, location);
        return 307;
    }

    static void sendRedirect(HttpServerExchange exchange, String location) {
        String loc = exchange.getRequestScheme() + "://" + exchange.getHostAndPort() + location;
        exchange.getResponseHeaders().put(Headers.LOCATION, loc);
    }

    protected void registerNotifications(final SecurityContext securityContext) {
        NotificationReceiver logoutReceiver = new NotificationReceiver(){

            public void handleNotification(SecurityNotification notification) {
                if (notification.getEventType() != SecurityNotification.EventType.LOGGED_OUT) {
                    return;
                }
                HttpServerExchange exchange = notification.getExchange();
                UndertowHttpFacade facade = AbstractUndertowKeycloakAuthMech.this.createFacade(exchange);
                KeycloakDeployment deployment = AbstractUndertowKeycloakAuthMech.this.deploymentContext.resolveDeployment((HttpFacade)facade);
                KeycloakSecurityContext ksc = (KeycloakSecurityContext)exchange.getAttachment(OIDCUndertowHttpFacade.KEYCLOAK_SECURITY_CONTEXT_KEY);
                if (!deployment.isBearerOnly() && ksc != null && ksc instanceof RefreshableKeycloakSecurityContext) {
                    ((RefreshableKeycloakSecurityContext)ksc).logout(deployment);
                }
                AdapterTokenStore tokenStore = AbstractUndertowKeycloakAuthMech.this.getTokenStore(exchange, facade, deployment, securityContext);
                tokenStore.logout();
            }
        };
        securityContext.registerNotificationReceiver(logoutReceiver);
    }

    protected AuthenticationMechanism.AuthenticationMechanismOutcome keycloakAuthenticate(HttpServerExchange exchange, SecurityContext securityContext, RequestAuthenticator authenticator) {
        AuthOutcome outcome = authenticator.authenticate();
        if (outcome == AuthOutcome.AUTHENTICATED) {
            this.registerNotifications(securityContext);
            return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
        }
        AuthChallenge challenge = authenticator.getChallenge();
        if (challenge != null) {
            exchange.putAttachment(KEYCLOAK_CHALLENGE_ATTACHMENT_KEY, (Object)challenge);
        }
        if (outcome == AuthOutcome.FAILED) {
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    protected AdapterTokenStore getTokenStore(HttpServerExchange exchange, HttpFacade facade, KeycloakDeployment deployment, SecurityContext securityContext) {
        if (deployment.getTokenStore() == TokenStore.SESSION) {
            return new UndertowSessionTokenStore(exchange, deployment, this.sessionManagement, securityContext);
        }
        return new UndertowCookieTokenStore(facade, deployment, securityContext);
    }
}

