/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.logging.Logger;

public class UndertowUserSessionManagement
implements SessionListener {
    private static final Logger log = Logger.getLogger(UndertowUserSessionManagement.class);
    protected volatile boolean registered;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public void login(SessionManager manager) {
        if (!this.registered) {
            manager.registerSessionListener((SessionListener)this);
            this.registered = true;
        }
    }

    private void workaroundIspnDeadlock(SessionManager manager, Runnable r) {
        if (manager.getClass().getName().equals("org.wildfly.clustering.web.undertow.session.DistributableSessionManager")) {
            this.executor.submit(r);
        } else {
            r.run();
        }
    }

    public void logoutAll(final SessionManager manager) {
        final Set allSessions = manager.getAllSessions();
        this.workaroundIspnDeadlock(manager, new Runnable(){

            @Override
            public void run() {
                for (String sessionId : allSessions) {
                    UndertowUserSessionManagement.this.logoutSession(manager, sessionId);
                }
            }
        });
    }

    public void logoutHttpSessions(final SessionManager manager, final List<String> sessionIds) {
        log.debugf("logoutHttpSessions: %s", sessionIds);
        this.workaroundIspnDeadlock(manager, new Runnable(){

            @Override
            public void run() {
                for (String sessionId : sessionIds) {
                    UndertowUserSessionManagement.this.logoutSession(manager, sessionId);
                }
            }
        });
    }

    protected void logoutSession(SessionManager manager, String httpSessionId) {
        log.debugf("logoutHttpSession: %s", (Object)httpSessionId);
        Session session = this.getSessionById(manager, httpSessionId);
        try {
            if (session != null) {
                session.invalidate(null);
            }
        }
        catch (Exception e) {
            log.warnf("Session %s not present or already invalidated.", (Object)httpSessionId);
        }
    }

    protected Session getSessionById(SessionManager manager, final String sessionId) {
        if (manager.getClass().getName().equals("org.wildfly.clustering.web.undertow.session.DistributableSessionManager")) {
            return manager.getSession(null, new SessionConfig(){

                public void setSessionId(HttpServerExchange exchange, String sessionId2) {
                }

                public void clearSession(HttpServerExchange exchange, String sessionId2) {
                }

                public String findSessionId(HttpServerExchange exchange) {
                    return sessionId;
                }

                public SessionConfig.SessionCookieSource sessionCookieSource(HttpServerExchange exchange) {
                    return null;
                }

                public String rewriteUrl(String originalUrl, String sessionId2) {
                    return null;
                }
            });
        }
        return manager.getSession(sessionId);
    }

    public void sessionCreated(Session session, HttpServerExchange exchange) {
    }

    public void sessionDestroyed(Session session, HttpServerExchange exchange, SessionListener.SessionDestroyedReason reason) {
    }

    public void sessionIdChanged(Session session, String oldSessionId) {
    }

    public void attributeAdded(Session session, String name, Object value) {
    }

    public void attributeUpdated(Session session, String name, Object newValue, Object oldValue) {
    }

    public void attributeRemoved(Session session, String name, Object oldValue) {
    }
}

