/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite;

import java.text.MessageFormat;
import java.util.List;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Before;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.Users;
import org.keycloak.testsuite.auth.page.AuthRealm;
import org.keycloak.testsuite.auth.page.account.Account;
import org.keycloak.testsuite.auth.page.login.OIDCLogin;
import org.keycloak.testsuite.auth.page.login.SAMLPostLogin;
import org.keycloak.testsuite.auth.page.login.SAMLRedirectLogin;
import org.openqa.selenium.Cookie;

public abstract class AbstractAuthTest
extends AbstractKeycloakTest {
    @Page
    protected AuthRealm testRealmPage;
    @Page
    protected OIDCLogin testRealmLoginPage;
    @Page
    protected Account testRealmAccountPage;
    @Page
    protected SAMLPostLogin testRealmSAMLPostLoginPage;
    @Page
    protected SAMLRedirectLogin testRealmSAMLRedirectLoginPage;
    protected UserRepresentation testUser;
    protected UserRepresentation bburkeUser;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation testRealmRep = new RealmRepresentation();
        testRealmRep.setRealm("test");
        testRealmRep.setEnabled(Boolean.valueOf(true));
        testRealms.add(testRealmRep);
    }

    @Before
    public void beforeAuthTest() {
        this.testRealmLoginPage.setAuthRealm(this.testRealmPage);
        this.testRealmAccountPage.setAuthRealm(this.testRealmPage);
        this.testUser = AbstractAuthTest.createUserRepresentation("test", "test@email.test", "test", "user", true);
        Users.setPasswordFor((UserRepresentation)this.testUser, (String)"password");
        this.bburkeUser = AbstractAuthTest.createUserRepresentation("bburke", "bburke@redhat.com", "Bill", "Burke", true);
        Users.setPasswordFor((UserRepresentation)this.bburkeUser, (String)"password");
        this.deleteAllCookiesForTestRealm();
    }

    public void createTestUserWithAdminClient() {
        this.log.debug((Object)"creating test user");
        String id = ApiUtil.createUserAndResetPasswordWithAdminClient(this.testRealmResource(), this.testUser, "password");
        this.testUser.setId(id);
        ApiUtil.assignClientRoles(this.testRealmResource(), id, "realm-management", "view-realm");
    }

    public static UserRepresentation createUserRepresentation(String username, String email, String firstName, String lastName, boolean enabled) {
        UserRepresentation user = new UserRepresentation();
        user.setUsername(username);
        user.setEmail(email);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setEnabled(Boolean.valueOf(enabled));
        return user;
    }

    public void deleteAllCookiesForTestRealm() {
        this.deleteAllCookiesForRealm(this.testRealmAccountPage);
    }

    public void listCookies() {
        this.log.info((Object)"LIST OF COOKIES: ");
        for (Cookie c : this.driver.manage().getCookies()) {
            this.log.info((Object)MessageFormat.format(" {1} {2} {0}", c.getName(), c.getDomain(), c.getPath(), c.getValue()));
        }
    }

    public RealmResource testRealmResource() {
        return this.adminClient.realm(this.testRealmPage.getAuthRealm());
    }
}

