/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.NotFoundException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.AuthenticationManagementResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RealmsResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.common.util.Time;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.Users;
import org.keycloak.testsuite.arquillian.AuthServerTestEnricher;
import org.keycloak.testsuite.arquillian.SuiteContext;
import org.keycloak.testsuite.arquillian.TestContext;
import org.keycloak.testsuite.auth.page.AuthRealm;
import org.keycloak.testsuite.auth.page.AuthServer;
import org.keycloak.testsuite.auth.page.AuthServerContextRoot;
import org.keycloak.testsuite.auth.page.WelcomePage;
import org.keycloak.testsuite.auth.page.account.Account;
import org.keycloak.testsuite.auth.page.login.OIDCLogin;
import org.keycloak.testsuite.auth.page.login.UpdatePassword;
import org.keycloak.testsuite.client.KeycloakTestingClient;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.TestEventsLogger;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.WebDriver;

@RunWith(value=Arquillian.class)
@RunAsClient
public abstract class AbstractKeycloakTest {
    protected Logger log = Logger.getLogger(this.getClass());
    @ArquillianResource
    protected SuiteContext suiteContext;
    @ArquillianResource
    protected TestContext testContext;
    protected Keycloak adminClient;
    protected KeycloakTestingClient testingClient;
    @ArquillianResource
    protected OAuthClient oauth;
    protected List<RealmRepresentation> testRealmReps;
    @Drone
    protected WebDriver driver;
    @Page
    protected AuthServerContextRoot authServerContextRootPage;
    @Page
    protected AuthServer authServerPage;
    @Page
    protected AuthRealm masterRealmPage;
    @Page
    protected Account accountPage;
    @Page
    protected OIDCLogin loginPage;
    @Page
    protected UpdatePassword updatePasswordPage;
    @Page
    protected WelcomePage welcomePage;
    protected UserRepresentation adminUser;
    private PropertiesConfiguration constantsProperties;
    private boolean resetTimeOffset;

    @Before
    public void beforeAbstractKeycloakTest() throws Exception {
        this.adminClient = Keycloak.getInstance((String)(AuthServerTestEnricher.getAuthServerContextRoot() + "/auth"), (String)"master", (String)"admin", (String)"admin", (String)"admin-cli");
        this.getTestingClient();
        this.adminUser = this.createAdminUserRepresentation();
        this.setDefaultPageUriParameters();
        this.driverSettings();
        TestEventsLogger.setDriver(this.driver);
        if (!this.suiteContext.isAdminPasswordUpdated()) {
            this.log.debug((Object)"updating admin password");
            this.updateMasterAdminPassword();
            this.suiteContext.setAdminPasswordUpdated(true);
        }
        this.importTestRealms();
        this.oauth.init(this.adminClient, this.driver);
    }

    @After
    public void afterAbstractKeycloakTest() {
        if (this.resetTimeOffset) {
            this.resetTimeOffset();
        }
        this.removeTestRealms();
        this.adminClient.close();
    }

    private void updateMasterAdminPassword() {
        this.welcomePage.navigateTo();
        if (!this.welcomePage.isPasswordSet()) {
            this.welcomePage.setPassword("admin", "admin");
        }
    }

    public void deleteAllCookiesForMasterRealm() {
        this.deleteAllCookiesForRealm(this.accountPage);
    }

    protected void deleteAllCookiesForRealm(Account realmAccountPage) {
        realmAccountPage.navigateTo();
        this.log.info((Object)("deleting cookies in '" + realmAccountPage.getAuthRealm() + "' realm"));
        this.driver.manage().deleteAllCookies();
    }

    protected void driverSettings() {
        this.driver.manage().timeouts().implicitlyWait(750L, TimeUnit.MILLISECONDS);
        this.driver.manage().timeouts().pageLoadTimeout((long)WaitUtils.PAGELOAD_TIMEOUT_MILLIS.intValue(), TimeUnit.MILLISECONDS);
        this.driver.manage().window().maximize();
    }

    public void setDefaultPageUriParameters() {
        this.masterRealmPage.setAuthRealm("master");
        this.loginPage.setAuthRealm("master");
    }

    public KeycloakTestingClient getTestingClient() {
        if (this.testingClient == null) {
            this.testingClient = KeycloakTestingClient.getInstance((String)(AuthServerTestEnricher.getAuthServerContextRoot() + "/auth"));
        }
        return this.testingClient;
    }

    public Keycloak getAdminClient() {
        return this.adminClient;
    }

    public abstract void addTestRealms(List<RealmRepresentation> var1);

    private void addTestRealms() {
        this.log.debug((Object)"loading test realms");
        if (this.testRealmReps == null) {
            this.testRealmReps = new ArrayList<RealmRepresentation>();
        }
        if (this.testRealmReps.isEmpty()) {
            this.addTestRealms(this.testRealmReps);
        }
    }

    public void importTestRealms() {
        this.addTestRealms();
        this.log.info((Object)"importing test realms");
        for (RealmRepresentation testRealm : this.testRealmReps) {
            this.importRealm(testRealm);
        }
    }

    public void removeTestRealms() {
        this.log.info((Object)"removing test realms");
        for (RealmRepresentation testRealm : this.testRealmReps) {
            this.removeRealm(testRealm);
        }
    }

    private UserRepresentation createAdminUserRepresentation() {
        UserRepresentation adminUserRep = new UserRepresentation();
        adminUserRep.setUsername("admin");
        Users.setPasswordFor((UserRepresentation)adminUserRep, (String)"admin");
        return adminUserRep;
    }

    public void importRealm(RealmRepresentation realm) {
        this.log.debug((Object)("importing realm: " + realm.getRealm()));
        try {
            RealmResource realmResource = this.adminClient.realms().realm(realm.getRealm());
            RealmRepresentation rRep = realmResource.toRepresentation();
            this.log.debug((Object)"realm already exists on server, re-importing");
            realmResource.remove();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.adminClient.realms().create(realm);
    }

    public void removeRealm(RealmRepresentation realm) {
        try {
            this.adminClient.realms().realm(realm.getRealm()).remove();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public RealmsResource realmsResouce() {
        return this.adminClient.realms();
    }

    public void createRealm(String realm) {
        try {
            RealmResource realmResource = this.adminClient.realms().realm(realm);
            RealmRepresentation realmRepresentation = realmResource.toRepresentation();
        }
        catch (NotFoundException ex) {
            RealmRepresentation realmRepresentation = new RealmRepresentation();
            realmRepresentation.setRealm(realm);
            realmRepresentation.setEnabled(Boolean.valueOf(true));
            realmRepresentation.setRegistrationAllowed(Boolean.valueOf(true));
            this.adminClient.realms().create(realmRepresentation);
        }
    }

    public String createUser(String realm, String username, String password, String ... requiredActions) {
        List<String> requiredUserActions = Arrays.asList(requiredActions);
        UserRepresentation homer = new UserRepresentation();
        homer.setEnabled(Boolean.valueOf(true));
        homer.setUsername(username);
        homer.setRequiredActions(requiredUserActions);
        return ApiUtil.createUserAndResetPasswordWithAdminClient(this.adminClient.realm(realm), homer, password);
    }

    public void setRequiredActionEnabled(String realm, String requiredAction, boolean enabled, boolean defaultAction) {
        AuthenticationManagementResource managementResource = this.adminClient.realm(realm).flows();
        RequiredActionProviderRepresentation action = managementResource.getRequiredAction(requiredAction);
        action.setEnabled(enabled);
        action.setDefaultAction(defaultAction);
        managementResource.updateRequiredAction(requiredAction, action);
    }

    public void setRequiredActionEnabled(String realm, String userId, String requiredAction, boolean enabled) {
        UsersResource usersResource = this.adminClient.realm(realm).users();
        UserResource userResource = usersResource.get(userId);
        UserRepresentation userRepresentation = userResource.toRepresentation();
        List requiredActions = userRepresentation.getRequiredActions();
        if (enabled && !requiredActions.contains(requiredAction)) {
            requiredActions.add(requiredAction);
        } else if (!enabled && requiredActions.contains(requiredAction)) {
            requiredActions.remove(requiredAction);
        }
        userResource.update(userRepresentation);
    }

    public void setTimeOffset(int offset) {
        String response = this.invokeTimeOffset(offset);
        this.resetTimeOffset = offset != 0;
        this.log.debugv("Set time offset, response {0}", (Object)response);
    }

    public void resetTimeOffset() {
        String response = this.invokeTimeOffset(0);
        this.resetTimeOffset = false;
        this.log.debugv("Reset time offset, response {0}", (Object)response);
    }

    public int getCurrentTime() {
        return Time.currentTime();
    }

    private String invokeTimeOffset(int offset) {
        Time.setOffset((int)offset);
        Map result = this.testingClient.testing().setTimeOffset(Collections.singletonMap("offset", String.valueOf(offset)));
        return String.valueOf(result);
    }

    private void loadConstantsProperties() throws ConfigurationException {
        this.constantsProperties = new PropertiesConfiguration(System.getProperty("testsuite.constants"));
        this.constantsProperties.setThrowExceptionOnMissing(true);
    }

    protected PropertiesConfiguration getConstantsProperties() throws ConfigurationException {
        if (this.constantsProperties == null) {
            this.loadConstantsProperties();
        }
        return this.constantsProperties;
    }

    public URI getAuthServerRoot() {
        try {
            return KeycloakUriBuilder.fromUri((URI)this.suiteContext.getAuthServerInfo().getContextRoot().toURI()).path("/auth/").build(new Object[0]);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

