/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ConfigPropertyRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserFederationProviderFactoryRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

public class Assert
extends org.junit.Assert {
    public static <T> void assertNames(Set<T> actual, String ... expected) {
        Arrays.sort(expected);
        Object[] actualNames = Assert.names(new LinkedList<T>(actual));
        Assert.assertArrayEquals((String)("Expected: " + Arrays.toString(expected) + ", was: " + Arrays.toString(actualNames)), (Object[])expected, (Object[])actualNames);
    }

    public static <T> void assertNames(List<T> actual, String ... expected) {
        Arrays.sort(expected);
        Object[] actualNames = Assert.names(actual);
        Assert.assertArrayEquals((String)("Expected: " + Arrays.toString(expected) + ", was: " + Arrays.toString(actualNames)), (Object[])expected, (Object[])actualNames);
    }

    private static <T> String[] names(List<T> list) {
        Object[] names = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            names[i] = Assert.name(list.get(i));
        }
        Arrays.sort(names);
        return names;
    }

    private static String name(Object o1) {
        if (o1 instanceof String) {
            return (String)o1;
        }
        if (o1 instanceof RealmRepresentation) {
            return ((RealmRepresentation)o1).getRealm();
        }
        if (o1 instanceof ClientRepresentation) {
            return ((ClientRepresentation)o1).getClientId();
        }
        if (o1 instanceof IdentityProviderRepresentation) {
            return ((IdentityProviderRepresentation)o1).getAlias();
        }
        if (o1 instanceof RoleRepresentation) {
            return ((RoleRepresentation)o1).getName();
        }
        if (o1 instanceof UserRepresentation) {
            return ((UserRepresentation)o1).getUsername();
        }
        if (o1 instanceof UserFederationProviderFactoryRepresentation) {
            return ((UserFederationProviderFactoryRepresentation)o1).getId();
        }
        throw new IllegalArgumentException();
    }

    public static void assertMap(Map<String, String> config, String ... expected) {
        if (expected == null) {
            expected = new String[]{};
        }
        Assert.assertEquals((long)(config.size() * 2), (long)expected.length);
        for (int i = 0; i < expected.length; i += 2) {
            String key = expected[i];
            String value = expected[i + 1];
            Assert.assertEquals((Object)value, (Object)config.get(key));
        }
    }

    public static void assertProviderConfigProperty(ConfigPropertyRepresentation property, String name, String label, String defaultValue, String helpText, String type) {
        Assert.assertEquals((Object)name, (Object)property.getName());
        Assert.assertEquals((Object)label, (Object)property.getLabel());
        Assert.assertEquals((Object)defaultValue, (Object)property.getDefaultValue());
        Assert.assertEquals((Object)helpText, (Object)property.getHelpText());
        Assert.assertEquals((Object)type, (Object)property.getType());
    }
}

