/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runners.model.Statement;
import org.keycloak.events.EventType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;

public class AssertEvents
implements TestRule {
    public static final String DEFAULT_CLIENT_ID = "test-app";
    public static final String DEFAULT_IP_ADDRESS = "127.0.0.1";
    public static final String DEFAULT_REALM = "test";
    public static final String DEFAULT_USERNAME = "test-user@localhost";
    String defaultRedirectUri = "http://localhost:8180/auth/realms/master/app/auth";
    private AbstractKeycloakTest context;

    public AssertEvents(AbstractKeycloakTest ctx) {
        this.context = ctx;
    }

    public Statement apply(final Statement base, org.junit.runner.Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                AssertEvents.this.context.getTestingClient().testing().clearEventQueue();
                base.evaluate();
            }
        };
    }

    public EventRepresentation poll() {
        EventRepresentation event = this.fetchNextEvent();
        Assert.assertNotNull((String)"Event expected", (Object)event);
        return event;
    }

    public void assertEmpty() {
        EventRepresentation event = this.fetchNextEvent();
        Assert.assertNull((String)("Empty event queue expected, but there is " + event), (Object)event);
    }

    public void clear() {
        try (Response res = this.context.testingClient.testing().clearEventQueue();){
            Assert.assertEquals((String)"clear-event-queue success", (long)res.getStatus(), (long)200L);
        }
    }

    public ExpectedEvent expectRequiredAction(EventType event) {
        return this.expectLogin().event(event).removeDetail("consent").session(AssertEvents.isUUID());
    }

    public ExpectedEvent expectLogin() {
        return this.expect(EventType.LOGIN).detail("code_id", AssertEvents.isCodeId()).detail("redirect_uri", this.defaultRedirectUri).detail("consent", "no_consent_required").session(AssertEvents.isUUID());
    }

    public ExpectedEvent expectClientLogin() {
        return this.expect(EventType.CLIENT_LOGIN).detail("code_id", AssertEvents.isCodeId()).detail("client_auth_method", "client-secret").detail("grant_type", "client_credentials").removeDetail("code_id").session(AssertEvents.isUUID());
    }

    public ExpectedEvent expectSocialLogin() {
        return this.expect(EventType.LOGIN).detail("code_id", AssertEvents.isCodeId()).detail("username", DEFAULT_USERNAME).detail("auth_method", "form").detail("redirect_uri", this.defaultRedirectUri).session(AssertEvents.isUUID());
    }

    public ExpectedEvent expectCodeToToken(String codeId, String sessionId) {
        return this.expect(EventType.CODE_TO_TOKEN).detail("code_id", codeId).detail("token_id", AssertEvents.isUUID()).detail("refresh_token_id", AssertEvents.isUUID()).detail("refresh_token_type", "Refresh").detail("client_auth_method", "client-secret").session(sessionId);
    }

    public ExpectedEvent expectRefresh(String refreshTokenId, String sessionId) {
        return this.expect(EventType.REFRESH_TOKEN).detail("token_id", AssertEvents.isUUID()).detail("refresh_token_id", refreshTokenId).detail("refresh_token_type", "Refresh").detail("updated_refresh_token_id", AssertEvents.isUUID()).detail("client_auth_method", "client-secret").session(sessionId);
    }

    public ExpectedEvent expectLogout(String sessionId) {
        return this.expect(EventType.LOGOUT).client((String)null).detail("redirect_uri", this.defaultRedirectUri).session(sessionId);
    }

    public ExpectedEvent expectRegister(String username, String email) {
        UserRepresentation user = username != null ? this.getUser(username) : null;
        return this.expect(EventType.REGISTER).user(user != null ? user.getId() : null).detail("username", username).detail("email", email).detail("register_method", "form").detail("redirect_uri", this.defaultRedirectUri);
    }

    public ExpectedEvent expectAccount(EventType event) {
        return this.expect(event).client("account");
    }

    public ExpectedEvent expect(EventType event) {
        return new ExpectedEvent().realm(this.defaultRealmId()).client(DEFAULT_CLIENT_ID).user(this.defaultUserId()).ipAddress(DEFAULT_IP_ADDRESS).session((String)null).event(event);
    }

    public static Matcher<String> isCodeId() {
        return AssertEvents.isUUID();
    }

    public static Matcher<String> isUUID() {
        return new TypeSafeMatcher<String>(){

            protected boolean matchesSafely(String item) {
                return 36 == item.length() && item.charAt(8) == '-' && item.charAt(13) == '-' && item.charAt(18) == '-' && item.charAt(23) == '-';
            }

            public void describeTo(Description description) {
                description.appendText("Not an UUID");
            }
        };
    }

    public Matcher<String> defaultRealmId() {
        return new TypeSafeMatcher<String>(){
            private String realmId;

            protected boolean matchesSafely(String item) {
                return item.equals(this.getRealmId());
            }

            public void describeTo(Description description) {
                description.appendText(this.getRealmId());
            }

            private String getRealmId() {
                if (this.realmId == null) {
                    RealmRepresentation realm = ((AssertEvents)AssertEvents.this).context.adminClient.realm(AssertEvents.DEFAULT_REALM).toRepresentation();
                    if (realm == null) {
                        throw new RuntimeException("Default user does not exist: test-user@localhost. Make sure to add it to your test realm.");
                    }
                    this.realmId = realm.getId();
                }
                return this.realmId;
            }
        };
    }

    public Matcher<String> defaultUserId() {
        return new TypeSafeMatcher<String>(){
            private String userId;

            protected boolean matchesSafely(String item) {
                return item.equals(this.getUserId());
            }

            public void describeTo(Description description) {
                description.appendText(this.getUserId());
            }

            private String getUserId() {
                if (this.userId == null) {
                    UserRepresentation user = AssertEvents.this.getUser(AssertEvents.DEFAULT_USERNAME);
                    if (user == null) {
                        throw new RuntimeException("Default user does not exist: test-user@localhost. Make sure to add it to your test realm.");
                    }
                    this.userId = user.getId();
                }
                return this.userId;
            }
        };
    }

    private UserRepresentation getUser(String username) {
        List users = this.context.adminClient.realm(DEFAULT_REALM).users().search(username, null, null, null, Integer.valueOf(0), Integer.valueOf(1));
        return users.isEmpty() ? null : (UserRepresentation)users.get(0);
    }

    private EventRepresentation fetchNextEvent() {
        return this.context.testingClient.testing().pollEvent();
    }

    public class ExpectedEvent {
        private EventRepresentation expected = new EventRepresentation();
        private Matcher<String> realmId;
        private Matcher<String> userId;
        private Matcher<String> sessionId;
        private HashMap<String, Matcher<String>> details;

        public ExpectedEvent realm(Matcher<String> realmId) {
            this.realmId = realmId;
            return this;
        }

        public ExpectedEvent realm(RealmRepresentation realm) {
            return this.realm((Matcher<String>)CoreMatchers.equalTo((Object)realm.getId()));
        }

        public ExpectedEvent realm(String realmId) {
            return this.realm((Matcher<String>)CoreMatchers.equalTo((Object)realmId));
        }

        public ExpectedEvent client(ClientRepresentation client) {
            this.expected.setClientId(client.getClientId());
            return this;
        }

        public ExpectedEvent client(String clientId) {
            this.expected.setClientId(clientId);
            return this;
        }

        public ExpectedEvent user(UserRepresentation user) {
            return this.user(user.getId());
        }

        public ExpectedEvent user(String userId) {
            return this.user((Matcher<String>)CoreMatchers.equalTo((Object)userId));
        }

        public ExpectedEvent user(Matcher<String> userId) {
            this.userId = userId;
            return this;
        }

        public ExpectedEvent session(UserSessionRepresentation session) {
            return this.session(session.getId());
        }

        public ExpectedEvent session(String sessionId) {
            return this.session((Matcher<String>)CoreMatchers.equalTo((Object)sessionId));
        }

        public ExpectedEvent session(Matcher<String> sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public ExpectedEvent ipAddress(String ipAddress) {
            this.expected.setIpAddress(ipAddress);
            return this;
        }

        public ExpectedEvent event(EventType e) {
            this.expected.setType(e.name());
            return this;
        }

        public ExpectedEvent detail(String key, String value) {
            return this.detail(key, (Matcher<String>)CoreMatchers.equalTo((Object)value));
        }

        public ExpectedEvent detail(String key, Matcher<String> matcher) {
            if (this.details == null) {
                this.details = new HashMap();
            }
            this.details.put(key, matcher);
            return this;
        }

        public ExpectedEvent removeDetail(String key) {
            if (this.details != null) {
                this.details.remove(key);
            }
            return this;
        }

        public ExpectedEvent clearDetails() {
            if (this.details != null) {
                this.details.clear();
            }
            return this;
        }

        public ExpectedEvent error(String error) {
            this.expected.setError(error);
            return this;
        }

        public EventRepresentation assertEvent() {
            return this.assertEvent(AssertEvents.this.poll());
        }

        public EventRepresentation assertEvent(EventRepresentation actual) {
            if (this.expected.getError() != null && !this.expected.getType().toString().endsWith("_ERROR")) {
                this.expected.setType(this.expected.getType() + "_ERROR");
            }
            Assert.assertEquals((Object)this.expected.getType(), (Object)actual.getType());
            Assert.assertThat((Object)actual.getRealmId(), this.realmId);
            Assert.assertEquals((Object)this.expected.getClientId(), (Object)actual.getClientId());
            Assert.assertEquals((Object)this.expected.getError(), (Object)actual.getError());
            Assert.assertEquals((Object)this.expected.getIpAddress(), (Object)actual.getIpAddress());
            Assert.assertThat((Object)actual.getUserId(), this.userId);
            Assert.assertThat((Object)actual.getSessionId(), this.sessionId);
            if (this.details != null && !this.details.isEmpty()) {
                Assert.assertNotNull((Object)actual.getDetails());
                for (Map.Entry<String, Matcher<String>> d : this.details.entrySet()) {
                    String actualValue = (String)actual.getDetails().get(d.getKey());
                    if (!actual.getDetails().containsKey(d.getKey())) {
                        Assert.fail((String)(d.getKey() + " missing"));
                    }
                    Assert.assertThat((String)("Unexpected value for " + d.getKey()), (Object)actualValue, d.getValue());
                }
            }
            return actual;
        }
    }
}

