/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.account;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.events.EventType;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.resources.AccountService;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.TestRealmKeycloakTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.drone.Different;
import org.keycloak.testsuite.pages.AccountApplicationsPage;
import org.keycloak.testsuite.pages.AccountLogPage;
import org.keycloak.testsuite.pages.AccountPasswordPage;
import org.keycloak.testsuite.pages.AccountSessionsPage;
import org.keycloak.testsuite.pages.AccountTotpPage;
import org.keycloak.testsuite.pages.AccountUpdateProfilePage;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.RegisterPage;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserBuilder;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class AccountTest
extends TestRealmKeycloakTest {
    private static final UriBuilder BASE = UriBuilder.fromUri((String)"http://localhost:8180/auth");
    private static final String ACCOUNT_URL = RealmsResource.accountUrl((UriBuilder)BASE.clone()).build(new Object[]{"test"}).toString();
    public static String ACCOUNT_REDIRECT = AccountService.loginRedirectUrl((UriBuilder)BASE.clone()).build(new Object[]{"test"}).toString();
    @Drone
    @Different
    WebDriver driver2;
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected RegisterPage registerPage;
    @Page
    protected AccountPasswordPage changePasswordPage;
    @Page
    protected AccountUpdateProfilePage profilePage;
    @Page
    protected AccountTotpPage totpPage;
    @Page
    protected AccountLogPage logPage;
    @Page
    protected AccountSessionsPage sessionsPage;
    @Page
    protected AccountApplicationsPage applicationsPage;
    @Page
    protected ErrorPage errorPage;
    private TimeBasedOTP totp = new TimeBasedOTP();
    private String userId;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        UserRepresentation user2 = UserBuilder.create().enabled(true).username("test-user-no-access@localhost").email("test-user-no-access@localhost").password("password").build();
        RealmBuilder.edit(testRealm).user(user2);
    }

    @Before
    public void before() {
        this.oauth.state("mystate");
        this.userId = this.findUser("test-user@localhost").getId();
    }

    @Test
    public void returnToAppFromQueryParam() {
        this.driver.navigate().to(this.profilePage.getPath() + "?referrer=test-app");
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.profilePage.isCurrent());
        this.profilePage.backToApplication();
        Assert.assertTrue((boolean)this.appPage.isCurrent());
        this.driver.navigate().to(this.profilePage.getPath() + "?referrer=test-app&referrer_uri=http://localhost:8180/auth/realms/master/app/auth?test");
        Assert.assertTrue((boolean)this.profilePage.isCurrent());
        this.profilePage.backToApplication();
        Assert.assertTrue((boolean)this.appPage.isCurrent());
        Assert.assertEquals((Object)("http://localhost:8180/auth/realms/master/app/auth" + "?test"), (Object)this.driver.getCurrentUrl());
        this.driver.navigate().to(this.profilePage.getPath() + "?referrer=test-app");
        Assert.assertTrue((boolean)this.profilePage.isCurrent());
        this.driver.findElement(By.linkText((String)"Authenticator")).click();
        Assert.assertTrue((boolean)this.totpPage.isCurrent());
        this.driver.findElement(By.linkText((String)"Account")).click();
        Assert.assertTrue((boolean)this.profilePage.isCurrent());
        this.profilePage.backToApplication();
        Assert.assertTrue((boolean)this.appPage.isCurrent());
        this.events.clear();
    }

    @Test
    public void changePassword() {
        this.changePasswordPage.open();
        this.loginPage.login("test-user@localhost", "password");
        EventRepresentation event = this.events.expectLogin().client("account").detail("redirect_uri", ACCOUNT_REDIRECT + "?path=password").assertEvent();
        String sessionId = event.getSessionId();
        String userId = event.getUserId();
        this.changePasswordPage.changePassword("", "new-password", "new-password");
        Assert.assertEquals((Object)"Please specify password.", (Object)this.profilePage.getError());
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).error("password_missing").assertEvent();
        this.changePasswordPage.changePassword("password", "new-password", "new-password2");
        Assert.assertEquals((Object)"Password confirmation doesn't match.", (Object)this.profilePage.getError());
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).error("password_confirm_error").assertEvent();
        this.changePasswordPage.changePassword("password", "new-password", "new-password");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_PASSWORD).assertEvent();
        this.changePasswordPage.logout();
        this.events.expectLogout(sessionId).detail("redirect_uri", this.changePasswordPage.getPath()).assertEvent();
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getError());
        this.events.expectLogin().session((String)null).error("invalid_user_credentials").removeDetail("consent").assertEvent();
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "new-password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().assertEvent();
    }

    private void setPasswordPolicy(String policy) {
        RealmRepresentation testRealm = this.testRealm().toRepresentation();
        testRealm.setPasswordPolicy(policy);
        this.testRealm().update(testRealm);
    }

    @Test
    public void changePasswordWithBlankCurrentPassword() {
        this.changePasswordPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", ACCOUNT_REDIRECT + "?path=password").assertEvent();
        this.changePasswordPage.changePassword("", "new", "new");
        Assert.assertEquals((Object)"Please specify password.", (Object)this.profilePage.getError());
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).error("password_missing").assertEvent();
        this.changePasswordPage.changePassword("password", "new", "new");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_PASSWORD).assertEvent();
    }

    @Test
    public void changePasswordWithLengthPasswordPolicy() {
        this.setPasswordPolicy("length(8)");
        this.changePasswordPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", ACCOUNT_REDIRECT + "?path=password").assertEvent();
        this.changePasswordPage.changePassword("password", "1234", "1234");
        Assert.assertEquals((Object)"Invalid password: minimum length 8.", (Object)this.profilePage.getError());
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).error("password_rejected").assertEvent();
        this.changePasswordPage.changePassword("password", "12345678", "12345678");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_PASSWORD).assertEvent();
    }

    @Test
    public void changePasswordWithDigitsPolicy() {
        this.setPasswordPolicy("digits(2)");
        this.changePasswordPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", ACCOUNT_REDIRECT + "?path=password").assertEvent();
        this.changePasswordPage.changePassword("password", "invalidPassword1", "invalidPassword1");
        Assert.assertEquals((Object)"Invalid password: must contain at least 2 numerical digits.", (Object)this.profilePage.getError());
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).error("password_rejected").assertEvent();
        this.changePasswordPage.changePassword("password", "validPassword12", "validPassword12");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_PASSWORD).assertEvent();
    }

    @Test
    public void changePasswordWithLowerCasePolicy() {
        this.setPasswordPolicy("lowerCase(2)");
        this.changePasswordPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", ACCOUNT_REDIRECT + "?path=password").assertEvent();
        this.changePasswordPage.changePassword("password", "iNVALIDPASSWORD", "iNVALIDPASSWORD");
        Assert.assertEquals((Object)"Invalid password: must contain at least 2 lower case characters.", (Object)this.profilePage.getError());
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).error("password_rejected").assertEvent();
        this.changePasswordPage.changePassword("password", "vaLIDPASSWORD", "vaLIDPASSWORD");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_PASSWORD).assertEvent();
    }

    @Test
    public void changePasswordWithUpperCasePolicy() {
        this.setPasswordPolicy("upperCase(2)");
        this.changePasswordPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", ACCOUNT_REDIRECT + "?path=password").assertEvent();
        this.changePasswordPage.changePassword("password", "Invalidpassword", "Invalidpassword");
        Assert.assertEquals((Object)"Invalid password: must contain at least 2 upper case characters.", (Object)this.profilePage.getError());
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).error("password_rejected").assertEvent();
        this.changePasswordPage.changePassword("password", "VAlidpassword", "VAlidpassword");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_PASSWORD).assertEvent();
    }

    @Test
    public void changePasswordWithSpecialCharsPolicy() {
        this.setPasswordPolicy("specialChars(2)");
        this.changePasswordPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", ACCOUNT_REDIRECT + "?path=password").assertEvent();
        this.changePasswordPage.changePassword("password", "invalidPassword*", "invalidPassword*");
        Assert.assertEquals((Object)"Invalid password: must contain at least 2 special characters.", (Object)this.profilePage.getError());
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).error("password_rejected").assertEvent();
        this.changePasswordPage.changePassword("password", "validPassword*#", "validPassword*#");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_PASSWORD).assertEvent();
    }

    @Test
    public void changePasswordWithNotUsernamePolicy() {
        this.setPasswordPolicy("notUsername(1)");
        this.changePasswordPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", ACCOUNT_REDIRECT + "?path=password").assertEvent();
        this.changePasswordPage.changePassword("password", "test-user@localhost", "test-user@localhost");
        Assert.assertEquals((Object)"Invalid password: must not be equal to the username.", (Object)this.profilePage.getError());
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).error("password_rejected").assertEvent();
        this.changePasswordPage.changePassword("password", "newPassword", "newPassword");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_PASSWORD).assertEvent();
    }

    @Test
    public void changePasswordWithRegexPatternsPolicy() {
        this.setPasswordPolicy("regexPattern(^[A-Z]+#[a-z]{8}$)");
        this.changePasswordPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", ACCOUNT_REDIRECT + "?path=password").assertEvent();
        this.changePasswordPage.changePassword("password", "invalidPassword", "invalidPassword");
        Assert.assertEquals((Object)"Invalid password: fails to match regex pattern(s).", (Object)this.profilePage.getError());
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).error("password_rejected").assertEvent();
        this.changePasswordPage.changePassword("password", "VALID#password", "VALID#password");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_PASSWORD).assertEvent();
    }

    @Test
    public void changePasswordWithPasswordHistoryPolicy() {
        this.setPasswordPolicy("passwordHistory(2)");
        this.changePasswordPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", ACCOUNT_REDIRECT + "?path=password").assertEvent();
        this.changePasswordPage.changePassword("password", "password", "password");
        Assert.assertEquals((Object)"Invalid password: must not be equal to any of last 2 passwords.", (Object)this.profilePage.getError());
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).error("password_rejected").assertEvent();
        this.changePasswordPage.changePassword("password", "password1", "password1");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_PASSWORD).assertEvent();
        this.changePasswordPage.changePassword("password1", "password", "password");
        Assert.assertEquals((Object)"Invalid password: must not be equal to any of last 2 passwords.", (Object)this.profilePage.getError());
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).error("password_rejected").assertEvent();
        this.changePasswordPage.changePassword("password1", "password1", "password1");
        Assert.assertEquals((Object)"Invalid password: must not be equal to any of last 2 passwords.", (Object)this.profilePage.getError());
        this.events.expectAccount(EventType.UPDATE_PASSWORD_ERROR).error("password_rejected").assertEvent();
        this.changePasswordPage.changePassword("password1", "password2", "password2");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_PASSWORD).assertEvent();
    }

    @Test
    public void changeProfile() {
        this.profilePage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", ACCOUNT_REDIRECT).assertEvent();
        Assert.assertEquals((Object)"Tom", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"Brady", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.profilePage.getEmail());
        this.profilePage.updateProfile("", "New last", "new@email.com");
        Assert.assertEquals((Object)"Please specify first name.", (Object)this.profilePage.getError());
        Assert.assertEquals((Object)"", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.profilePage.getEmail());
        this.events.assertEmpty();
        this.profilePage.updateProfile("New first", "", "new@email.com");
        Assert.assertEquals((Object)"Please specify last name.", (Object)this.profilePage.getError());
        Assert.assertEquals((Object)"New first", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.profilePage.getEmail());
        this.events.assertEmpty();
        this.profilePage.updateProfile("New first", "New last", "");
        Assert.assertEquals((Object)"Please specify email.", (Object)this.profilePage.getError());
        Assert.assertEquals((Object)"New first", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"", (Object)this.profilePage.getEmail());
        this.events.assertEmpty();
        this.profilePage.clickCancel();
        Assert.assertEquals((Object)"Tom", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"Brady", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.profilePage.getEmail());
        this.events.assertEmpty();
        this.profilePage.updateProfile("New first", "New last", "new@email.com");
        Assert.assertEquals((Object)"Your account has been updated.", (Object)this.profilePage.getSuccess());
        Assert.assertEquals((Object)"New first", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.profilePage.getEmail());
        this.events.expectAccount(EventType.UPDATE_PROFILE).assertEvent();
        this.events.expectAccount(EventType.UPDATE_EMAIL).detail("previous_email", "test-user@localhost").detail("updated_email", "new@email.com").assertEvent();
        this.profilePage.updateProfile("Tom", "Brady", "test-user@localhost");
        this.events.clear();
    }

    private void setEditUsernameAllowed() {
        RealmRepresentation testRealm = this.testRealm().toRepresentation();
        testRealm.setEditUsernameAllowed(Boolean.valueOf(true));
        this.testRealm().update(testRealm);
    }

    @Test
    public void changeUsername() {
        this.setEditUsernameAllowed();
        this.profilePage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", ACCOUNT_REDIRECT).assertEvent();
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.profilePage.getUsername());
        Assert.assertEquals((Object)"Tom", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"Brady", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.profilePage.getEmail());
        this.profilePage.updateProfile("", "New first", "New last", "new@email.com");
        Assert.assertEquals((Object)"Please specify username.", (Object)this.profilePage.getError());
        Assert.assertEquals((Object)"", (Object)this.profilePage.getUsername());
        Assert.assertEquals((Object)"New first", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.profilePage.getEmail());
        this.events.assertEmpty();
        this.profilePage.updateProfile("test-user-no-access@localhost", "New first", "New last", "new@email.com");
        Assert.assertEquals((Object)"Username already exists.", (Object)this.profilePage.getError());
        Assert.assertEquals((Object)"test-user-no-access@localhost", (Object)this.profilePage.getUsername());
        Assert.assertEquals((Object)"New first", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.profilePage.getEmail());
        this.events.assertEmpty();
        this.profilePage.updateProfile("test-user-new@localhost", "New first", "New last", "new@email.com");
        Assert.assertEquals((Object)"Your account has been updated.", (Object)this.profilePage.getSuccess());
        Assert.assertEquals((Object)"test-user-new@localhost", (Object)this.profilePage.getUsername());
        Assert.assertEquals((Object)"New first", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.profilePage.getEmail());
    }

    private void addUser(String username, String email) {
        UserRepresentation user = UserBuilder.create().username(username).enabled(true).email(email).firstName("first").lastName("last").build();
        ApiUtil.createUserAndResetPasswordWithAdminClient(this.testRealm(), user, "password");
    }

    @Test
    public void changeUsernameLoginWithOldUsername() {
        this.addUser("change-username", "change-username@localhost");
        this.setEditUsernameAllowed();
        this.profilePage.open();
        this.loginPage.login("change-username", "password");
        this.profilePage.updateUsername("change-username-updated");
        Assert.assertEquals((Object)"Your account has been updated.", (Object)this.profilePage.getSuccess());
        this.profilePage.logout();
        this.profilePage.open();
        Assert.assertTrue((boolean)this.loginPage.isCurrent());
        this.loginPage.login("change-username", "password");
        Assert.assertTrue((boolean)this.loginPage.isCurrent());
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getError());
        this.loginPage.login("change-username-updated", "password");
    }

    @Test
    public void changeEmailLoginWithOldEmail() {
        this.addUser("change-email", "change-username@localhost");
        this.setEditUsernameAllowed();
        this.profilePage.open();
        this.loginPage.login("change-username@localhost", "password");
        this.profilePage.updateEmail("change-username-updated@localhost");
        Assert.assertEquals((Object)"Your account has been updated.", (Object)this.profilePage.getSuccess());
        this.profilePage.logout();
        this.profilePage.open();
        Assert.assertTrue((boolean)this.loginPage.isCurrent());
        this.loginPage.login("change-username@localhost", "password");
        Assert.assertTrue((boolean)this.loginPage.isCurrent());
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getError());
        this.loginPage.login("change-username-updated@localhost", "password");
    }

    @Test
    public void changeEmailToExisting() {
        this.profilePage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", ACCOUNT_REDIRECT).assertEvent();
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.profilePage.getUsername());
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.profilePage.getEmail());
        this.profilePage.updateProfile("New first", "New last", "test-user-no-access@localhost");
        this.profilePage.assertCurrent();
        Assert.assertEquals((Object)"Email already exists.", (Object)this.profilePage.getError());
        Assert.assertEquals((Object)"New first", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"test-user-no-access@localhost", (Object)this.profilePage.getEmail());
        this.events.assertEmpty();
        this.profilePage.updateProfile("New first", "New last", "test-user@localhost");
        Assert.assertEquals((Object)"Your account has been updated.", (Object)this.profilePage.getSuccess());
        Assert.assertEquals((Object)"New first", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.profilePage.getEmail());
        this.events.expectAccount(EventType.UPDATE_PROFILE).assertEvent();
        this.profilePage.updateProfile("Tom", "Brady", "test-user@localhost");
        this.events.expectAccount(EventType.UPDATE_PROFILE).assertEvent();
    }

    @Test
    public void setupTotp() {
        this.totpPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", ACCOUNT_REDIRECT + "?path=totp").assertEvent();
        Assert.assertTrue((boolean)this.totpPage.isCurrent());
        Assert.assertFalse((boolean)this.driver.getPageSource().contains("Remove Google"));
        this.totpPage.configure(this.totp.generateTOTP(this.totpPage.getTotpSecret() + "123"));
        Assert.assertEquals((Object)"Invalid authenticator code.", (Object)this.profilePage.getError());
        this.totpPage.configure(this.totp.generateTOTP(this.totpPage.getTotpSecret()));
        Assert.assertEquals((Object)"Mobile authenticator configured.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_TOTP).assertEvent();
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("pficon-delete"));
        this.totpPage.removeTotp();
        this.events.expectAccount(EventType.REMOVE_TOTP).assertEvent();
    }

    @Test
    public void changeProfileNoAccess() throws Exception {
        this.profilePage.open();
        this.loginPage.login("test-user-no-access@localhost", "password");
        UserRepresentation noAccessUser = this.findUser("test-user-no-access@localhost");
        this.events.expectLogin().client("account").user(noAccessUser.getId()).detail("username", "test-user-no-access@localhost").detail("redirect_uri", ACCOUNT_REDIRECT).assertEvent();
        Assert.assertTrue((boolean)this.errorPage.isCurrent());
        Assert.assertEquals((Object)"No access", (Object)this.errorPage.getError());
    }

    private void setEventsEnabled() {
        RealmRepresentation testRealm = this.testRealm().toRepresentation();
        testRealm.setEventsEnabled(true);
        this.testRealm().update(testRealm);
    }

    @Test
    public void viewLog() {
        this.setEventsEnabled();
        LinkedList<EventRepresentation> expectedEvents = new LinkedList<EventRepresentation>();
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.register("view", "log", "view-log@localhost", "view-log", "password", "password");
        expectedEvents.add(this.events.poll());
        expectedEvents.add(this.events.poll());
        this.profilePage.open();
        this.profilePage.updateProfile("view", "log2", "view-log@localhost");
        expectedEvents.add(this.events.poll());
        this.logPage.open();
        Assert.assertTrue((boolean)this.logPage.isCurrent());
        List actualEvents = this.logPage.getEvents();
        Assert.assertEquals((long)expectedEvents.size(), (long)actualEvents.size());
        for (EventRepresentation e : expectedEvents) {
            boolean match = false;
            for (List a : this.logPage.getEvents()) {
                if (!e.getType().toString().replace('_', ' ').toLowerCase().equals(a.get(1)) || !e.getIpAddress().equals(a.get(2)) || !e.getClientId().equals(a.get(3))) continue;
                match = true;
                break;
            }
            if (match) continue;
            Assert.fail((String)("Event not found " + e.getType()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sessions() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.register("view", "sessions", "view-sessions@localhost", "view-sessions", "password", "password");
        EventRepresentation registerEvent = this.events.expectRegister("view-sessions", "view-sessions@localhost").assertEvent();
        String userId = registerEvent.getUserId();
        this.events.expectLogin().user(userId).detail("username", "view-sessions").assertEvent();
        this.sessionsPage.open();
        Assert.assertTrue((boolean)this.sessionsPage.isCurrent());
        List sessions = this.sessionsPage.getSessions();
        Assert.assertEquals((long)1L, (long)sessions.size());
        Assert.assertEquals((Object)"127.0.0.1", ((List)sessions.get(0)).get(0));
        try {
            OAuthClient oauth2 = new OAuthClient();
            oauth2.init(this.adminClient, this.driver2);
            oauth2.state("mystate");
            oauth2.doLogin("view-sessions", "password");
            EventRepresentation login2Event = this.events.expectLogin().user(userId).detail("username", "view-sessions").assertEvent();
            this.sessionsPage.open();
            sessions = this.sessionsPage.getSessions();
            Assert.assertEquals((long)2L, (long)sessions.size());
            this.sessionsPage.logoutAll();
            this.events.expectLogout(registerEvent.getSessionId());
            this.events.expectLogout(login2Event.getSessionId());
        }
        finally {
            this.driver2.close();
        }
    }

    @Test
    public void applications() {
        this.applicationsPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", ACCOUNT_REDIRECT + "?path=applications").assertEvent();
        Assert.assertTrue((boolean)this.applicationsPage.isCurrent());
        Map apps = this.applicationsPage.getApplications();
        Assert.assertEquals((long)3L, (long)apps.size());
        AccountApplicationsPage.AppEntry accountEntry = (AccountApplicationsPage.AppEntry)apps.get("Account");
        Assert.assertEquals((long)2L, (long)accountEntry.getRolesAvailable().size());
        Assert.assertTrue((boolean)accountEntry.getRolesAvailable().contains("Manage account in Account"));
        Assert.assertTrue((boolean)accountEntry.getRolesAvailable().contains("View profile in Account"));
        Assert.assertEquals((long)1L, (long)accountEntry.getRolesGranted().size());
        Assert.assertTrue((boolean)accountEntry.getRolesGranted().contains("Full Access"));
        Assert.assertEquals((long)1L, (long)accountEntry.getProtocolMappersGranted().size());
        Assert.assertTrue((boolean)accountEntry.getProtocolMappersGranted().contains("Full Access"));
        AccountApplicationsPage.AppEntry testAppEntry = (AccountApplicationsPage.AppEntry)apps.get("test-app");
        Assert.assertEquals((long)5L, (long)testAppEntry.getRolesAvailable().size());
        Assert.assertTrue((boolean)testAppEntry.getRolesAvailable().contains("Offline access"));
        Assert.assertTrue((boolean)testAppEntry.getRolesGranted().contains("Full Access"));
        Assert.assertTrue((boolean)testAppEntry.getProtocolMappersGranted().contains("Full Access"));
        AccountApplicationsPage.AppEntry thirdPartyEntry = (AccountApplicationsPage.AppEntry)apps.get("third-party");
        Assert.assertEquals((long)2L, (long)thirdPartyEntry.getRolesAvailable().size());
        Assert.assertTrue((boolean)thirdPartyEntry.getRolesAvailable().contains("Have User privileges"));
        Assert.assertTrue((boolean)thirdPartyEntry.getRolesAvailable().contains("Have Customer User privileges in test-app"));
        Assert.assertEquals((long)0L, (long)thirdPartyEntry.getRolesGranted().size());
        Assert.assertEquals((long)0L, (long)thirdPartyEntry.getProtocolMappersGranted().size());
    }

    @Test
    public void loginToSpecificPage() {
        this.changePasswordPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.changePasswordPage.isCurrent());
        this.events.clear();
    }

    @Test
    public void loginToSpecificPageWithReferrer() {
        this.driver.navigate().to(this.changePasswordPage.getPath() + "?referrer=account");
        System.out.println(this.driver.getCurrentUrl());
        this.loginPage.login("test-user@localhost", "password");
        System.out.println(this.driver.getCurrentUrl());
        Assert.assertTrue((boolean)this.changePasswordPage.isCurrent());
        this.events.clear();
    }
}

