/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.account;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RoleMappingResource;
import org.keycloak.admin.client.resource.RoleScopeResource;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.testsuite.TestRealmKeycloakTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.pages.AccountApplicationsPage;
import org.keycloak.testsuite.pages.AccountUpdateProfilePage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.OAuthGrantPage;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RealmRepUtil;
import org.keycloak.testsuite.util.UserBuilder;
import org.openqa.selenium.JavascriptExecutor;
import twitter4j.JSONArray;
import twitter4j.JSONObject;

public class ProfileTest
extends TestRealmKeycloakTest {
    @Page
    protected AccountUpdateProfilePage profilePage;
    @Page
    protected AccountApplicationsPage accountApplicationsPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected OAuthGrantPage grantPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        UserRepresentation user = RealmRepUtil.findUser(testRealm, "test-user@localhost");
        user.setFirstName("First");
        user.setLastName("Last");
        HashMap<String, String> attributes = user.getAttributes();
        if (attributes == null) {
            attributes = new HashMap<String, String>();
            user.setAttributes(attributes);
        }
        attributes.put("key1", "value1");
        attributes.put("key2", "value2");
        UserRepresentation user2 = UserBuilder.create().enabled(true).username("test-user-no-access@localhost").password("password").build();
        RealmBuilder.edit(testRealm).user(user2);
        ClientBuilder.edit(RealmRepUtil.findClientByClientId(testRealm, "test-app")).addWebOrigin("http://localtest.me:8180");
    }

    private RoleRepresentation findViewProfileRole(ClientResource accountApp) {
        RoleMappingResource scopeMappings = accountApp.getScopeMappings();
        RoleScopeResource clientLevelMappings = scopeMappings.clientLevel(accountApp.toRepresentation().getId());
        List accountRoleList = clientLevelMappings.listEffective();
        for (RoleRepresentation role : accountRoleList) {
            if (!role.getName().equals("view-profile")) continue;
            return role;
        }
        return null;
    }

    @Before
    public void addScopeMappings() {
        String accountClientId = "account";
        ClientResource accountApp = ApiUtil.findClientByClientId(this.testRealm(), accountClientId);
        RoleRepresentation role = this.findViewProfileRole(accountApp);
        String accountAppId = accountApp.toRepresentation().getId();
        ClientResource app = ApiUtil.findClientByClientId(this.testRealm(), "test-app");
        app.getScopeMappings().clientLevel(accountAppId).add(Collections.singletonList(role));
        ClientResource thirdParty = ApiUtil.findClientByClientId(this.testRealm(), "third-party");
        thirdParty.getScopeMappings().clientLevel(accountAppId).add(Collections.singletonList(role));
    }

    @Test
    public void getProfile() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        String token = this.oauth.doAccessTokenRequest(code, "password").getAccessToken();
        HttpResponse response = this.doGetProfile(token, null);
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        JSONObject profile = new JSONObject(IOUtils.toString((InputStream)response.getEntity().getContent()));
        Assert.assertEquals((Object)"test-user@localhost", (Object)profile.getString("username"));
        Assert.assertEquals((Object)"test-user@localhost", (Object)profile.getString("email"));
        Assert.assertEquals((Object)"First", (Object)profile.getString("firstName"));
        Assert.assertEquals((Object)"Last", (Object)profile.getString("lastName"));
        JSONObject attributes = profile.getJSONObject("attributes");
        JSONArray attrValue = attributes.getJSONArray("key1");
        Assert.assertEquals((long)1L, (long)attrValue.length());
        Assert.assertEquals((Object)"value1", (Object)attrValue.get(0));
        attrValue = attributes.getJSONArray("key2");
        Assert.assertEquals((long)1L, (long)attrValue.length());
        Assert.assertEquals((Object)"value2", (Object)attrValue.get(0));
    }

    @Test
    public void getProfileCors() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        String token = this.oauth.doAccessTokenRequest(code, "password").getAccessToken();
        this.driver.navigate().to("http://localtest.me:8180/app");
        String[] response = this.doGetProfileJs(token);
        Assert.assertEquals((Object)"200", (Object)response[0]);
    }

    @Test
    public void getProfileCorsInvalidOrigin() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        String token = this.oauth.doAccessTokenRequest(code, "password").getAccessToken();
        this.driver.navigate().to("http://invalid.localtest.me:8180");
        try {
            this.doGetProfileJs(token);
            Assert.fail((String)"Expected failure");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Test
    public void getProfileCookieAuth() throws Exception {
        this.profilePage.open();
        this.loginPage.login("test-user@localhost", "password");
        String[] response = this.doGetProfileJs(null);
        Assert.assertEquals((Object)"200", (Object)response[0]);
        JSONObject profile = new JSONObject(response[1]);
        Assert.assertEquals((Object)"test-user@localhost", (Object)profile.getString("username"));
    }

    @Test
    public void getProfileNoAuth() throws Exception {
        HttpResponse response = this.doGetProfile(null, null);
        Assert.assertEquals((long)403L, (long)response.getStatusLine().getStatusCode());
    }

    @Test
    public void getProfileNoAccess() throws Exception {
        this.oauth.doLogin("test-user-no-access@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        String token = this.oauth.doAccessTokenRequest(code, "password").getAccessToken();
        HttpResponse response = this.doGetProfile(token, null);
        Assert.assertEquals((long)403L, (long)response.getStatusLine().getStatusCode());
    }

    @Test
    public void getProfileOAuthClient() throws Exception {
        this.oauth.clientId("third-party");
        this.oauth.doLoginGrant("test-user@localhost", "password");
        this.grantPage.accept();
        String token = this.oauth.doAccessTokenRequest((String)this.oauth.getCurrentQuery().get("code"), "password").getAccessToken();
        HttpResponse response = this.doGetProfile(token, null);
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        JSONObject profile = new JSONObject(IOUtils.toString((InputStream)response.getEntity().getContent()));
        Assert.assertEquals((Object)"test-user@localhost", (Object)profile.getString("username"));
        this.accountApplicationsPage.open();
        this.accountApplicationsPage.revokeGrant("third-party");
    }

    @Test
    public void getProfileOAuthClientNoScope() throws Exception {
        this.oauth.clientId("third-party");
        this.oauth.doLoginGrant("test-user@localhost", "password");
        String token = this.oauth.doAccessTokenRequest((String)this.oauth.getCurrentQuery().get("code"), "password").getAccessToken();
        HttpResponse response = this.doGetProfile(token, null);
        Assert.assertEquals((long)403L, (long)response.getStatusLine().getStatusCode());
    }

    private URI getAccountURI() {
        return RealmsResource.accountUrl((UriBuilder)UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT)).build(new Object[]{this.oauth.getRealm()});
    }

    private HttpResponse doGetProfile(String token, String origin) throws IOException {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet get = new HttpGet(UriBuilder.fromUri((URI)this.getAccountURI()).build(new Object[0]));
        if (token != null) {
            get.setHeader("Authorization", "bearer " + token);
        }
        if (origin != null) {
            get.setHeader("Origin", origin);
        }
        get.setHeader("Accept", "application/json");
        return client.execute((HttpUriRequest)get);
    }

    private String[] doGetProfileJs(String token) {
        StringBuilder sb = new StringBuilder();
        sb.append("var req = new XMLHttpRequest();\n");
        sb.append("req.open('GET', '" + this.getAccountURI().toString() + "', false);\n");
        if (token != null) {
            sb.append("req.setRequestHeader('Authorization', 'Bearer " + token + "');\n");
        }
        sb.append("req.setRequestHeader('Accept', 'application/json');\n");
        sb.append("req.send(null);\n");
        sb.append("return req.status + '///' + req.responseText;\n");
        JavascriptExecutor js = (JavascriptExecutor)this.driver;
        String response = (String)js.executeScript(sb.toString(), new Object[0]);
        return response.split("///");
    }
}

