/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.account;

import org.jboss.arquillian.graphene.page.Page;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.TestRealmKeycloakTest;
import org.keycloak.testsuite.auth.page.AuthRealm;
import org.keycloak.testsuite.auth.page.account.AccountManagement;
import org.keycloak.testsuite.auth.page.login.OIDCLogin;
import org.keycloak.testsuite.auth.page.login.VerifyEmail;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.MailAssert;
import org.keycloak.testsuite.util.RealmRepUtil;
import org.keycloak.testsuite.util.SslMailServer;
import org.keycloak.testsuite.util.URLAssert;

public class TrustStoreEmailTest
extends TestRealmKeycloakTest {
    @Page
    protected OIDCLogin testRealmLoginPage;
    @Page
    protected AuthRealm testRealmPage;
    @Page
    protected AccountManagement accountManagement;
    @Page
    private VerifyEmail testRealmVerifyEmailPage;
    private UserRepresentation user;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        this.log.info((Object)"enable verify email and configure smtp server to run with ssl in test realm");
        this.user = RealmRepUtil.findUser(testRealm, "test-user@localhost");
        testRealm.setSmtpServer(SslMailServer.getServerConfiguration());
        testRealm.setVerifyEmail(Boolean.valueOf(true));
    }

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testRealmPage.setAuthRealm("test");
        this.testRealmVerifyEmailPage.setAuthRealm(this.testRealmPage);
        this.accountManagement.setAuthRealm(this.testRealmPage);
        this.testRealmLoginPage.setAuthRealm(this.testRealmPage);
    }

    @After
    public void afterTrustStoreEmailTest() {
        SslMailServer.stop();
    }

    @Test
    public void verifyEmailWithSslEnabled() {
        SslMailServer.startWithSsl(this.getClass().getClassLoader().getResource("keystore/keycloak.jks").getFile());
        this.accountManagement.navigateTo();
        this.testRealmLoginPage.form().login(this.user.getUsername(), "password");
        Assert.assertEquals((Object)"You need to verify your email address to activate your account.", (Object)this.testRealmVerifyEmailPage.getFeedbackText());
        String verifyEmailUrl = MailAssert.assertEmailAndGetUrl("server@mail.test", this.user.getEmail(), "Someone has created a Test account with this email address.", true);
        this.log.info((Object)("navigating to url from email: " + verifyEmailUrl));
        this.driver.navigate().to(verifyEmailUrl);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.accountManagement);
        this.accountManagement.signOut();
        this.testRealmLoginPage.form().login(this.user);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.accountManagement);
    }

    @Test
    public void verifyEmailWithSslWrongCertificate() {
        SslMailServer.startWithSsl(this.getClass().getClassLoader().getResource("keystore/email_invalid.jks").getFile());
        this.accountManagement.navigateTo();
        this.loginPage.form().login(this.user);
        Assert.assertEquals((Object)"Failed to send email, please try again later.\n\u00ab Back to Application", (Object)this.testRealmVerifyEmailPage.getErrorMessage());
    }
}

