/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.account.custom;

import java.util.List;
import org.junit.Before;
import org.keycloak.admin.client.resource.AuthenticationManagementResource;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.testsuite.account.custom.AbstractAccountManagementTest;

public abstract class AbstractCustomAccountManagementTest
extends AbstractAccountManagementTest {
    private AuthenticationManagementResource authMgmtResource;

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
    }

    @Before
    public void beforeTest() {
        this.authMgmtResource = this.testRealmResource().flows();
    }

    protected AuthenticationManagementResource getAuthMgmtResource() {
        return this.authMgmtResource;
    }

    protected void updateRequirement(String flowAlias, String provider, AuthenticationExecutionModel.Requirement requirement) {
        AuthenticationExecutionInfoRepresentation exec = this.getExecution(flowAlias, provider);
        exec.setRequirement(requirement.name());
        this.authMgmtResource.updateExecutions(flowAlias, exec);
    }

    protected AuthenticationExecutionInfoRepresentation getExecution(String flowAlias, String provider) {
        List executionReps = this.authMgmtResource.getExecutions(flowAlias);
        for (AuthenticationExecutionInfoRepresentation exec : executionReps) {
            if (!provider.equals(exec.getProviderId())) continue;
            return exec;
        }
        return null;
    }
}

