/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.account.custom;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.testsuite.account.custom.AbstractCustomAccountManagementTest;
import org.keycloak.testsuite.util.OAuthClient;

public class CustomAuthFlowCookieTest
extends AbstractCustomAccountManagementTest {
    @Override
    @Before
    public void beforeTest() {
        super.beforeTest();
        ClientRepresentation testApp = new ClientRepresentation();
        testApp.setClientId("test-app");
        testApp.setEnabled(Boolean.valueOf(true));
        testApp.setBaseUrl(OAuthClient.APP_ROOT);
        testApp.setRedirectUris(Arrays.asList(OAuthClient.APP_ROOT + "/*"));
        testApp.setAdminUrl(OAuthClient.APP_ROOT + "/logout");
        testApp.setSecret("password");
        Assert.assertEquals((long)201L, (long)this.testRealmResource().clients().create(testApp).getStatus());
    }

    @Test
    public void cookieAlternative() {
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"AUTH_RESPONSE", (Object)this.driver.getTitle());
    }

    @Test
    public void disabledCookie() {
        this.updateRequirement("browser", "auth-cookie", AuthenticationExecutionModel.Requirement.DISABLED);
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"Log in to test", (Object)this.driver.getTitle());
    }
}

