/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.account.custom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.account.custom.AbstractCustomAccountManagementTest;
import org.keycloak.testsuite.admin.Users;
import org.keycloak.testsuite.auth.page.login.OneTimeCode;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.URLAssert;

public class CustomAuthFlowOTPTest
extends AbstractCustomAccountManagementTest {
    private final TimeBasedOTP totp = new TimeBasedOTP();
    @Page
    private OneTimeCode testLoginOneTimeCodePage;

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testLoginOneTimeCodePage.setAuthRealm(this.testRealmPage);
    }

    @Override
    @Before
    public void beforeTest() {
        super.beforeTest();
        ArrayList<String> requiredActions = new ArrayList<String>();
        requiredActions.add(UserModel.RequiredAction.CONFIGURE_TOTP.name());
        this.testUser.setRequiredActions(requiredActions);
        this.testRealmResource().users().get(this.testUser.getId()).update(this.testUser);
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        this.testRealmLoginPage.form().totpForm().waitForTotpInputFieldPresent();
        String totpSecret = this.testRealmLoginPage.form().totpForm().getTotpSecret();
        this.testRealmLoginPage.form().totpForm().setTotp(this.totp.generateTOTP(totpSecret));
        this.testRealmLoginPage.form().totpForm().submit();
        this.testRealmAccountManagementPage.signOut();
        this.testUser = this.testRealmResource().users().get(this.testUser.getId()).toRepresentation();
        Users.setPasswordFor((UserRepresentation)this.testUser, (String)"password");
        Assert.assertTrue((boolean)this.testUser.getRequiredActions().isEmpty());
    }

    @Test
    public void requireOTPTest() {
        this.updateRequirement("browser", "auth-otp-form", AuthenticationExecutionModel.Requirement.REQUIRED);
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        this.testRealmLoginPage.form().totpForm().waitForTotpInputFieldPresent();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testLoginOneTimeCodePage);
    }

    @Test
    public void conditionalOTPNoDefault() {
        HashMap<String, String> config = new HashMap<String, String>();
        this.setConditionalOTPForm(config);
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        this.testRealmLoginPage.form().totpForm().waitForTotpInputFieldPresent();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testLoginOneTimeCodePage);
    }

    @Test
    public void conditionalOTPDefaultSkip() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("defaultOtpOutcome", "skip");
        this.setConditionalOTPForm(config);
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmAccountManagementPage);
    }

    @Test
    public void conditionalOTPDefaultForce() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("defaultOtpOutcome", "force");
        this.setConditionalOTPForm(config);
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        this.testRealmLoginPage.form().totpForm().waitForTotpInputFieldPresent();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testLoginOneTimeCodePage);
    }

    @Test
    public void conditionalOTPUserAttributeSkip() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("otpControlAttribute", "userSkipAttribute");
        config.put("defaultOtpOutcome", "force");
        this.setConditionalOTPForm(config);
        HashMap userAttributes = new HashMap();
        ArrayList<String> attributeValues = new ArrayList<String>();
        attributeValues.add("skip");
        userAttributes.put("userSkipAttribute", attributeValues);
        this.testUser.setAttributes(userAttributes);
        this.testRealmResource().users().get(this.testUser.getId()).update(this.testUser);
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmAccountManagementPage);
    }

    @Test
    public void conditionalOTPUserAttributeForce() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("otpControlAttribute", "userSkipAttribute");
        config.put("defaultOtpOutcome", "skip");
        this.setConditionalOTPForm(config);
        HashMap userAttributes = new HashMap();
        ArrayList<String> attributeValues = new ArrayList<String>();
        attributeValues.add("force");
        userAttributes.put("userSkipAttribute", attributeValues);
        this.testUser.setAttributes(userAttributes);
        this.testRealmResource().users().get(this.testUser.getId()).update(this.testUser);
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        this.testRealmLoginPage.form().totpForm().waitForTotpInputFieldPresent();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testLoginOneTimeCodePage);
    }

    @Test
    public void conditionalOTPRoleSkip() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("skipOtpRole", "otp_role");
        config.put("defaultOtpOutcome", "force");
        this.setConditionalOTPForm(config);
        RoleRepresentation role = new RoleRepresentation("otp_role", "", false);
        this.testRealmResource().roles().create(role);
        role = this.testRealmResource().roles().get("otp_role").toRepresentation();
        ArrayList<RoleRepresentation> realmRoles = new ArrayList<RoleRepresentation>();
        realmRoles.add(role);
        this.testRealmResource().users().get(this.testUser.getId()).roles().realmLevel().add(realmRoles);
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmAccountManagementPage);
    }

    @Test
    public void conditionalOTPRoleForce() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("forceOtpRole", "otp_role");
        config.put("defaultOtpOutcome", "skip");
        this.setConditionalOTPForm(config);
        RoleRepresentation role = new RoleRepresentation("otp_role", "", false);
        this.testRealmResource().roles().create(role);
        role = this.testRealmResource().roles().get("otp_role").toRepresentation();
        ArrayList<RoleRepresentation> realmRoles = new ArrayList<RoleRepresentation>();
        realmRoles.add(role);
        this.testRealmResource().users().get(this.testUser.getId()).roles().realmLevel().add(realmRoles);
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        this.testRealmLoginPage.form().totpForm().waitForTotpInputFieldPresent();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testLoginOneTimeCodePage);
    }

    @Test
    public void conditionalOTPRequestHeaderSkip() {
        HashMap<String, String> config = new HashMap<String, String>();
        String port = System.getProperty("auth.server.http.port", "8180");
        config.put("noOtpRequiredForHeaderPattern", "Host: localhost:" + port);
        config.put("defaultOtpOutcome", "force");
        this.setConditionalOTPForm(config);
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmAccountManagementPage);
    }

    @Test
    public void conditionalOTPRequestHeaderForce() {
        HashMap<String, String> config = new HashMap<String, String>();
        String port = System.getProperty("auth.server.http.port", "8180");
        config.put("forceOtpForHeaderPattern", "Host: localhost:" + port);
        config.put("defaultOtpOutcome", "skip");
        this.setConditionalOTPForm(config);
        this.testRealmAccountManagementPage.navigateTo();
        this.testRealmLoginPage.form().login(this.testUser);
        this.testRealmLoginPage.form().totpForm().waitForTotpInputFieldPresent();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testLoginOneTimeCodePage);
    }

    private void setConditionalOTPForm(Map<String, String> config) {
        String flowAlias = "ConditionalOTPFlow";
        String provider = "auth-conditional-otp-form";
        AuthenticationFlowRepresentation flow = new AuthenticationFlowRepresentation();
        flow.setAlias(flowAlias);
        flow.setDescription("");
        flow.setProviderId("basic-flow");
        flow.setTopLevel(true);
        flow.setBuiltIn(false);
        Response response = this.getAuthMgmtResource().createFlow(flow);
        Assert.assertEquals((String)(flowAlias + " create success"), (long)201L, (long)response.getStatus());
        response.close();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("provider", "auth-username-password-form");
        this.getAuthMgmtResource().addExecution(flowAlias, data);
        this.updateRequirement(flowAlias, "auth-username-password-form", AuthenticationExecutionModel.Requirement.REQUIRED);
        data.clear();
        data.put("provider", provider);
        this.getAuthMgmtResource().addExecution(flowAlias, data);
        this.updateRequirement(flowAlias, provider, AuthenticationExecutionModel.Requirement.REQUIRED);
        RealmRepresentation realm = this.testRealmResource().toRepresentation();
        realm.setBrowserFlow(flowAlias);
        this.testRealmResource().update(realm);
        String executionId = this.getExecution(flowAlias, provider).getId();
        AuthenticatorConfigRepresentation authConfig = new AuthenticatorConfigRepresentation();
        authConfig.setAlias("Config alias");
        authConfig.setConfig(config);
        response = this.getAuthMgmtResource().newExecutionConfig(executionId, authConfig);
        Assert.assertEquals((String)"new execution success", (long)201L, (long)response.getStatus());
        response.close();
    }
}

