/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.actions;

import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.events.EventType;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.TestRealmKeycloakTest;
import org.keycloak.testsuite.actions.ActionUtil;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.InfoPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.RegisterPage;
import org.keycloak.testsuite.pages.VerifyEmailPage;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.MailUtils;

public class RequiredActionEmailVerificationTest
extends TestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Rule
    public GreenMailRule greenMail = new GreenMailRule();
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected VerifyEmailPage verifyEmailPage;
    @Page
    protected RegisterPage registerPage;
    @Page
    protected InfoPage infoPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        testRealm.setVerifyEmail(Boolean.TRUE);
        ActionUtil.findUserInRealmRep(testRealm, "test-user@localhost").setEmailVerified(Boolean.FALSE);
    }

    @Before
    public void before() {
        this.oauth.state("mystate");
    }

    @Test
    public void verifyEmailExisting() throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.verifyEmailPage.isCurrent());
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
        AssertEvents.ExpectedEvent emailEvent = this.events.expectRequiredAction(EventType.SEND_VERIFY_EMAIL).detail("email", "test-user@localhost");
        EventRepresentation sendEvent = emailEvent.assertEvent();
        String sessionId = sendEvent.getSessionId();
        String mailCodeId = (String)sendEvent.getDetails().get("code_id");
        Assert.assertEquals((Object)mailCodeId, (Object)verificationUrl.split("code=")[1].split("\\&")[0].split("\\.")[1]);
        this.driver.navigate().to(verificationUrl.trim());
        this.events.expectRequiredAction(EventType.VERIFY_EMAIL).session(sessionId).detail("email", "test-user@localhost").detail("code_id", mailCodeId).assertEvent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().session(sessionId).detail("code_id", mailCodeId).assertEvent();
    }

    @Test
    public void verifyEmailRegister() throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.register("firstName", "lastName", "email@mail.com", "verifyEmail", "password", "password");
        String userId = this.events.expectRegister("verifyEmail", "email@mail.com").assertEvent().getUserId();
        Assert.assertTrue((boolean)this.verifyEmailPage.isCurrent());
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        EventRepresentation sendEvent = this.events.expectRequiredAction(EventType.SEND_VERIFY_EMAIL).user(userId).detail("username", "verifyemail").detail("email", "email@mail.com").assertEvent();
        String sessionId = sendEvent.getSessionId();
        String mailCodeId = (String)sendEvent.getDetails().get("code_id");
        String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
        this.driver.navigate().to(verificationUrl.trim());
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectRequiredAction(EventType.VERIFY_EMAIL).user(userId).session(sessionId).detail("username", "verifyemail").detail("email", "email@mail.com").detail("code_id", mailCodeId).assertEvent();
        this.events.expectLogin().user(userId).session(sessionId).detail("username", "verifyemail").detail("code_id", mailCodeId).assertEvent();
    }

    @Test
    public void verifyEmailResend() throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.verifyEmailPage.isCurrent());
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        EventRepresentation sendEvent = this.events.expectRequiredAction(EventType.SEND_VERIFY_EMAIL).detail("email", "test-user@localhost").assertEvent();
        String sessionId = sendEvent.getSessionId();
        String mailCodeId = (String)sendEvent.getDetails().get("code_id");
        this.verifyEmailPage.clickResendEmail();
        Assert.assertEquals((long)2L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[1];
        this.events.expectRequiredAction(EventType.SEND_VERIFY_EMAIL).session(sessionId).detail("email", "test-user@localhost").assertEvent(sendEvent);
        String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
        this.driver.navigate().to(verificationUrl.trim());
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectRequiredAction(EventType.VERIFY_EMAIL).session(sessionId).detail("email", "test-user@localhost").detail("code_id", mailCodeId).assertEvent();
        this.events.expectLogin().session(sessionId).assertEvent();
    }

    @Test
    public void verifyEmailNewBrowserSession() throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.verifyEmailPage.isCurrent());
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
        AssertEvents.ExpectedEvent emailEvent = this.events.expectRequiredAction(EventType.SEND_VERIFY_EMAIL).detail("email", "test-user@localhost");
        EventRepresentation sendEvent = emailEvent.assertEvent();
        String sessionId = sendEvent.getSessionId();
        String mailCodeId = (String)sendEvent.getDetails().get("code_id");
        Assert.assertEquals((Object)mailCodeId, (Object)verificationUrl.split("code=")[1].split("\\&")[0].split("\\.")[1]);
        this.driver.manage().deleteAllCookies();
        this.driver.navigate().to(verificationUrl.trim());
        this.events.expectRequiredAction(EventType.VERIFY_EMAIL).session(sessionId).detail("email", "test-user@localhost").detail("code_id", mailCodeId).assertEvent();
        Assert.assertTrue((boolean)this.infoPage.isCurrent());
        Assert.assertEquals((Object)"Your email address has been verified.", (Object)this.infoPage.getInfo());
        this.loginPage.open();
        Assert.assertTrue((boolean)this.loginPage.isCurrent());
    }

    @Test
    public void verifyInvalidKeyOrCode() throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.verifyEmailPage.isCurrent());
        String resendEmailLink = this.verifyEmailPage.getResendEmailLink();
        String keyInsteadCodeURL = resendEmailLink.replace("code=", "key=");
        AssertEvents.ExpectedEvent emailEvent = this.events.expectRequiredAction(EventType.SEND_VERIFY_EMAIL).detail("email", "test-user@localhost");
        EventRepresentation sendEvent = emailEvent.assertEvent();
        String sessionId = sendEvent.getSessionId();
        String mailCodeId = (String)sendEvent.getDetails().get("code_id");
        this.driver.navigate().to(keyInsteadCodeURL);
        this.events.expectRequiredAction(EventType.VERIFY_EMAIL_ERROR).error("invalid_code").client((String)null).user((String)null).session((String)null).clearDetails().assertEvent();
        String badKeyURL = KeycloakUriBuilder.fromUri((String)resendEmailLink).queryParam("key", new Object[]{"foo"}).build(new Object[0]).toString();
        this.driver.navigate().to(badKeyURL);
        this.events.expectRequiredAction(EventType.VERIFY_EMAIL_ERROR).error("invalid_user_credentials").session(sessionId).detail("email", "test-user@localhost").detail("code_id", mailCodeId).assertEvent();
    }

    public static String getPasswordResetEmailLink(MimeMessage message) throws IOException, MessagingException {
        Multipart multipart = (Multipart)message.getContent();
        String textContentType = multipart.getBodyPart(0).getContentType();
        Assert.assertEquals((Object)"text/plain; charset=UTF-8", (Object)textContentType);
        String textBody = (String)multipart.getBodyPart(0).getContent();
        String textChangePwdUrl = MailUtils.getLink((String)textBody);
        String htmlContentType = multipart.getBodyPart(1).getContentType();
        Assert.assertEquals((Object)"text/html; charset=UTF-8", (Object)htmlContentType);
        String htmlBody = (String)multipart.getBodyPart(1).getContent();
        String htmlChangePwdUrl = MailUtils.getLink((String)htmlBody);
        Assert.assertEquals((Object)htmlChangePwdUrl, (Object)textChangePwdUrl);
        return htmlChangePwdUrl;
    }
}

