/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.actions;

import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.events.EventType;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.TestRealmKeycloakTest;
import org.keycloak.testsuite.actions.ActionUtil;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.pages.LoginUpdateProfileEditUsernameAllowedPage;

public class RequiredActionMultipleActionsTest
extends TestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected LoginPasswordUpdatePage changePasswordPage;
    @Page
    protected LoginUpdateProfileEditUsernameAllowedPage updateProfilePage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        ActionUtil.addRequiredActionForUser(testRealm, "test-user@localhost", UserModel.RequiredAction.UPDATE_PROFILE.name());
        ActionUtil.addRequiredActionForUser(testRealm, "test-user@localhost", UserModel.RequiredAction.UPDATE_PASSWORD.name());
    }

    @Test
    public void updateProfileAndPassword() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        String sessionId = null;
        if (this.changePasswordPage.isCurrent()) {
            sessionId = this.updatePassword(sessionId);
            this.updateProfilePage.assertCurrent();
            this.updateProfile(sessionId);
        } else if (this.updateProfilePage.isCurrent()) {
            sessionId = this.updateProfile(sessionId);
            this.changePasswordPage.assertCurrent();
            this.updatePassword(sessionId);
        } else {
            Assert.fail((String)"Expected to update password and profile before login");
        }
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().session(sessionId).assertEvent();
    }

    public String updatePassword(String sessionId) {
        this.changePasswordPage.changePassword("new-password", "new-password");
        AssertEvents.ExpectedEvent expectedEvent = this.events.expectRequiredAction(EventType.UPDATE_PASSWORD);
        if (sessionId != null) {
            expectedEvent.session(sessionId);
        }
        return expectedEvent.assertEvent().getSessionId();
    }

    public String updateProfile(String sessionId) {
        this.updateProfilePage.update("New first", "New last", "new@email.com", "test-user@localhost");
        AssertEvents.ExpectedEvent expectedEvent = this.events.expectRequiredAction(EventType.UPDATE_EMAIL).detail("previous_email", "test-user@localhost").detail("updated_email", "new@email.com");
        if (sessionId != null) {
            expectedEvent.session(sessionId);
        }
        sessionId = expectedEvent.assertEvent().getSessionId();
        this.events.expectRequiredAction(EventType.UPDATE_PROFILE).session(sessionId).assertEvent();
        return sessionId;
    }
}

