/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.actions;

import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.events.EventType;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.TestRealmKeycloakTest;
import org.keycloak.testsuite.actions.ActionUtil;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.util.GreenMailRule;

public class RequiredActionResetPasswordTest
extends TestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Rule
    public GreenMailRule greenMail = new GreenMailRule();
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected LoginPasswordUpdatePage changePasswordPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        testRealm.setResetPasswordAllowed(Boolean.TRUE);
        ActionUtil.addRequiredActionForUser(testRealm, "test-user@localhost", UserModel.RequiredAction.UPDATE_PASSWORD.name());
    }

    @Before
    public void before() {
        this.oauth.state("mystate");
    }

    @Test
    public void tempPassword() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.changePasswordPage.assertCurrent();
        this.changePasswordPage.changePassword("new-password", "new-password");
        String sessionId = this.events.expectRequiredAction(EventType.UPDATE_PASSWORD).assertEvent().getSessionId();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        EventRepresentation loginEvent = this.events.expectLogin().session(sessionId).assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(loginEvent.getSessionId()).assertEvent();
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "new-password");
        this.events.expectLogin().assertEvent();
    }
}

