/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.actions;

import java.util.LinkedList;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.HmacOTP;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.TestRealmKeycloakTest;
import org.keycloak.testsuite.pages.AccountTotpPage;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginConfigTotpPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginTotpPage;
import org.keycloak.testsuite.pages.RegisterPage;
import org.keycloak.testsuite.util.RealmBuilder;

public class RequiredActionTotpSetupTest
extends TestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected LoginTotpPage loginTotpPage;
    @Page
    protected LoginConfigTotpPage totpPage;
    @Page
    protected AccountTotpPage accountTotpPage;
    @Page
    protected RegisterPage registerPage;
    protected TimeBasedOTP totp = new TimeBasedOTP();

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        RequiredActionProviderRepresentation requiredAction = new RequiredActionProviderRepresentation();
        requiredAction.setAlias(UserModel.RequiredAction.CONFIGURE_TOTP.name());
        requiredAction.setProviderId(UserModel.RequiredAction.CONFIGURE_TOTP.name());
        requiredAction.setName("Configure Totp");
        requiredAction.setEnabled(true);
        requiredAction.setDefaultAction(true);
        LinkedList<RequiredActionProviderRepresentation> requiredActions = new LinkedList<RequiredActionProviderRepresentation>();
        requiredActions.add(requiredAction);
        testRealm.setRequiredActions(requiredActions);
        testRealm.setResetPasswordAllowed(Boolean.TRUE);
    }

    @Before
    public void setOTPAuthRequired() {
        for (AuthenticationExecutionInfoRepresentation execution : this.adminClient.realm("test").flows().getExecutions("browser")) {
            String providerId = execution.getProviderId();
            if (!"auth-otp-form".equals(providerId)) continue;
            execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED.name());
            this.adminClient.realm("test").flows().updateExecutions("browser", execution);
        }
    }

    @Test
    public void setupTotpRegister() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.register("firstName", "lastName", "email@mail.com", "setupTotp", "password", "password");
        String userId = this.events.expectRegister("setupTotp", "email@mail.com").assertEvent().getUserId();
        Assert.assertTrue((boolean)this.totpPage.isCurrent());
        this.totpPage.configure(this.totp.generateTOTP(this.totpPage.getTotpSecret()));
        String sessionId = this.events.expectRequiredAction(EventType.UPDATE_TOTP).user(userId).detail("username", "setuptotp").assertEvent().getSessionId();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().user(userId).session(sessionId).detail("username", "setuptotp").assertEvent();
    }

    @Test
    public void setupTotpExisting() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.totpPage.assertCurrent();
        String totpSecret = this.totpPage.getTotpSecret();
        this.totpPage.configure(this.totp.generateTOTP(totpSecret));
        String sessionId = this.events.expectRequiredAction(EventType.UPDATE_TOTP).assertEvent().getSessionId();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        EventRepresentation loginEvent = this.events.expectLogin().session(sessionId).assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(loginEvent.getSessionId()).assertEvent();
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        String src = this.driver.getPageSource();
        this.loginTotpPage.login(this.totp.generateTOTP(totpSecret));
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().assertEvent();
    }

    @Test
    public void setupTotpRegisteredAfterTotpRemoval() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.register("firstName2", "lastName2", "email2@mail.com", "setupTotp2", "password2", "password2");
        String userId = this.events.expectRegister("setupTotp2", "email2@mail.com").assertEvent().getUserId();
        this.totpPage.assertCurrent();
        String totpCode = this.totpPage.getTotpSecret();
        this.totpPage.configure(this.totp.generateTOTP(totpCode));
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectRequiredAction(EventType.UPDATE_TOTP).user(userId).detail("username", "setuptotp2").assertEvent();
        EventRepresentation loginEvent = this.events.expectLogin().user(userId).detail("username", "setuptotp2").assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(loginEvent.getSessionId()).user(userId).assertEvent();
        this.loginPage.open();
        this.loginPage.login("setupTotp2", "password2");
        String uri = this.driver.getCurrentUrl();
        String src = this.driver.getPageSource();
        Assert.assertTrue((boolean)this.loginPage.isCurrent());
        Assert.assertFalse((boolean)this.totpPage.isCurrent());
        this.loginTotpPage.login(this.totp.generateTOTP(totpCode));
        loginEvent = this.events.expectLogin().user(userId).detail("username", "setupTotp2").assertEvent();
        this.accountTotpPage.open();
        this.accountTotpPage.assertCurrent();
        this.accountTotpPage.removeTotp();
        this.events.expectAccount(EventType.REMOVE_TOTP).user(userId).assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(loginEvent.getSessionId()).user(userId).assertEvent();
        this.loginPage.open();
        this.loginPage.login("setupTotp2", "password2");
        this.totpPage.assertCurrent();
        this.totpPage.configure(this.totp.generateTOTP(this.totpPage.getTotpSecret()));
        String sessionId = this.events.expectRequiredAction(EventType.UPDATE_TOTP).user(userId).detail("username", "setupTotp2").assertEvent().getSessionId();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().user(userId).session(sessionId).detail("username", "setupTotp2").assertEvent();
    }

    @Test
    public void setupOtpPolicyChangedTotp8Digits() {
        RealmRepresentation realmRep = this.adminClient.realm("test").toRepresentation();
        RealmBuilder.edit(realmRep).otpLookAheadWindow(1).otpDigits(8).otpPeriod(30).otpType("totp").otpAlgorithm("HmacSHA1").otpInitialCounter(0);
        this.adminClient.realm("test").update(realmRep);
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.totpPage.assertCurrent();
        String totpSecret = this.totpPage.getTotpSecret();
        TimeBasedOTP timeBased = new TimeBasedOTP("HmacSHA1", 8, 30, 1);
        this.totpPage.configure(timeBased.generateTOTP(totpSecret));
        String sessionId = this.events.expectRequiredAction(EventType.UPDATE_TOTP).assertEvent().getSessionId();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        EventRepresentation loginEvent = this.events.expectLogin().session(sessionId).assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(loginEvent.getSessionId()).assertEvent();
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        String src = this.driver.getPageSource();
        String token = timeBased.generateTOTP(totpSecret);
        Assert.assertEquals((long)8L, (long)token.length());
        this.loginTotpPage.login(token);
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().assertEvent();
    }

    @Test
    public void setupOtpPolicyChangedHotp() {
        RealmRepresentation realmRep = this.adminClient.realm("test").toRepresentation();
        RealmBuilder.edit(realmRep).otpLookAheadWindow(0).otpDigits(6).otpPeriod(30).otpType("hotp").otpAlgorithm("HmacSHA1").otpInitialCounter(0);
        this.adminClient.realm("test").update(realmRep);
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.totpPage.assertCurrent();
        String totpSecret = this.totpPage.getTotpSecret();
        HmacOTP otpgen = new HmacOTP(6, "HmacSHA1", 1);
        this.totpPage.configure(otpgen.generateHOTP(totpSecret, 0));
        String uri = this.driver.getCurrentUrl();
        String sessionId = this.events.expectRequiredAction(EventType.UPDATE_TOTP).assertEvent().getSessionId();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        EventRepresentation loginEvent = this.events.expectLogin().session(sessionId).assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(loginEvent.getSessionId()).assertEvent();
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        String token = otpgen.generateHOTP(totpSecret, 1);
        this.loginTotpPage.login(token);
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(null).session(AssertEvents.isUUID()).assertEvent();
        realmRep = this.adminClient.realm("test").toRepresentation();
        RealmBuilder.edit(realmRep).otpLookAheadWindow(5).otpDigits(6).otpPeriod(30).otpType("hotp").otpAlgorithm("HmacSHA1").otpInitialCounter(0);
        this.adminClient.realm("test").update(realmRep);
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        token = otpgen.generateHOTP(totpSecret, 4);
        this.loginTotpPage.assertCurrent();
        this.loginTotpPage.login(token);
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().assertEvent();
    }
}

