/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.actions;

import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.events.EventType;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.TestRealmKeycloakTest;
import org.keycloak.testsuite.actions.ActionUtil;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginUpdateProfileEditUsernameAllowedPage;

public class RequiredActionUpdateProfileTest
extends TestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected LoginUpdateProfileEditUsernameAllowedPage updateProfilePage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        ActionUtil.addRequiredActionForUser(testRealm, "test-user@localhost", UserModel.RequiredAction.UPDATE_PROFILE.name());
        ActionUtil.addRequiredActionForUser(testRealm, "john-doh@localhost", UserModel.RequiredAction.UPDATE_PROFILE.name());
    }

    @Test
    public void updateProfile() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "New last", "new@email.com", "test-user@localhost");
        String sessionId = this.events.expectRequiredAction(EventType.UPDATE_EMAIL).detail("previous_email", "test-user@localhost").detail("updated_email", "new@email.com").assertEvent().getSessionId();
        this.events.expectRequiredAction(EventType.UPDATE_PROFILE).session(sessionId).assertEvent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().session(sessionId).assertEvent();
        UserRepresentation user = ActionUtil.findUserWithAdminClient(this.adminClient, "test-user@localhost");
        Assert.assertEquals((Object)"New first", (Object)user.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)user.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)user.getEmail());
        Assert.assertEquals((Object)"test-user@localhost", (Object)user.getUsername());
    }

    @Test
    public void updateUsername() {
        this.loginPage.open();
        this.loginPage.login("john-doh@localhost", "password");
        String userId = ActionUtil.findUserWithAdminClient(this.adminClient, "john-doh@localhost").getId();
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "New last", "john-doh@localhost", "new");
        String sessionId = this.events.expectLogin().event(EventType.UPDATE_PROFILE).detail("username", "john-doh@localhost").user(userId).session(AssertEvents.isUUID()).removeDetail("consent").assertEvent().getSessionId();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().detail("username", "john-doh@localhost").user(userId).session(sessionId).assertEvent();
        UserRepresentation user = ActionUtil.findUserWithAdminClient(this.adminClient, "new");
        Assert.assertEquals((Object)"New first", (Object)user.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)user.getLastName());
        Assert.assertEquals((Object)"john-doh@localhost", (Object)user.getEmail());
        Assert.assertEquals((Object)"new", (Object)user.getUsername());
    }

    @Test
    public void updateProfileMissingFirstName() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("", "New last", "new@email.com", "new");
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"", (Object)this.updateProfilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.updateProfilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.updateProfilePage.getEmail());
        Assert.assertEquals((Object)"Please specify first name.", (Object)this.updateProfilePage.getError());
        this.events.assertEmpty();
    }

    @Test
    public void updateProfileMissingLastName() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "", "new@email.com", "new");
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"New first", (Object)this.updateProfilePage.getFirstName());
        Assert.assertEquals((Object)"", (Object)this.updateProfilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.updateProfilePage.getEmail());
        Assert.assertEquals((Object)"Please specify last name.", (Object)this.updateProfilePage.getError());
        this.events.assertEmpty();
    }

    @Test
    public void updateProfileMissingEmail() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "New last", "", "new");
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"New first", (Object)this.updateProfilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.updateProfilePage.getLastName());
        Assert.assertEquals((Object)"", (Object)this.updateProfilePage.getEmail());
        Assert.assertEquals((Object)"Please specify email.", (Object)this.updateProfilePage.getError());
        this.events.assertEmpty();
    }

    @Test
    public void updateProfileInvalidEmail() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "New last", "invalidemail", "invalid");
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"New first", (Object)this.updateProfilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.updateProfilePage.getLastName());
        Assert.assertEquals((Object)"invalidemail", (Object)this.updateProfilePage.getEmail());
        Assert.assertEquals((Object)"Invalid email address.", (Object)this.updateProfilePage.getError());
        this.events.assertEmpty();
    }

    @Test
    public void updateProfileMissingUsername() {
        this.loginPage.open();
        this.loginPage.login("john-doh@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "New last", "new@email.com", "");
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"New first", (Object)this.updateProfilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.updateProfilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.updateProfilePage.getEmail());
        Assert.assertEquals((Object)"", (Object)this.updateProfilePage.getUsername());
        Assert.assertEquals((Object)"Please specify username.", (Object)this.updateProfilePage.getError());
        this.events.assertEmpty();
    }

    @Test
    public void updateProfileDuplicateUsername() {
        this.loginPage.open();
        this.loginPage.login("john-doh@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "New last", "new@email.com", "test-user@localhost");
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"New first", (Object)this.updateProfilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.updateProfilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.updateProfilePage.getEmail());
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.updateProfilePage.getUsername());
        Assert.assertEquals((Object)"Username already exists.", (Object)this.updateProfilePage.getError());
        this.events.assertEmpty();
    }

    @Test
    public void updateProfileDuplicatedEmail() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "New last", "keycloak-user@localhost", "test-user@localhost");
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"New first", (Object)this.updateProfilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.updateProfilePage.getLastName());
        Assert.assertEquals((Object)"keycloak-user@localhost", (Object)this.updateProfilePage.getEmail());
        Assert.assertEquals((Object)"Email already exists.", (Object)this.updateProfilePage.getError());
        this.events.assertEmpty();
    }
}

