/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractAuthTest;
import org.keycloak.testsuite.adapter.AbstractServletsAdapterTest;
import org.keycloak.testsuite.adapter.page.AppServerContextRoot;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;

@AppServerContainer
public abstract class AbstractAdapterTest
extends AbstractAuthTest {
    @Page
    protected AppServerContextRoot appServerContextRootPage;
    public static final String JBOSS_DEPLOYMENT_STRUCTURE_XML = "jboss-deployment-structure.xml";
    public static final URL jbossDeploymentStructure = AbstractServletsAdapterTest.class.getResource("/adapter-test/jboss-deployment-structure.xml");
    public static final String TOMCAT_CONTEXT_XML = "context.xml";
    public static final URL tomcatContext = AbstractServletsAdapterTest.class.getResource("/adapter-test/context.xml");

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        this.addAdapterTestRealms(testRealms);
        for (RealmRepresentation tr : testRealms) {
            this.log.info((Object)("Setting redirect-uris in test realm '" + tr.getRealm() + "' as " + (this.isRelative() ? "" : "non-") + "relative"));
            this.modifyClientRedirectUris(tr, "http://localhost:8080", "");
            this.modifyClientUrls(tr, "http://localhost:8080", "");
            if (this.isRelative()) {
                this.modifyClientRedirectUris(tr, this.appServerContextRootPage.toString(), "");
                this.modifyClientUrls(tr, this.appServerContextRootPage.toString(), "");
                this.modifyClientWebOrigins(tr, "8080", System.getProperty("auth.server.http.port", null));
                this.modifySamlMasterURLs(tr, "/", "http://localhost:" + System.getProperty("auth.server.http.port", null) + "/");
            } else {
                this.modifyClientRedirectUris(tr, "^(/.*/\\*)", this.appServerContextRootPage.toString() + "$1");
                this.modifyClientUrls(tr, "^(/.*)", this.appServerContextRootPage.toString() + "$1");
                this.modifySamlMasterURLs(tr, "8080", System.getProperty("auth.server.http.port", null));
            }
            if (!"true".equals(System.getProperty("auth.server.ssl.required"))) continue;
            tr.setSslRequired("all");
        }
    }

    public abstract void addAdapterTestRealms(List<RealmRepresentation> var1);

    public boolean isRelative() {
        return this.testContext.isRelativeAdapterTest();
    }

    protected void modifyClientRedirectUris(RealmRepresentation realm, String regex, String replacement) {
        if (realm.getClients() != null) {
            for (ClientRepresentation client : realm.getClients()) {
                List redirectUris = client.getRedirectUris();
                if (redirectUris == null) continue;
                ArrayList<String> newRedirectUris = new ArrayList<String>();
                for (String uri : redirectUris) {
                    newRedirectUris.add(uri.replaceAll(regex, replacement));
                }
                client.setRedirectUris(newRedirectUris);
            }
        }
    }

    protected void modifyClientUrls(RealmRepresentation realm, String regex, String replacement) {
        if (realm.getClients() != null) {
            for (ClientRepresentation client : realm.getClients()) {
                String adminUrl;
                String baseUrl = client.getBaseUrl();
                if (baseUrl != null) {
                    client.setBaseUrl(baseUrl.replaceAll(regex, replacement));
                }
                if ((adminUrl = client.getAdminUrl()) == null) continue;
                client.setAdminUrl(adminUrl.replaceAll(regex, replacement));
            }
        }
    }

    protected void modifyClientWebOrigins(RealmRepresentation realm, String regex, String replacement) {
        if (realm.getClients() != null) {
            for (ClientRepresentation client : realm.getClients()) {
                List webOrigins = client.getWebOrigins();
                if (webOrigins == null) continue;
                ArrayList<String> newWebOrigins = new ArrayList<String>();
                for (String uri : webOrigins) {
                    newWebOrigins.add(uri.replaceAll(regex, replacement));
                }
                client.setWebOrigins(newWebOrigins);
            }
        }
    }

    protected void modifySamlMasterURLs(RealmRepresentation realm, String regex, String replacement) {
        if (realm.getClients() != null) {
            for (ClientRepresentation client : realm.getClients()) {
                if (client.getProtocol() == null || !client.getProtocol().equals("saml")) continue;
                this.log.info((Object)("Modifying master URL of SAML client: " + client.getClientId()));
                String masterUrl = client.getAdminUrl();
                if (masterUrl == null) {
                    masterUrl = client.getBaseUrl();
                }
                masterUrl = masterUrl.replaceFirst(regex, replacement);
                client.setAdminUrl(masterUrl + (!masterUrl.endsWith("/saml") ? "/saml" : ""));
            }
        }
    }

    protected void fixClientUrisUsingDeploymentUrl(RealmRepresentation realm, String clientId, String deploymentUrl) {
        for (ClientRepresentation client : realm.getClients()) {
            List redirectUris;
            if (!clientId.equals(client.getClientId())) continue;
            if (client.getBaseUrl() != null) {
                client.setBaseUrl(deploymentUrl);
            }
            if (client.getAdminUrl() != null) {
                client.setAdminUrl(deploymentUrl);
            }
            if ((redirectUris = client.getRedirectUris()) == null) continue;
            ArrayList<String> newRedirectUris = new ArrayList<String>();
            for (String uri : redirectUris) {
                newRedirectUris.add(deploymentUrl + "/*");
            }
            client.setRedirectUris(newRedirectUris);
        }
    }

    public static void addContextXml(Archive archive, String contextPath) {
        try {
            String contextXmlContent = IOUtils.toString((InputStream)tomcatContext.openStream()).replace("%CONTEXT_PATH%", contextPath);
            archive.add((Asset)new StringAsset(contextXmlContent), "/META-INF/context.xml");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

