/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import org.apache.commons.io.IOUtils;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.keycloak.testsuite.adapter.AbstractAdapterTest;

public abstract class AbstractExampleAdapterTest
extends AbstractAdapterTest {
    public static final String EXAMPLES_HOME = System.getProperty("examples.home", null);
    public static final String EXAMPLES_VERSION_SUFFIX;
    public static final String EXAMPLES_HOME_DIR;
    public static final String TEST_APPS_HOME_DIR;
    public static final String EXAMPLES_WEB_XML;

    protected static WebArchive exampleDeployment(String name) throws IOException {
        return (WebArchive)((WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)new File(EXAMPLES_HOME + "/" + name + "-" + EXAMPLES_VERSION_SUFFIX + ".war"))).addAsWebInfResource(jbossDeploymentStructure, "jboss-deployment-structure.xml");
    }

    protected static WebArchive exampleDeployment(String name, String contextPath) throws IOException {
        URL webXML = Paths.get(EXAMPLES_WEB_XML, new String[0]).toUri().toURL();
        String webXmlContent = IOUtils.toString((InputStream)webXML.openStream()).replace("%CONTEXT_PATH%", contextPath);
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)new File(EXAMPLES_HOME + "/" + name + "-" + EXAMPLES_VERSION_SUFFIX + ".war"))).addAsWebInfResource(jbossDeploymentStructure, "jboss-deployment-structure.xml")).add((Asset)new StringAsset(webXmlContent), "/WEB-INF/web.xml");
        return webArchive;
    }

    protected static JavaArchive exampleJarDeployment(String name) {
        return (JavaArchive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)new File(EXAMPLES_HOME + "/" + name + "-" + EXAMPLES_VERSION_SUFFIX + ".jar"));
    }

    static {
        Assert.assertNotNull((String)"Property ${examples.home} must bet set.", (Object)EXAMPLES_HOME);
        System.out.println(EXAMPLES_HOME);
        EXAMPLES_VERSION_SUFFIX = System.getProperty("examples.version.suffix", null);
        Assert.assertNotNull((String)"Property ${examples.version.suffix} must bet set.", (Object)EXAMPLES_VERSION_SUFFIX);
        System.out.println(EXAMPLES_VERSION_SUFFIX);
        if (!System.getProperty("unpacked.container.folder.name", "").isEmpty()) {
            EXAMPLES_HOME_DIR = EXAMPLES_HOME + "/" + System.getProperty("unpacked.container.folder.name", "") + "-examples";
            TEST_APPS_HOME_DIR = EXAMPLES_HOME + "/" + System.getProperty("unpacked.container.folder.name", "") + "-test-apps";
        } else {
            EXAMPLES_HOME_DIR = EXAMPLES_HOME + "/keycloak-examples-" + EXAMPLES_VERSION_SUFFIX;
            TEST_APPS_HOME_DIR = EXAMPLES_HOME + "/Keycloak-" + EXAMPLES_VERSION_SUFFIX + "-test-apps";
        }
        EXAMPLES_WEB_XML = EXAMPLES_HOME + "/web.xml";
    }
}

