/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.adapter.AbstractAdapterTest;
import org.keycloak.testsuite.util.IOUtil;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;

public abstract class AbstractServletsAdapterTest
extends AbstractAdapterTest {
    protected static WebArchive servletDeployment(String name, Class ... servletClasses) {
        return AbstractServletsAdapterTest.servletDeployment(name, "keycloak.json", servletClasses);
    }

    protected static WebArchive servletDeployment(String name, String adapterConfig, Class ... servletClasses) {
        String webInfPath = "/adapter-test/" + name + "/WEB-INF/";
        URL keycloakJSON = AbstractServletsAdapterTest.class.getResource(webInfPath + adapterConfig);
        URL webXML = AbstractServletsAdapterTest.class.getResource(webInfPath + "web.xml");
        WebArchive deployment = (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(name + ".war"))).addClasses(servletClasses)).addAsWebInfResource(webXML, "web.xml")).addAsWebInfResource(jbossDeploymentStructure, "jboss-deployment-structure.xml");
        URL keystore = AbstractServletsAdapterTest.class.getResource(webInfPath + "keystore.jks");
        if (keystore != null) {
            deployment.addAsWebInfResource(keystore, "classes/keystore.jks");
        }
        if (keycloakJSON != null) {
            deployment.addAsWebInfResource(keycloakJSON, "keycloak.json");
        }
        AbstractServletsAdapterTest.addContextXml((Archive)deployment, name);
        return deployment;
    }

    protected static WebArchive samlServletDeployment(String name, Class ... servletClasses) {
        return AbstractServletsAdapterTest.samlServletDeployment(name, "keycloak-saml.xml", servletClasses);
    }

    protected static WebArchive samlServletDeployment(String name, String adapterConfig, Class ... servletClasses) {
        String webXMLContent;
        String baseSAMLPath = "/adapter-test/keycloak-saml/";
        String webInfPath = baseSAMLPath + name + "/WEB-INF/";
        URL keycloakSAMLConfig = AbstractServletsAdapterTest.class.getResource(webInfPath + adapterConfig);
        URL webXML = AbstractServletsAdapterTest.class.getResource(baseSAMLPath + "web.xml");
        WebArchive deployment = (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(name + ".war"))).addClasses(servletClasses)).addAsWebInfResource(keycloakSAMLConfig, "keycloak-saml.xml")).addAsWebInfResource(jbossDeploymentStructure, "jboss-deployment-structure.xml");
        try {
            webXMLContent = IOUtils.toString((InputStream)webXML.openStream()).replace("%CONTEXT_PATH%", name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        deployment.add((Asset)new StringAsset(webXMLContent), "/WEB-INF/web.xml");
        URL keystore = AbstractServletsAdapterTest.class.getResource(webInfPath + "keystore.jks");
        if (keystore != null) {
            deployment.addAsWebInfResource(keystore, "keystore.jks");
        }
        AbstractServletsAdapterTest.addContextXml((Archive)deployment, name);
        return deployment;
    }

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((String)"/adapter-test/demorealm.json"));
    }

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testRealmPage.setAuthRealm("demo");
    }

    protected void setAdapterAndServerTimeOffset(int timeOffset, String servletUri) {
        this.setTimeOffset(timeOffset);
        String timeOffsetUri = UriBuilder.fromUri((String)servletUri).queryParam("timeOffset", new Object[]{timeOffset}).build(new Object[0]).toString();
        this.driver.navigate().to(timeOffsetUri);
        WaitUtils.waitUntilElement((By)By.tagName((String)"body")).is().visible();
    }
}

