/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.example;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.adapter.AbstractExampleAdapterTest;
import org.keycloak.testsuite.adapter.page.BasicAuthExample;
import org.keycloak.testsuite.util.IOUtil;

public abstract class AbstractBasicAuthExampleAdapterTest
extends AbstractExampleAdapterTest {
    @Page
    private BasicAuthExample basicAuthExample;

    @Deployment(name="basic-auth-example")
    private static WebArchive basicAuthExample() throws IOException {
        return AbstractBasicAuthExampleAdapterTest.exampleDeployment("examples-basicauth");
    }

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((File)new File(EXAMPLES_HOME_DIR + "/basic-auth/basicauthrealm.json")));
    }

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testRealmPage.setAuthRealm("example");
    }

    @Test
    public void testBasicAuthExample() {
        String value = "hello";
        Client client = ClientBuilder.newClient();
        Response response = client.target(this.basicAuthExample.setTemplateValues("admin", "password", value).buildUri()).request().get();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)value, (Object)response.readEntity(String.class));
        response.close();
        response = client.target(this.basicAuthExample.setTemplateValues("invalid-user", "password", value).buildUri()).request().get();
        Assert.assertEquals((long)401L, (long)response.getStatus());
        String readResponse = (String)response.readEntity(String.class);
        Assert.assertTrue((readResponse.contains("Unauthorized") || readResponse.contains("Status 401") ? 1 : 0) != 0);
        response.close();
        response = client.target(this.basicAuthExample.setTemplateValues("admin", "invalid-password", value).buildUri()).request().get();
        Assert.assertEquals((long)401L, (long)response.getStatus());
        readResponse = (String)response.readEntity(String.class);
        Assert.assertTrue((readResponse.contains("Unauthorized") || readResponse.contains("Status 401") ? 1 : 0) != 0);
        response.close();
        client.close();
    }
}

