/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.example;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.adapter.AbstractExampleAdapterTest;
import org.keycloak.testsuite.adapter.page.AngularCorsProductExample;
import org.keycloak.testsuite.auth.page.account.Account;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.IOUtil;
import org.keycloak.testsuite.util.URLAssert;

@Ignore
public abstract class AbstractCorsExampleAdapterTest
extends AbstractExampleAdapterTest {
    public static final String CORS = "cors";
    @Page
    private AngularCorsProductExample angularCorsProductExample;
    @Page
    private Account testRealmAccount;

    @Deployment(name="cors-angular-product-example")
    private static WebArchive angularCorsProductExample() throws IOException {
        return AbstractCorsExampleAdapterTest.exampleDeployment("cors-angular-product-example", "angular-cors-product");
    }

    @Deployment(name="cors-database-service")
    private static WebArchive corsDatabaseServiceExample() throws IOException {
        return AbstractCorsExampleAdapterTest.exampleDeployment("database-service");
    }

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((File)new File(EXAMPLES_HOME_DIR + "/cors/cors-realm.json")));
    }

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testRealmPage.setAuthRealm(CORS);
        this.testRealmLoginPage.setAuthRealm(CORS);
        this.testRealmAccount.setAuthRealm(CORS);
    }

    @Before
    public void beforeDemoExampleTest() {
        this.angularCorsProductExample.navigateTo();
        this.driver.manage().deleteAllCookies();
    }

    @Test
    public void angularCorsProductTest() {
        this.angularCorsProductExample.navigateTo();
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.angularCorsProductExample);
        this.angularCorsProductExample.reloadData();
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Product Listing"));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("iphone"));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("ipad"));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("ipod"));
        this.angularCorsProductExample.loadRoles();
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Role Listing"));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("user"));
        this.angularCorsProductExample.addRole();
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("stuff"));
        this.angularCorsProductExample.deleteRole();
        Assert.assertFalse((boolean)this.driver.getPageSource().contains("stuff"));
        this.angularCorsProductExample.loadAvailableSocialProviders();
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Available social providers"));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("twitter"));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("google"));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("linkedin"));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("facebook"));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("stackoverflow"));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("github"));
        this.angularCorsProductExample.loadPublicRealmInfo();
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Realm name: cors"));
        this.angularCorsProductExample.loadVersion();
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Keycloak version: "));
    }
}

