/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.example;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.adapter.AbstractExampleAdapterTest;
import org.keycloak.testsuite.adapter.page.CustomerPortalExample;
import org.keycloak.testsuite.adapter.page.DatabaseServiceExample;
import org.keycloak.testsuite.adapter.page.ProductPortalExample;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.auth.page.account.Account;
import org.keycloak.testsuite.auth.page.account.Applications;
import org.keycloak.testsuite.auth.page.login.OAuthGrant;
import org.keycloak.testsuite.console.page.events.Config;
import org.keycloak.testsuite.console.page.events.LoginEvents;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.IOUtil;
import org.keycloak.testsuite.util.URLAssert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public abstract class AbstractDemoExampleAdapterTest
extends AbstractExampleAdapterTest {
    @Page
    private CustomerPortalExample customerPortalExamplePage;
    @Page
    private ProductPortalExample productPortalExamplePage;
    @Page
    private DatabaseServiceExample databaseServiceExamplePage;
    @Page
    private Account testRealmAccountPage;
    @Page
    private Config configPage;
    @Page
    private LoginEvents loginEventsPage;
    @Page
    private OAuthGrant oAuthGrantPage;
    @Page
    private Applications applicationsPage;

    @Deployment(name="customer-portal-example")
    private static WebArchive customerPortalExample() throws IOException {
        return AbstractDemoExampleAdapterTest.exampleDeployment("customer-portal-example");
    }

    @Deployment(name="product-portal-example")
    private static WebArchive productPortalExample() throws IOException {
        return AbstractDemoExampleAdapterTest.exampleDeployment("product-portal-example");
    }

    @Deployment(name="database-service-example")
    private static WebArchive databaseServiceExample() throws IOException {
        return AbstractDemoExampleAdapterTest.exampleDeployment("database-service");
    }

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((File)new File(EXAMPLES_HOME_DIR + "/preconfigured-demo/testrealm.json")));
    }

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testRealmPage.setAuthRealm("demo");
        this.testRealmLoginPage.setAuthRealm("demo");
        this.testRealmAccountPage.setAuthRealm("demo");
        this.configPage.setConsoleRealm("demo");
        this.loginEventsPage.setConsoleRealm("demo");
        this.applicationsPage.setAuthRealm("demo");
    }

    @Before
    public void beforeDemoExampleTest() {
        this.customerPortalExamplePage.navigateTo();
        this.driver.manage().deleteAllCookies();
        this.productPortalExamplePage.navigateTo();
        this.driver.manage().deleteAllCookies();
    }

    @Test
    public void customerPortalListingTest() {
        this.customerPortalExamplePage.navigateTo();
        this.customerPortalExamplePage.customerListing();
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.customerPortalExamplePage);
        this.customerPortalExamplePage.waitForCustomerListingHeader();
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Username: bburke@redhat.com"));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Bill Burke"));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Stian Thorgersen"));
    }

    @Test
    public void customerPortalSessionTest() {
        this.customerPortalExamplePage.navigateTo();
        this.customerPortalExamplePage.customerSession();
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.customerPortalExamplePage);
        this.customerPortalExamplePage.waitForCustomerSessionHeader();
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("You visited this page"));
    }

    @Test
    public void productPortalListingTest() {
        this.productPortalExamplePage.navigateTo();
        this.productPortalExamplePage.productListing();
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.productPortalExamplePage);
        this.productPortalExamplePage.waitForProductListingHeader();
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("iphone"));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("ipad"));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("ipod"));
        this.productPortalExamplePage.goToCustomers();
    }

    @Test
    public void goToProductPortalWithOneLoginTest() {
        this.productPortalExamplePage.navigateTo();
        this.productPortalExamplePage.productListing();
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.productPortalExamplePage);
        this.productPortalExamplePage.waitForProductListingHeader();
        this.productPortalExamplePage.goToCustomers();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.customerPortalExamplePage);
        this.customerPortalExamplePage.customerListing();
        this.customerPortalExamplePage.goToProducts();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.productPortalExamplePage);
    }

    @Test
    public void logoutFromAllAppsTest() {
        this.productPortalExamplePage.navigateTo();
        this.productPortalExamplePage.productListing();
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.productPortalExamplePage);
        this.productPortalExamplePage.waitForProductListingHeader();
        if (this.isRelative()) {
            this.productPortalExamplePage.logOut();
        } else {
            this.driver.navigate().to(this.testRealmPage.getOIDCLogoutUrl() + "?redirect_uri=" + this.productPortalExamplePage);
        }
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.productPortalExamplePage);
        this.productPortalExamplePage.productListing();
        this.customerPortalExamplePage.navigateTo();
        this.customerPortalExamplePage.customerListing();
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        this.customerPortalExamplePage.logOut();
    }

    @Test
    public void grantServerBasedApp() {
        ClientResource clientResource = ApiUtil.findClientResourceByClientId(this.testRealmResource(), "customer-portal");
        ClientRepresentation client = clientResource.toRepresentation();
        client.setConsentRequired(Boolean.valueOf(true));
        clientResource.update(client);
        RealmRepresentation realm = this.testRealmResource().toRepresentation();
        realm.setEventsEnabled(true);
        realm.setEnabledEventTypes(Arrays.asList("REVOKE_GRANT", "LOGIN"));
        this.testRealmResource().update(realm);
        this.customerPortalExamplePage.navigateTo();
        this.customerPortalExamplePage.customerSession();
        this.loginPage.form().login("bburke@redhat.com", "password");
        Assert.assertTrue((boolean)this.oAuthGrantPage.isCurrent());
        this.oAuthGrantPage.accept();
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Your hostname:"));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("You visited this page"));
        this.applicationsPage.navigateTo();
        this.applicationsPage.revokeGrantForApplication("customer-portal");
        this.customerPortalExamplePage.navigateTo();
        this.customerPortalExamplePage.customerSession();
        Assert.assertTrue((boolean)this.oAuthGrantPage.isCurrent());
        this.loginEventsPage.navigateTo();
        if (!this.testContext.isAdminLoggedIn()) {
            this.loginPage.form().login(this.adminUser);
            this.testContext.setAdminLoggedIn(true);
        }
        this.loginEventsPage.table().filter();
        this.loginEventsPage.table().filterForm().addEventType("REVOKE_GRANT");
        this.loginEventsPage.table().update();
        List resultList = this.loginEventsPage.table().rows();
        Assert.assertEquals((long)1L, (long)resultList.size());
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='REVOKE_GRANT']"));
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='Client']/../td[text()='account']"));
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='IP Address']/../td[text()='127.0.0.1' or text()='0:0:0:0:0:0:0:1']"));
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='revoked_client']/../td[text()='customer-portal']"));
        this.loginEventsPage.table().reset();
        this.loginEventsPage.table().filterForm().addEventType("LOGIN");
        this.loginEventsPage.table().update();
        resultList = this.loginEventsPage.table().rows();
        Assert.assertEquals((long)1L, (long)resultList.size());
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='LOGIN']"));
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='Client']/../td[text()='customer-portal']"));
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='IP Address']/../td[text()='127.0.0.1' or text()='0:0:0:0:0:0:0:1']"));
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='username']/../td[text()='bburke@redhat.com']"));
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='consent']/../td[text()='consent_granted']"));
    }

    @Test
    public void historyOfAccessResourceTest() throws IOException {
        RealmRepresentation realm = this.testRealmResource().toRepresentation();
        realm.setEventsEnabled(true);
        realm.setEnabledEventTypes(Arrays.asList("LOGIN", "LOGIN_ERROR", "LOGOUT", "CODE_TO_TOKEN"));
        this.testRealmResource().update(realm);
        this.customerPortalExamplePage.navigateTo();
        this.customerPortalExamplePage.customerListing();
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        Assert.assertTrue((this.driver.getPageSource().contains("Username: bburke@redhat.com") && this.driver.getPageSource().contains("Bill Burke") && this.driver.getPageSource().contains("Stian Thorgersen") ? 1 : 0) != 0);
        if (this.isRelative()) {
            this.productPortalExamplePage.logOut();
        } else {
            this.driver.navigate().to(this.testRealmPage.getOIDCLogoutUrl() + "?redirect_uri=" + this.productPortalExamplePage);
        }
        this.loginEventsPage.navigateTo();
        if (!this.testContext.isAdminLoggedIn()) {
            this.loginPage.form().login(this.adminUser);
            this.testContext.setAdminLoggedIn(true);
        }
        this.loginEventsPage.table().filter();
        this.loginEventsPage.table().filterForm().addEventType("LOGOUT");
        this.loginEventsPage.table().update();
        List resultList = this.loginEventsPage.table().rows();
        Assert.assertEquals((long)1L, (long)resultList.size());
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='LOGOUT']"));
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='Client']/../td[text()='']"));
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='IP Address']/../td[text()='127.0.0.1' or text()='0:0:0:0:0:0:0:1']"));
        this.loginEventsPage.table().reset();
        this.loginEventsPage.table().filterForm().addEventType("LOGIN");
        this.loginEventsPage.table().update();
        resultList = this.loginEventsPage.table().rows();
        Assert.assertEquals((long)1L, (long)resultList.size());
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='LOGIN']"));
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='Client']/../td[text()='customer-portal']"));
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='IP Address']/../td[text()='127.0.0.1' or text()='0:0:0:0:0:0:0:1']"));
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='username']/../td[text()='bburke@redhat.com']"));
        this.loginEventsPage.table().reset();
        this.loginEventsPage.table().filterForm().addEventType("CODE_TO_TOKEN");
        this.loginEventsPage.table().update();
        resultList = this.loginEventsPage.table().rows();
        Assert.assertEquals((long)1L, (long)resultList.size());
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='CODE_TO_TOKEN']"));
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='Client']/../td[text()='customer-portal']"));
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='IP Address']/../td[text()='127.0.0.1' or text()='0:0:0:0:0:0:0:1']"));
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='refresh_token_type']/../td[text()='Refresh']"));
        String serverLogPath = null;
        if (System.getProperty("app.server").equals("wildfly") || System.getProperty("app.server").equals("eap6") || System.getProperty("app.server").equals("eap")) {
            serverLogPath = System.getProperty("app.server.home") + "/standalone/log/server.log";
        }
        String appServerUrl = Boolean.parseBoolean(System.getProperty("app.server.ssl.required")) ? "https://localhost:" + System.getProperty("app.server.https.port", "8543") + "/" : "http://localhost:" + System.getProperty("app.server.http.port", "8280") + "/";
        if (serverLogPath != null) {
            this.log.info((Object)("Checking app server log at: " + serverLogPath));
            File serverLog = new File(serverLogPath);
            String serverLogContent = FileUtils.readFileToString((File)serverLog);
            UserRepresentation bburke = ApiUtil.findUserByUsername(this.testRealmResource(), "bburke@redhat.com");
            Pattern pattern = Pattern.compile("User '" + bburke.getId() + "' invoking '" + appServerUrl + "customer-portal\\/customers\\/view\\.jsp[^\\s]+' on client 'customer-portal'");
            Matcher matcher = pattern.matcher(serverLogContent);
            Assert.assertTrue((boolean)matcher.find());
            Assert.assertTrue((boolean)serverLogContent.contains("User '" + bburke.getId() + "' invoking '" + appServerUrl + "database/customers' on client 'database-service'"));
        } else {
            this.log.info((Object)("Checking app server log on app-server: \"" + System.getProperty("app.server") + "\" is not supported."));
        }
    }
}

