/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.example;

import java.io.File;
import java.util.List;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.adapter.AbstractExampleAdapterTest;
import org.keycloak.testsuite.adapter.page.fuse.AdminInterface;
import org.keycloak.testsuite.adapter.page.fuse.CustomerListing;
import org.keycloak.testsuite.adapter.page.fuse.CustomerPortalFuseExample;
import org.keycloak.testsuite.adapter.page.fuse.ProductPortalFuseExample;
import org.keycloak.testsuite.auth.page.account.Account;
import org.keycloak.testsuite.auth.page.login.PageWithLoginUrl;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.IOUtil;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.WaitUtils;

public abstract class AbstractFuseExampleAdapterTest
extends AbstractExampleAdapterTest {
    @Page
    protected CustomerPortalFuseExample customerPortal;
    @Page
    protected CustomerListing customerListing;
    @Page
    protected AdminInterface adminInterface;
    @Page
    protected ProductPortalFuseExample productPortal;
    @Page
    protected Account testRealmAccount;

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation fuseRealm = IOUtil.loadRealm((File)new File(EXAMPLES_HOME_DIR + "/fuse/testrealm.json"));
        testRealms.add(fuseRealm);
    }

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testRealmPage.setAuthRealm("demo");
        this.testRealmLoginPage.setAuthRealm("demo");
        this.testRealmAccount.setAuthRealm("demo");
    }

    @Test
    public void testCustomerListingAndAccountManagement() {
        this.customerPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.customerPortal);
        this.customerPortal.clickCustomerListingLink();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.customerListing);
        String src = this.driver.getPageSource();
        Assert.assertTrue((src.contains("Username: bburke@redhat.com") && src.contains("Bill Burke") && src.contains("Stian Thorgersen") ? 1 : 0) != 0);
        this.customerListing.clickAccountManagement();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmAccount);
        Assert.assertEquals((Object)this.testRealmAccount.getUsername(), (Object)"bburke@redhat.com");
        this.driver.navigate().back();
        this.customerListing.clickLogOut();
        this.customerPortal.clickCustomerListingLink();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
    }

    @Test
    public void testAdminInterface() {
        this.customerPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.customerPortal);
        this.customerPortal.clickAdminInterfaceLink();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("admin", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.adminInterface);
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Hello admin!"));
        this.customerListing.navigateTo();
        this.customerListing.clickLogOut();
        WaitUtils.pause((long)500L);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.customerPortal);
        this.customerPortal.navigateTo();
        this.customerPortal.clickAdminInterfaceLink();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.adminInterface);
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Status code is 403"));
    }

    @Test
    public void testProductPortal() {
        this.productPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.productPortal);
        Assert.assertTrue((boolean)this.productPortal.getProduct1UnsecuredText().contains("401: Unauthorized"));
        Assert.assertTrue((boolean)this.productPortal.getProduct1SecuredText().contains("Product received: id=1"));
        Assert.assertTrue((boolean)this.productPortal.getProduct2SecuredText().contains("Product received: id=2"));
        this.productPortal.clickLogOutLink();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
    }
}

