/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.example;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.adapter.AbstractExampleAdapterTest;
import org.keycloak.testsuite.adapter.page.JSConsoleTestApp;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.auth.page.account.Applications;
import org.keycloak.testsuite.auth.page.login.OAuthGrant;
import org.keycloak.testsuite.console.page.events.Config;
import org.keycloak.testsuite.console.page.events.LoginEvents;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.IOUtil;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public abstract class AbstractJSConsoleExampleAdapterTest
extends AbstractExampleAdapterTest {
    @Page
    private JSConsoleTestApp jsConsoleTestAppPage;
    @Page
    private Config configPage;
    @Page
    private LoginEvents loginEventsPage;
    @Page
    private OAuthGrant oAuthGrantPage;
    @Page
    private Applications applicationsPage;
    public static int TOKEN_LIFESPAN_LEEWAY = 3;

    @Deployment(name="js-console-example")
    private static WebArchive jsConsoleTestApp() throws IOException {
        return AbstractJSConsoleExampleAdapterTest.exampleDeployment("integration-arquillian-test-apps-js-console");
    }

    @Deployment(name="js-database-example")
    private static WebArchive jsDbApp() throws IOException {
        return AbstractJSConsoleExampleAdapterTest.exampleDeployment("integration-arquillian-test-apps-js-database");
    }

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation jsConsoleRealm = IOUtil.loadRealm((File)new File(TEST_APPS_HOME_DIR + "/js-console/example-realm.json"));
        this.fixClientUrisUsingDeploymentUrl(jsConsoleRealm, "integration-arquillian-test-apps-js-console", this.jsConsoleTestAppPage.buildUri().toASCIIString());
        jsConsoleRealm.setAccessTokenLifespan(Integer.valueOf(30 + TOKEN_LIFESPAN_LEEWAY));
        testRealms.add(jsConsoleRealm);
    }

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testRealmPage.setAuthRealm("example");
    }

    @Test
    public void testJSConsoleAuth() {
        this.jsConsoleTestAppPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.jsConsoleTestAppPage);
        WaitUtils.waitUntilElement((WebElement)this.jsConsoleTestAppPage.getInitButtonElement()).is().present();
        this.jsConsoleTestAppPage.init();
        this.jsConsoleTestAppPage.logIn();
        this.testRealmLoginPage.form().login("user", "invalid-password");
        URLAssert.assertCurrentUrlDoesntStartWith((AbstractPage)this.jsConsoleTestAppPage);
        this.testRealmLoginPage.form().login("invalid-user", "password");
        URLAssert.assertCurrentUrlDoesntStartWith((AbstractPage)this.jsConsoleTestAppPage);
        this.testRealmLoginPage.form().login("user", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.jsConsoleTestAppPage);
        this.jsConsoleTestAppPage.init();
        WaitUtils.waitUntilElement((WebElement)this.jsConsoleTestAppPage.getOutputElement()).text().contains("Init Success (Authenticated)");
        WaitUtils.waitUntilElement((WebElement)this.jsConsoleTestAppPage.getEventsElement()).text().contains("Auth Success");
        this.jsConsoleTestAppPage.logOut();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.jsConsoleTestAppPage);
        WaitUtils.waitUntilElement((WebElement)this.jsConsoleTestAppPage.getInitButtonElement()).is().present();
        this.jsConsoleTestAppPage.init();
        WaitUtils.waitUntilElement((WebElement)this.jsConsoleTestAppPage.getOutputElement()).text().contains("Init Success (Not Authenticated)");
    }

    @Test
    public void testRefreshToken() {
        this.jsConsoleTestAppPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.jsConsoleTestAppPage);
        this.jsConsoleTestAppPage.init();
        this.jsConsoleTestAppPage.refreshToken();
        WaitUtils.waitUntilElement((WebElement)this.jsConsoleTestAppPage.getOutputElement()).text().contains("Failed to refresh token");
        this.jsConsoleTestAppPage.logIn();
        this.testRealmLoginPage.form().login("user", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.jsConsoleTestAppPage);
        this.jsConsoleTestAppPage.init();
        WaitUtils.waitUntilElement((WebElement)this.jsConsoleTestAppPage.getEventsElement()).text().contains("Auth Success");
        this.jsConsoleTestAppPage.refreshToken();
        WaitUtils.waitUntilElement((WebElement)this.jsConsoleTestAppPage.getEventsElement()).text().contains("Auth Refresh Success");
    }

    @Test
    public void testRefreshTokenIfUnder30s() {
        this.jsConsoleTestAppPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.jsConsoleTestAppPage);
        this.jsConsoleTestAppPage.init();
        this.jsConsoleTestAppPage.refreshToken();
        WaitUtils.waitUntilElement((WebElement)this.jsConsoleTestAppPage.getOutputElement()).text().contains("Failed to refresh token");
        this.jsConsoleTestAppPage.logIn();
        this.testRealmLoginPage.form().login("user", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.jsConsoleTestAppPage);
        this.jsConsoleTestAppPage.init();
        WaitUtils.waitUntilElement((WebElement)this.jsConsoleTestAppPage.getEventsElement()).text().contains("Auth Success");
        this.jsConsoleTestAppPage.refreshTokenIfUnder30s();
        WaitUtils.waitUntilElement((WebElement)this.jsConsoleTestAppPage.getOutputElement()).text().contains("Token not refreshed, valid for");
        WaitUtils.pause((long)((TOKEN_LIFESPAN_LEEWAY + 2) * 1000));
        this.jsConsoleTestAppPage.refreshTokenIfUnder30s();
        WaitUtils.waitUntilElement((WebElement)this.jsConsoleTestAppPage.getEventsElement()).text().contains("Auth Refresh Success");
    }

    @Test
    public void testGetProfile() {
        this.jsConsoleTestAppPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.jsConsoleTestAppPage);
        this.jsConsoleTestAppPage.init();
        this.jsConsoleTestAppPage.getProfile();
        WaitUtils.waitUntilElement((WebElement)this.jsConsoleTestAppPage.getOutputElement()).text().contains("Failed to load profile");
        this.jsConsoleTestAppPage.logIn();
        this.testRealmLoginPage.form().login("user", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.jsConsoleTestAppPage);
        this.jsConsoleTestAppPage.init();
        WaitUtils.waitUntilElement((WebElement)this.jsConsoleTestAppPage.getEventsElement()).text().contains("Auth Success");
        this.jsConsoleTestAppPage.getProfile();
        WaitUtils.waitUntilElement((WebElement)this.jsConsoleTestAppPage.getOutputElement()).text().contains("\"username\": \"user\"");
    }

    @Test
    public void grantBrowserBasedApp() {
        this.testRealmPage.setAuthRealm("example");
        this.testRealmLoginPage.setAuthRealm("example");
        this.configPage.setConsoleRealm("example");
        this.loginEventsPage.setConsoleRealm("example");
        this.applicationsPage.setAuthRealm("example");
        this.jsConsoleTestAppPage.navigateTo();
        this.driver.manage().deleteAllCookies();
        ClientResource clientResource = ApiUtil.findClientResourceByClientId(this.testRealmResource(), "js-console");
        ClientRepresentation client = clientResource.toRepresentation();
        client.setConsentRequired(Boolean.valueOf(true));
        clientResource.update(client);
        RealmRepresentation realm = this.testRealmResource().toRepresentation();
        realm.setEventsEnabled(true);
        realm.setEnabledEventTypes(Arrays.asList("REVOKE_GRANT", "LOGIN"));
        this.testRealmResource().update(realm);
        this.jsConsoleTestAppPage.navigateTo();
        this.jsConsoleTestAppPage.init();
        this.jsConsoleTestAppPage.logIn();
        this.testRealmLoginPage.form().login("user", "password");
        Assert.assertTrue((boolean)this.oAuthGrantPage.isCurrent());
        this.oAuthGrantPage.accept();
        this.jsConsoleTestAppPage.init();
        WaitUtils.waitUntilElement((WebElement)this.jsConsoleTestAppPage.getOutputElement()).text().contains("Init Success (Authenticated)");
        this.applicationsPage.navigateTo();
        this.applicationsPage.revokeGrantForApplication("js-console");
        this.jsConsoleTestAppPage.navigateTo();
        this.jsConsoleTestAppPage.setOnLoad("login-required");
        this.jsConsoleTestAppPage.init();
        WaitUtils.waitUntilElement((By)By.tagName((String)"body")).is().visible();
        Assert.assertTrue((boolean)this.oAuthGrantPage.isCurrent());
        this.loginEventsPage.navigateTo();
        this.loginPage.form().login(this.adminUser);
        this.loginEventsPage.table().filter();
        this.loginEventsPage.table().filterForm().addEventType("REVOKE_GRANT");
        this.loginEventsPage.table().update();
        List resultList = this.loginEventsPage.table().rows();
        Assert.assertEquals((long)1L, (long)resultList.size());
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='REVOKE_GRANT']"));
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='Client']/../td[text()='account']"));
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='IP Address']/../td[text()='127.0.0.1' or text()='0:0:0:0:0:0:0:1']"));
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='revoked_client']/../td[text()='js-console']"));
        this.loginEventsPage.table().reset();
        this.loginEventsPage.table().filterForm().addEventType("LOGIN");
        this.loginEventsPage.table().update();
        resultList = this.loginEventsPage.table().rows();
        Assert.assertEquals((long)1L, (long)resultList.size());
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='LOGIN']"));
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='Client']/../td[text()='js-console']"));
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='IP Address']/../td[text()='127.0.0.1' or text()='0:0:0:0:0:0:0:1']"));
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='username']/../td[text()='user']"));
        ((WebElement)resultList.get(0)).findElement(By.xpath((String)".//td[text()='consent']/../td[text()='consent_granted']"));
    }

    @Test
    public void implicitFlowTest() {
        this.jsConsoleTestAppPage.navigateTo();
        this.jsConsoleTestAppPage.setFlow("implicit");
        this.jsConsoleTestAppPage.init();
        this.jsConsoleTestAppPage.logIn();
        this.assertResponseError("Implicit flow is disabled for the client");
        this.setImplicitFlowForClient();
        this.jsConsoleTestAppPage.navigateTo();
        this.jsConsoleTestAppPage.init();
        this.jsConsoleTestAppPage.logIn();
        this.assertResponseError("Standard flow is disabled for the client");
        this.logInAndInit("implicit");
        WaitUtils.waitUntilElement((WebElement)this.jsConsoleTestAppPage.getOutputElement()).text().contains("Init Success (Authenticated)");
    }

    @Test
    public void implicitFlowQueryTest() {
        this.setImplicitFlowForClient();
        this.jsConsoleTestAppPage.navigateTo();
        this.jsConsoleTestAppPage.setFlow("implicit");
        this.jsConsoleTestAppPage.setResponseMode("query");
        this.jsConsoleTestAppPage.init();
        this.jsConsoleTestAppPage.logIn();
        this.assertResponseError("Response_mode 'query' not allowed");
    }

    @Test
    public void implicitFlowRefreshTokenTest() {
        this.setImplicitFlowForClient();
        this.logInAndInit("implicit");
        this.jsConsoleTestAppPage.refreshToken();
        WaitUtils.waitUntilElement((WebElement)this.jsConsoleTestAppPage.getOutputElement()).text().contains("Failed to refresh token");
    }

    @Test
    public void implicitFlowOnTokenExpireTest() {
        RealmRepresentation realm = this.testRealmResource().toRepresentation();
        realm.setAccessTokenLifespanForImplicitFlow(Integer.valueOf(5));
        this.testRealmResource().update(realm);
        this.setImplicitFlowForClient();
        this.logInAndInit("implicit");
        WaitUtils.pause((long)6000L);
        WaitUtils.waitUntilElement((WebElement)this.jsConsoleTestAppPage.getEventsElement()).text().contains("Access token expired");
    }

    @Test
    public void testBearerRequest() {
        this.jsConsoleTestAppPage.navigateTo();
        this.jsConsoleTestAppPage.init();
        this.jsConsoleTestAppPage.createBearerRequest();
        WaitUtils.waitUntilElement((WebElement)this.jsConsoleTestAppPage.getOutputElement()).text().contains("Unauthorized");
        this.logInAndInit("standard", "unauthorized");
        this.jsConsoleTestAppPage.createBearerRequest();
        WaitUtils.waitUntilElement((WebElement)this.jsConsoleTestAppPage.getOutputElement()).text().contains("Forbidden");
        this.jsConsoleTestAppPage.logOut();
        this.logInAndInit("standard");
        this.jsConsoleTestAppPage.createBearerRequest();
        WaitUtils.waitUntilElement((WebElement)this.jsConsoleTestAppPage.getOutputElement()).text().contains("[\"Bill Burke\",\"Stian Thorgersen\",\"Stan Silvert\",\"Gabriel Cardoso\",\"Viliam Rockai\",\"Marek Posolda\",\"Boleslaw Dawidowicz\"]");
    }

    @Test
    public void loginRequiredAction() {
        this.jsConsoleTestAppPage.navigateTo();
        this.jsConsoleTestAppPage.setOnLoad("login-required");
        this.jsConsoleTestAppPage.init();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmLoginPage);
        this.testRealmLoginPage.form().login("user", "password");
        WaitUtils.waitUntilElement((WebElement)this.jsConsoleTestAppPage.getInitButtonElement()).is().present();
        this.jsConsoleTestAppPage.init();
        WaitUtils.waitUntilElement((WebElement)this.jsConsoleTestAppPage.getOutputElement()).text().contains("Init Success (Authenticated)");
    }

    private void setImplicitFlowForClient() {
        ClientResource clientResource = ApiUtil.findClientResourceByClientId(this.testRealmResource(), "js-console");
        ClientRepresentation client = clientResource.toRepresentation();
        client.setImplicitFlowEnabled(Boolean.valueOf(true));
        client.setStandardFlowEnabled(Boolean.valueOf(false));
        clientResource.update(client);
    }

    private void logInAndInit(String flow, String user) {
        this.jsConsoleTestAppPage.navigateTo();
        this.jsConsoleTestAppPage.setFlow(flow);
        this.jsConsoleTestAppPage.init();
        this.jsConsoleTestAppPage.logIn();
        this.testRealmLoginPage.form().login(user, "password");
        this.jsConsoleTestAppPage.setFlow(flow);
        this.jsConsoleTestAppPage.init();
    }

    private void logInAndInit(String flow) {
        this.logInAndInit(flow, "user");
    }

    private void assertResponseError(String errorDescription) {
        this.jsConsoleTestAppPage.showErrorResponse();
        Assert.assertTrue((boolean)this.jsConsoleTestAppPage.getOutputElement().getText().contains(errorDescription));
    }
}

