/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.example;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.adapter.AbstractExampleAdapterTest;
import org.keycloak.testsuite.adapter.page.SAMLPostEncExample;
import org.keycloak.testsuite.adapter.page.SAMLPostSigExample;
import org.keycloak.testsuite.adapter.page.SAMLRedirectSigExample;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.IOUtil;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;

public abstract class AbstractSAMLExampleAdapterTest
extends AbstractExampleAdapterTest {
    @Page
    private SAMLPostSigExample samlPostSigExamplePage;
    @Page
    private SAMLPostEncExample samlPostEncExamplePage;
    @Page
    private SAMLRedirectSigExample samlRedirectSigExamplePage;

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation samlRealm = IOUtil.loadRealm((File)new File(EXAMPLES_HOME_DIR + "/saml/testsaml.json"));
        testRealms.add(samlRealm);
    }

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testRealmPage.setAuthRealm("saml-demo");
        this.testRealmSAMLRedirectLoginPage.setAuthRealm("saml-demo");
        this.testRealmSAMLPostLoginPage.setAuthRealm("saml-demo");
    }

    @Deployment(name="sales-post-sig")
    private static WebArchive samlPostSigExampleDeployment() throws IOException {
        return AbstractSAMLExampleAdapterTest.exampleDeployment("sales-post-sig");
    }

    @Deployment(name="saml-post-encryption")
    private static WebArchive samlPostEncExampleDeployment() throws IOException {
        return AbstractSAMLExampleAdapterTest.exampleDeployment("saml-post-encryption");
    }

    @Deployment(name="saml-redirect-signatures")
    private static WebArchive samlRedirectSigExampleDeployment() throws IOException {
        return AbstractSAMLExampleAdapterTest.exampleDeployment("saml-redirect-signatures");
    }

    @Test
    public void samlPostWithSignatureExampleTest() {
        this.samlPostSigExamplePage.navigateTo();
        this.testRealmSAMLPostLoginPage.form().login(this.bburkeUser);
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("Welcome to the Sales Tool, " + this.bburkeUser.getUsername());
        this.samlPostSigExamplePage.logout();
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("Logged out.");
        this.samlPostSigExamplePage.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void samlPostWithEncryptionExampleTest() {
        this.samlPostEncExamplePage.navigateTo();
        this.testRealmSAMLPostLoginPage.form().login(this.bburkeUser);
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("Welcome to the Sales Tool, " + this.bburkeUser.getUsername());
        this.samlPostEncExamplePage.logout();
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("Logged out.");
        this.samlPostEncExamplePage.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void samlRedirectWithSignatureExampleTest() {
        this.samlRedirectSigExamplePage.navigateTo();
        this.testRealmSAMLRedirectLoginPage.form().login(this.bburkeUser);
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("Welcome to the Employee Tool,");
        this.samlRedirectSigExamplePage.logout();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmSAMLRedirectLoginPage);
        this.samlRedirectSigExamplePage.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmSAMLRedirectLoginPage);
    }
}

