/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.example.authorization;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.adapter.AbstractExampleAdapterTest;
import org.keycloak.testsuite.util.IOUtil;

public abstract class AbstractDefaultAuthzConfigAdapterTest
extends AbstractExampleAdapterTest {
    private static final String REALM_NAME = "hello-world-authz";
    private static final String RESOURCE_SERVER_ID = "hello-world-authz-service";
    @ArquillianResource
    private Deployer deployer;

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((File)new File(TEST_APPS_HOME_DIR + "/hello-world-authz-service/hello-world-authz-realm.json")));
    }

    @Deployment(name="hello-world-authz-service", managed=false)
    public static WebArchive deployment() throws IOException {
        return AbstractDefaultAuthzConfigAdapterTest.exampleDeployment(RESOURCE_SERVER_ID);
    }

    @Test
    public void testDefaultAuthzConfig() throws Exception {
        try {
            this.configureAuthorizationServices();
            this.deployer.deploy(RESOURCE_SERVER_ID);
            this.login();
            Assert.assertTrue((boolean)this.driver.getPageSource().contains("Your permissions are"));
            Assert.assertTrue((boolean)this.driver.getPageSource().contains("Default Resource"));
        }
        finally {
            this.deployer.undeploy(RESOURCE_SERVER_ID);
        }
    }

    private void login() throws MalformedURLException {
        this.driver.navigate().to(this.getResourceServerUrl());
        this.loginPage.form().login("alice", "alice");
    }

    private URL getResourceServerUrl() throws MalformedURLException {
        return this.appServerContextRootPage.getUriBuilder().path(RESOURCE_SERVER_ID).build(new Object[0]).toURL();
    }

    private void configureAuthorizationServices() {
        ClientsResource clients = this.realmsResouce().realm(REALM_NAME).clients();
        ClientRepresentation client = (ClientRepresentation)clients.findByClientId(RESOURCE_SERVER_ID).get(0);
        client.setAuthorizationServicesEnabled(Boolean.valueOf(false));
        clients.get(client.getId()).update(client);
        client.setAuthorizationServicesEnabled(Boolean.valueOf(true));
        clients.get(client.getId()).update(client);
    }
}

