/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.example.authorization;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.ResourcesResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.testsuite.adapter.AbstractExampleAdapterTest;
import org.keycloak.testsuite.adapter.page.PhotozClientAuthzTestApp;
import org.keycloak.testsuite.util.IOUtil;
import org.keycloak.util.JsonSerialization;

public abstract class AbstractPhotozExampleAdapterTest
extends AbstractExampleAdapterTest {
    private static final String REALM_NAME = "photoz";
    private static final String RESOURCE_SERVER_ID = "photoz-restful-api";
    private static int TOKEN_LIFESPAN_LEEWAY = 3;
    @ArquillianResource
    private Deployer deployer;
    @Page
    private PhotozClientAuthzTestApp clientPage;

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testRealmPage.setAuthRealm(REALM_NAME);
    }

    @Before
    public void beforePhotozExampleAdapterTest() {
        this.deleteAllCookiesForClientPage();
    }

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = IOUtil.loadRealm((File)new File(TEST_APPS_HOME_DIR + "/photoz/photoz-realm.json"));
        realm.setAccessTokenLifespan(Integer.valueOf(30 + TOKEN_LIFESPAN_LEEWAY));
        testRealms.add(realm);
    }

    @Deployment(name="photoz-html5-client")
    public static WebArchive deploymentClient() throws IOException {
        return AbstractPhotozExampleAdapterTest.exampleDeployment("photoz-html5-client");
    }

    @Deployment(name="photoz-restful-api", managed=false)
    public static WebArchive deploymentResourceServer() throws IOException {
        return AbstractPhotozExampleAdapterTest.exampleDeployment(RESOURCE_SERVER_ID);
    }

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
        this.importResourceServerSettings();
    }

    @Test
    public void testUserCanCreateAndDeleteAlbum() throws Exception {
        try {
            this.deployer.deploy(RESOURCE_SERVER_ID);
            this.loginToClientPage("alice", "alice", new String[0]);
            this.clientPage.createAlbum("Alice Family Album");
            List resources = this.getAuthorizationResource().resources().resources();
            Assert.assertFalse((boolean)resources.stream().filter(resource -> resource.getOwner().getName().equals("alice")).collect(Collectors.toList()).isEmpty());
            this.clientPage.deleteAlbum("Alice Family Album");
            resources = this.getAuthorizationResource().resources().resources();
            Assert.assertTrue((boolean)resources.stream().filter(resource -> resource.getOwner().getName().equals("alice")).collect(Collectors.toList()).isEmpty());
        }
        finally {
            this.deployer.undeploy(RESOURCE_SERVER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOnlyOwnerCanDeleteAlbum() throws Exception {
        try {
            this.deployer.deploy(RESOURCE_SERVER_ID);
            this.loginToClientPage("alice", "alice", new String[0]);
            this.clientPage.createAlbum("Alice-Family-Album");
            this.loginToClientPage("admin", "admin", new String[0]);
            this.clientPage.navigateToAdminAlbum();
            List resources = this.getAuthorizationResource().resources().resources();
            Assert.assertFalse((boolean)resources.stream().filter(resource -> resource.getOwner().getName().equals("alice")).collect(Collectors.toList()).isEmpty());
            for (PolicyRepresentation policy : this.getAuthorizationResource().policies().policies()) {
                if (!"Delete Album Permission".equals(policy.getName())) continue;
                policy.getConfig().put("applyPolicies", "[\"Only Owner Policy\"]");
                this.getAuthorizationResource().policies().policy(policy.getId()).update(policy);
            }
            this.loginToClientPage("admin", "admin", new String[0]);
            this.clientPage.navigateToAdminAlbum();
            this.clientPage.deleteAlbum("Alice-Family-Album");
            Assert.assertTrue((boolean)this.clientPage.wasDenied());
            resources = this.getAuthorizationResource().resources().resources();
            Assert.assertFalse((boolean)resources.stream().filter(resource -> resource.getOwner().getName().equals("alice")).collect(Collectors.toList()).isEmpty());
            for (PolicyRepresentation policy : this.getAuthorizationResource().policies().policies()) {
                if (!"Delete Album Permission".equals(policy.getName())) continue;
                policy.getConfig().put("applyPolicies", "[\"Only Owner and Administrators Policy\"]");
                this.getAuthorizationResource().policies().policy(policy.getId()).update(policy);
            }
            this.clientPage.navigateToAdminAlbum();
            this.clientPage.deleteAlbum("Alice-Family-Album");
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            resources = this.getAuthorizationResource().resources().resources();
            Assert.assertTrue((boolean)resources.stream().filter(resource -> resource.getOwner().getName().equals("alice")).collect(Collectors.toList()).isEmpty());
        }
        finally {
            this.deployer.undeploy(RESOURCE_SERVER_ID);
        }
    }

    @Test
    public void testRegularUserCanNotAccessAdminResources() throws Exception {
        try {
            this.deployer.deploy(RESOURCE_SERVER_ID);
            this.loginToClientPage("alice", "alice", new String[0]);
            this.clientPage.navigateToAdminAlbum();
            Assert.assertTrue((boolean)this.clientPage.wasDenied());
        }
        finally {
            this.deployer.undeploy(RESOURCE_SERVER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminOnlyFromSpecificAddress() throws Exception {
        try {
            this.deployer.deploy(RESOURCE_SERVER_ID);
            this.loginToClientPage("admin", "admin", new String[0]);
            this.clientPage.navigateToAdminAlbum();
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            for (PolicyRepresentation policy : this.getAuthorizationResource().policies().policies()) {
                if (!"Only From a Specific Client Address".equals(policy.getName())) continue;
                String code = (String)policy.getConfig().get("code");
                policy.getConfig().put("code", code.replaceAll("127.0.0.1", "127.3.3.3"));
                this.getAuthorizationResource().policies().policy(policy.getId()).update(policy);
            }
            this.clientPage.navigateToAdminAlbum();
            Assert.assertTrue((boolean)this.clientPage.wasDenied());
        }
        finally {
            this.deployer.undeploy(RESOURCE_SERVER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminWithoutPermissionsToTypedResource() throws Exception {
        try {
            this.deployer.deploy(RESOURCE_SERVER_ID);
            this.loginToClientPage("alice", "alice", new String[0]);
            this.clientPage.createAlbum("Alice Family Album");
            this.loginToClientPage("admin", "admin", new String[0]);
            this.clientPage.navigateToAdminAlbum();
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            this.clientPage.viewAlbum("Alice Family Album");
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            for (PolicyRepresentation policy : this.getAuthorizationResource().policies().policies()) {
                if ("Album Resource Permission".equals(policy.getName())) {
                    policy.getConfig().put("applyPolicies", "[\"Any User Policy\"]");
                    this.getAuthorizationResource().policies().policy(policy.getId()).update(policy);
                }
                if (!"Any User Policy".equals(policy.getName())) continue;
                ClientResource resourceServerClient = this.getClientResource(RESOURCE_SERVER_ID);
                RoleResource manageAlbumRole = resourceServerClient.roles().get("manage-albums");
                final RoleRepresentation roleRepresentation = manageAlbumRole.toRepresentation();
                List roles = (List)JsonSerialization.readValue((String)((String)policy.getConfig().get("roles")), List.class);
                roles = roles.stream().filter(new Predicate<Map>(){

                    @Override
                    public boolean test(Map map) {
                        return !map.get("id").equals(roleRepresentation.getId());
                    }
                }).collect(Collectors.toList());
                policy.getConfig().put("roles", JsonSerialization.writeValueAsString(roles));
                this.getAuthorizationResource().policies().policy(policy.getId()).update(policy);
            }
            this.clientPage.navigateToAdminAlbum();
            this.clientPage.viewAlbum("Alice Family Album");
            Assert.assertTrue((boolean)this.clientPage.wasDenied());
            for (PolicyRepresentation policy : this.getAuthorizationResource().policies().policies()) {
                if (!"Album Resource Permission".equals(policy.getName())) continue;
                policy.getConfig().put("applyPolicies", "[\"Any User Policy\", \"Administration Policy\"]");
                this.getAuthorizationResource().policies().policy(policy.getId()).update(policy);
            }
            this.clientPage.navigateToAdminAlbum();
            this.clientPage.viewAlbum("Alice Family Album");
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            this.clientPage.navigateToAdminAlbum();
            this.clientPage.deleteAlbum("Alice Family Album");
            List resources = this.getAuthorizationResource().resources().resources();
            Assert.assertTrue((boolean)resources.stream().filter(resource -> resource.getOwner().getName().equals("alice")).collect(Collectors.toList()).isEmpty());
        }
        finally {
            this.deployer.undeploy(RESOURCE_SERVER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminWithoutPermissionsToDeleteAlbum() throws Exception {
        try {
            this.deployer.deploy(RESOURCE_SERVER_ID);
            this.loginToClientPage("alice", "alice", new String[0]);
            this.clientPage.createAlbum("Alice Family Album");
            this.loginToClientPage("admin", "admin", new String[0]);
            this.clientPage.navigateToAdminAlbum();
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            this.clientPage.deleteAlbum("Alice Family Album");
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            List resources = this.getAuthorizationResource().resources().resources();
            Assert.assertTrue((boolean)resources.stream().filter(resource -> resource.getOwner().getName().equals("alice")).collect(Collectors.toList()).isEmpty());
            for (PolicyRepresentation policy : this.getAuthorizationResource().policies().policies()) {
                if (!"Delete Album Permission".equals(policy.getName())) continue;
                policy.getConfig().put("applyPolicies", "[\"Only Owner Policy\"]");
                this.getAuthorizationResource().policies().policy(policy.getId()).update(policy);
            }
            this.loginToClientPage("alice", "alice", new String[0]);
            this.clientPage.createAlbum("Alice Family Album");
            this.loginToClientPage("admin", "admin", new String[0]);
            this.clientPage.navigateToAdminAlbum();
            this.clientPage.viewAlbum("Alice Family Album");
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            resources = this.getAuthorizationResource().resources().resources();
            Assert.assertFalse((boolean)resources.stream().filter(resource -> resource.getOwner().getName().equals("alice")).collect(Collectors.toList()).isEmpty());
            this.clientPage.navigateToAdminAlbum();
            this.clientPage.deleteAlbum("Alice Family Album");
            Assert.assertTrue((boolean)this.clientPage.wasDenied());
            for (PolicyRepresentation policy : this.getAuthorizationResource().policies().policies()) {
                if (!"Delete Album Permission".equals(policy.getName())) continue;
                policy.getConfig().put("applyPolicies", "[\"Only Owner and Administrators Policy\"]");
                this.getAuthorizationResource().policies().policy(policy.getId()).update(policy);
            }
            this.clientPage.navigateToAdminAlbum();
            this.clientPage.deleteAlbum("Alice Family Album");
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            resources = this.getAuthorizationResource().resources().resources();
            Assert.assertTrue((boolean)resources.stream().filter(resource -> resource.getOwner().getName().equals("alice")).collect(Collectors.toList()).isEmpty());
        }
        finally {
            this.deployer.undeploy(RESOURCE_SERVER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientRoleRepresentingUserConsent() throws Exception {
        try {
            this.deployer.deploy(RESOURCE_SERVER_ID);
            this.loginToClientPage("alice", "alice", new String[0]);
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            UsersResource usersResource = this.realmsResouce().realm(REALM_NAME).users();
            List users = usersResource.search("alice", null, null, null, null, null);
            Assert.assertFalse((boolean)users.isEmpty());
            UserRepresentation userRepresentation = (UserRepresentation)users.get(0);
            UserResource userResource = usersResource.get(userRepresentation.getId());
            ClientResource html5ClientApp = this.getClientResource("photoz-html5-client");
            userResource.revokeConsent(html5ClientApp.toRepresentation().getClientId());
            ClientResource resourceServerClient = this.getClientResource(RESOURCE_SERVER_ID);
            RoleResource roleResource = resourceServerClient.roles().get("manage-albums");
            RoleRepresentation roleRepresentation = roleResource.toRepresentation();
            roleRepresentation.setScopeParamRequired(Boolean.valueOf(true));
            roleResource.update(roleRepresentation);
            this.loginToClientPage("alice", "alice", new String[0]);
            Assert.assertTrue((boolean)this.clientPage.wasDenied());
            this.loginToClientPage("alice", "alice", "photoz-restful-api/manage-albums");
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
        }
        finally {
            this.deployer.undeploy(RESOURCE_SERVER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientRoleNotRequired() throws Exception {
        try {
            this.deployer.deploy(RESOURCE_SERVER_ID);
            this.loginToClientPage("alice", "alice", new String[0]);
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            UsersResource usersResource = this.realmsResouce().realm(REALM_NAME).users();
            List users = usersResource.search("alice", null, null, null, null, null);
            Assert.assertFalse((boolean)users.isEmpty());
            UserRepresentation userRepresentation = (UserRepresentation)users.get(0);
            UserResource userResource = usersResource.get(userRepresentation.getId());
            ClientResource html5ClientApp = this.getClientResource("photoz-html5-client");
            userResource.revokeConsent(html5ClientApp.toRepresentation().getClientId());
            ClientResource resourceServerClient = this.getClientResource(RESOURCE_SERVER_ID);
            RoleResource manageAlbumRole = resourceServerClient.roles().get("manage-albums");
            RoleRepresentation roleRepresentation = manageAlbumRole.toRepresentation();
            roleRepresentation.setScopeParamRequired(Boolean.valueOf(true));
            manageAlbumRole.update(roleRepresentation);
            this.loginToClientPage("alice", "alice", new String[0]);
            Assert.assertTrue((boolean)this.clientPage.wasDenied());
            for (PolicyRepresentation policy : this.getAuthorizationResource().policies().policies()) {
                if (!"Any User Policy".equals(policy.getName())) continue;
                List roles = (List)JsonSerialization.readValue((String)((String)policy.getConfig().get("roles")), List.class);
                roles.forEach(role -> {
                    String roleId = (String)role.get("id");
                    if (roleId.equals(manageAlbumRole.toRepresentation().getId())) {
                        role.put("required", false);
                    }
                });
                policy.getConfig().put("roles", JsonSerialization.writeValueAsString((Object)roles));
                this.getAuthorizationResource().policies().policy(policy.getId()).update(policy);
            }
            this.loginToClientPage("alice", "alice", new String[0]);
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
        }
        finally {
            this.deployer.undeploy(RESOURCE_SERVER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOverridePermissionFromResourceParent() throws Exception {
        try {
            this.deployer.deploy(RESOURCE_SERVER_ID);
            this.loginToClientPage("alice", "alice", new String[0]);
            String resourceName = "My Resource Instance";
            this.clientPage.createAlbum(resourceName);
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            this.clientPage.viewAlbum(resourceName);
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            this.clientPage.navigateTo();
            this.clientPage.deleteAlbum(resourceName);
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            this.clientPage.createAlbum(resourceName);
            this.loginToClientPage("admin", "admin", new String[0]);
            this.clientPage.navigateToAdminAlbum();
            this.clientPage.viewAlbum(resourceName);
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            this.clientPage.navigateToAdminAlbum();
            this.clientPage.deleteAlbum(resourceName);
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            this.loginToClientPage("alice", "alice", new String[0]);
            this.clientPage.createAlbum(resourceName);
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            this.getAuthorizationResource().resources().resources().forEach(resource -> {
                if (resource.getName().equals(resourceName)) {
                    try {
                        PolicyRepresentation resourceInstancePermission = new PolicyRepresentation();
                        resourceInstancePermission.setName(resourceName + "Permission");
                        resourceInstancePermission.setType("resource");
                        HashMap<String, String> config = new HashMap<String, String>();
                        config.put("resources", JsonSerialization.writeValueAsString(Arrays.asList(resource.getId())));
                        config.put("applyPolicies", JsonSerialization.writeValueAsString(Arrays.asList("Only Owner Policy")));
                        resourceInstancePermission.setConfig(config);
                        this.getAuthorizationResource().policies().create(resourceInstancePermission);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error creating policy.", e);
                    }
                }
            });
            this.loginToClientPage("admin", "admin", new String[0]);
            this.clientPage.navigateToAdminAlbum();
            this.clientPage.viewAlbum(resourceName);
            Assert.assertTrue((boolean)this.clientPage.wasDenied());
            this.clientPage.navigateToAdminAlbum();
            this.clientPage.deleteAlbum(resourceName);
            Assert.assertTrue((boolean)this.clientPage.wasDenied());
            this.loginToClientPage("alice", "alice", new String[0]);
            this.clientPage.deleteAlbum(resourceName);
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            ResourcesResource resourcesResource = this.getAuthorizationResource().resources();
            List resources = resourcesResource.resources();
            Assert.assertTrue((boolean)resources.stream().filter(resource -> resource.getOwner().getName().equals("alice")).collect(Collectors.toList()).isEmpty());
        }
        finally {
            this.deployer.undeploy(RESOURCE_SERVER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInheritPermissionFromResourceParent() throws Exception {
        try {
            this.deployer.deploy(RESOURCE_SERVER_ID);
            this.loginToClientPage("alice", "alice", new String[0]);
            String resourceName = "My Resource Instance";
            this.clientPage.createAlbum(resourceName);
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            this.clientPage.viewAlbum(resourceName);
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            this.clientPage.navigateTo();
            this.clientPage.deleteAlbum(resourceName);
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            this.clientPage.createAlbum(resourceName);
            this.loginToClientPage("admin", "admin", new String[0]);
            this.clientPage.navigateToAdminAlbum();
            this.clientPage.viewAlbum(resourceName);
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            this.clientPage.navigateToAdminAlbum();
            this.clientPage.deleteAlbum(resourceName);
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            this.loginToClientPage("alice", "alice", new String[0]);
            this.clientPage.createAlbum(resourceName);
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            ResourcesResource resourcesResource = this.getAuthorizationResource().resources();
            resourcesResource.resources().forEach(resource -> {
                if (resource.getName().equals(resourceName)) {
                    try {
                        PolicyRepresentation resourceInstancePermission = new PolicyRepresentation();
                        resourceInstancePermission.setName(resourceName + "Permission");
                        resourceInstancePermission.setType("resource");
                        HashMap<String, String> config = new HashMap<String, String>();
                        config.put("resources", JsonSerialization.writeValueAsString(Arrays.asList(resource.getId())));
                        config.put("applyPolicies", JsonSerialization.writeValueAsString(Arrays.asList("Only Owner Policy")));
                        resourceInstancePermission.setConfig(config);
                        this.getAuthorizationResource().policies().create(resourceInstancePermission);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error creating policy.", e);
                    }
                }
            });
            this.loginToClientPage("admin", "admin", new String[0]);
            this.clientPage.navigateToAdminAlbum();
            this.clientPage.viewAlbum(resourceName);
            Assert.assertTrue((boolean)this.clientPage.wasDenied());
            this.clientPage.navigateToAdminAlbum();
            this.clientPage.deleteAlbum(resourceName);
            Assert.assertTrue((boolean)this.clientPage.wasDenied());
            resourcesResource.resources().forEach(resource -> {
                if (resource.getName().equals(resourceName)) {
                    resource.setScopes(resource.getScopes().stream().filter(scope -> !scope.getName().equals("urn:photoz.com:scopes:album:view")).collect(Collectors.toSet()));
                    resourcesResource.resource(resource.getId()).update(resource);
                }
            });
            this.loginToClientPage("admin", "admin", new String[0]);
            this.clientPage.navigateToAdminAlbum();
            this.clientPage.viewAlbum(resourceName);
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            this.clientPage.navigateToAdminAlbum();
            this.clientPage.deleteAlbum(resourceName);
            Assert.assertTrue((boolean)this.clientPage.wasDenied());
            this.loginToClientPage("alice", "alice", new String[0]);
            this.clientPage.deleteAlbum(resourceName);
            Assert.assertFalse((boolean)this.clientPage.wasDenied());
            List resources = resourcesResource.resources();
            Assert.assertTrue((boolean)resources.stream().filter(resource -> resource.getOwner().getName().equals("alice")).collect(Collectors.toList()).isEmpty());
            resourcesResource.resources().forEach(resource -> {
                if (resource.getName().equals(resourceName)) {
                    resource.setScopes(Collections.emptySet());
                    resourcesResource.resource(resource.getId()).update(resource);
                }
            });
        }
        finally {
            this.deployer.undeploy(RESOURCE_SERVER_ID);
        }
    }

    private void importResourceServerSettings() throws FileNotFoundException {
        this.getAuthorizationResource().importSettings((ResourceServerRepresentation)IOUtil.loadJson((InputStream)new FileInputStream(new File(TEST_APPS_HOME_DIR + "/photoz/photoz-restful-api-authz-service.json")), ResourceServerRepresentation.class));
    }

    private AuthorizationResource getAuthorizationResource() throws FileNotFoundException {
        return this.getClientResource(RESOURCE_SERVER_ID).authorization();
    }

    private ClientResource getClientResource(String clientId) {
        ClientsResource clients = this.realmsResouce().realm(REALM_NAME).clients();
        ClientRepresentation resourceServer = (ClientRepresentation)clients.findByClientId(clientId).get(0);
        return clients.get(resourceServer.getId());
    }

    private void deleteAllCookiesForClientPage() {
        this.clientPage.navigateTo();
        this.driver.manage().deleteAllCookies();
    }

    private void loginToClientPage(String username, String password, String ... scopes) {
        this.deleteAllCookiesForClientPage();
        this.deleteAllCookiesForTestRealm();
        this.clientPage.navigateTo();
        this.clientPage.login(username, password, scopes);
    }
}

