/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.example.authorization;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.testsuite.adapter.AbstractExampleAdapterTest;
import org.keycloak.testsuite.util.IOUtil;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.util.JsonSerialization;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public abstract class AbstractServletAuthzAdapterTest
extends AbstractExampleAdapterTest {
    private static final String REALM_NAME = "servlet-authz";
    private static final String RESOURCE_SERVER_ID = "servlet-authz-app";
    @ArquillianResource
    private Deployer deployer;

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((File)new File(TEST_APPS_HOME_DIR + "/servlet-authz-app/servlet-authz-realm.json")));
    }

    @Deployment(name="servlet-authz-app", managed=false)
    public static WebArchive deployment() throws IOException {
        return AbstractServletAuthzAdapterTest.exampleDeployment(RESOURCE_SERVER_ID);
    }

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
        this.importResourceServerSettings();
    }

    @Test
    public void testRegularUserPermissions() throws Exception {
        try {
            this.deployer.deploy(RESOURCE_SERVER_ID);
            this.login("alice", "alice");
            Assert.assertFalse((boolean)this.wasDenied());
            Assert.assertTrue((boolean)this.hasLink("User Premium"));
            Assert.assertTrue((boolean)this.hasLink("Administration"));
            Assert.assertTrue((boolean)this.hasText("urn:servlet-authz:page:main:actionForUser"));
            Assert.assertFalse((boolean)this.hasText("urn:servlet-authz:page:main:actionForAdmin"));
            Assert.assertFalse((boolean)this.hasText("urn:servlet-authz:page:main:actionForPremiumUser"));
            this.navigateToDynamicMenuPage();
            Assert.assertTrue((boolean)this.hasText("Do user thing"));
            Assert.assertFalse((boolean)this.hasText("Do  user premium thing"));
            Assert.assertFalse((boolean)this.hasText("Do administration thing"));
            this.navigateToUserPremiumPage();
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateToAdminPage();
            Assert.assertTrue((boolean)this.wasDenied());
        }
        finally {
            this.deployer.undeploy(RESOURCE_SERVER_ID);
        }
    }

    @Test
    public void testUserPremiumPermissions() throws Exception {
        try {
            this.deployer.deploy(RESOURCE_SERVER_ID);
            this.login("jdoe", "jdoe");
            Assert.assertFalse((boolean)this.wasDenied());
            Assert.assertTrue((boolean)this.hasLink("User Premium"));
            Assert.assertTrue((boolean)this.hasLink("Administration"));
            Assert.assertTrue((boolean)this.hasText("urn:servlet-authz:page:main:actionForUser"));
            Assert.assertTrue((boolean)this.hasText("urn:servlet-authz:page:main:actionForPremiumUser"));
            Assert.assertFalse((boolean)this.hasText("urn:servlet-authz:page:main:actionForAdmin"));
            this.navigateToDynamicMenuPage();
            Assert.assertTrue((boolean)this.hasText("Do user thing"));
            Assert.assertTrue((boolean)this.hasText("Do  user premium thing"));
            Assert.assertFalse((boolean)this.hasText("Do administration thing"));
            this.navigateToUserPremiumPage();
            Assert.assertFalse((boolean)this.wasDenied());
            this.navigateToAdminPage();
            Assert.assertTrue((boolean)this.wasDenied());
        }
        finally {
            this.deployer.undeploy(RESOURCE_SERVER_ID);
        }
    }

    @Test
    public void testAdminPermissions() throws Exception {
        try {
            this.deployer.deploy(RESOURCE_SERVER_ID);
            this.login("admin", "admin");
            Assert.assertFalse((boolean)this.wasDenied());
            Assert.assertTrue((boolean)this.hasLink("User Premium"));
            Assert.assertTrue((boolean)this.hasLink("Administration"));
            Assert.assertTrue((boolean)this.hasText("urn:servlet-authz:page:main:actionForUser"));
            Assert.assertTrue((boolean)this.hasText("urn:servlet-authz:page:main:actionForAdmin"));
            Assert.assertFalse((boolean)this.hasText("urn:servlet-authz:page:main:actionForPremiumUser"));
            this.navigateToDynamicMenuPage();
            Assert.assertTrue((boolean)this.hasText("Do user thing"));
            Assert.assertTrue((boolean)this.hasText("Do administration thing"));
            Assert.assertFalse((boolean)this.hasText("Do  user premium thing"));
            this.navigateToUserPremiumPage();
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateToAdminPage();
            Assert.assertFalse((boolean)this.wasDenied());
        }
        finally {
            this.deployer.undeploy(RESOURCE_SERVER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGrantPremiumAccessToUser() throws Exception {
        try {
            this.deployer.deploy(RESOURCE_SERVER_ID);
            this.login("alice", "alice");
            Assert.assertFalse((boolean)this.wasDenied());
            this.navigateToUserPremiumPage();
            Assert.assertTrue((boolean)this.wasDenied());
            for (PolicyRepresentation policy : this.getAuthorizationResource().policies().policies()) {
                if (!"Premium Resource Permission".equals(policy.getName())) continue;
                policy.getConfig().put("applyPolicies", "[\"Any User Policy\"]");
                this.getAuthorizationResource().policies().policy(policy.getId()).update(policy);
            }
            this.login("alice", "alice");
            this.navigateToUserPremiumPage();
            Assert.assertFalse((boolean)this.wasDenied());
            for (PolicyRepresentation policy : this.getAuthorizationResource().policies().policies()) {
                if (!"Premium Resource Permission".equals(policy.getName())) continue;
                policy.getConfig().put("applyPolicies", "[\"Only Premium User Policy\"]");
                this.getAuthorizationResource().policies().policy(policy.getId()).update(policy);
            }
            this.login("alice", "alice");
            this.navigateToUserPremiumPage();
            Assert.assertTrue((boolean)this.wasDenied());
            PolicyRepresentation onlyAlicePolicy = new PolicyRepresentation();
            onlyAlicePolicy.setName("Temporary Premium Access Policy");
            onlyAlicePolicy.setType("user");
            HashMap<String, String> config = new HashMap<String, String>();
            UsersResource usersResource = this.realmsResouce().realm(REALM_NAME).users();
            List users = usersResource.search("alice", null, null, null, null, null);
            Assert.assertFalse((boolean)users.isEmpty());
            config.put("users", JsonSerialization.writeValueAsString(Arrays.asList(((UserRepresentation)users.get(0)).getId())));
            onlyAlicePolicy.setConfig(config);
            this.getAuthorizationResource().policies().create(onlyAlicePolicy);
            for (PolicyRepresentation policy : this.getAuthorizationResource().policies().policies()) {
                if (!"Premium Resource Permission".equals(policy.getName())) continue;
                policy.getConfig().put("applyPolicies", "[\"Temporary Premium Access Policy\"]");
                this.getAuthorizationResource().policies().policy(policy.getId()).update(policy);
            }
            this.login("alice", "alice");
            this.navigateToUserPremiumPage();
            Assert.assertFalse((boolean)this.wasDenied());
        }
        finally {
            this.deployer.undeploy(RESOURCE_SERVER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGrantAdministrativePermissions() throws Exception {
        try {
            this.deployer.deploy(RESOURCE_SERVER_ID);
            this.login("jdoe", "jdoe");
            this.navigateToAdminPage();
            Assert.assertTrue((boolean)this.wasDenied());
            RealmResource realmResource = this.realmsResouce().realm(REALM_NAME);
            UsersResource usersResource = realmResource.users();
            List users = usersResource.search("jdoe", null, null, null, null, null);
            Assert.assertFalse((boolean)users.isEmpty());
            UserResource userResource = usersResource.get(((UserRepresentation)users.get(0)).getId());
            RoleRepresentation adminRole = realmResource.roles().get("admin").toRepresentation();
            userResource.roles().realmLevel().add(Arrays.asList(adminRole));
            this.login("jdoe", "jdoe");
            this.navigateToAdminPage();
            Assert.assertFalse((boolean)this.wasDenied());
        }
        finally {
            this.deployer.undeploy(RESOURCE_SERVER_ID);
        }
    }

    private boolean hasLink(String text) {
        return this.getLink(text) != null;
    }

    private boolean hasText(String text) {
        return this.driver.getPageSource().contains(text);
    }

    private WebElement getLink(String text) {
        return this.driver.findElement(By.xpath((String)("//a[text() = '" + text + "']")));
    }

    private void importResourceServerSettings() throws FileNotFoundException {
        this.getAuthorizationResource().importSettings((ResourceServerRepresentation)IOUtil.loadJson((InputStream)new FileInputStream(new File(TEST_APPS_HOME_DIR + "/servlet-authz-app/servlet-authz-app-authz-service.json")), ResourceServerRepresentation.class));
    }

    private AuthorizationResource getAuthorizationResource() throws FileNotFoundException {
        return this.getClientResource(RESOURCE_SERVER_ID).authorization();
    }

    private ClientResource getClientResource(String clientId) {
        ClientsResource clients = this.realmsResouce().realm(REALM_NAME).clients();
        ClientRepresentation resourceServer = (ClientRepresentation)clients.findByClientId(clientId).get(0);
        return clients.get(resourceServer.getId());
    }

    private void logOut() {
        this.navigateTo();
        By by = By.xpath((String)"//a[text() = 'Sign Out']");
        WaitUtils.waitUntilElement((By)by);
        this.driver.findElement(by).click();
        WaitUtils.pause((long)500L);
    }

    private void login(String username, String password) throws InterruptedException {
        this.navigateTo();
        Thread.sleep(2000L);
        if (this.driver.getCurrentUrl().startsWith(this.getResourceServerUrl().toString())) {
            Thread.sleep(2000L);
            this.logOut();
            this.navigateTo();
        }
        Thread.sleep(2000L);
        this.loginPage.form().login(username, password);
    }

    private void navigateTo() {
        this.driver.navigate().to(this.getResourceServerUrl());
        WaitUtils.waitUntilElement((By)By.xpath((String)"//a[text() = 'Dynamic Menu']"));
    }

    private boolean wasDenied() {
        return this.driver.getPageSource().contains("You can not access this resource.");
    }

    private URL getResourceServerUrl() {
        try {
            return new URL(this.appServerContextRootPage + "/" + RESOURCE_SERVER_ID);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Could not obtain resource server url.", e);
        }
    }

    private void navigateToDynamicMenuPage() {
        this.navigateTo();
        this.getLink("Dynamic Menu").click();
    }

    private void navigateToUserPremiumPage() {
        this.navigateTo();
        this.getLink("User Premium").click();
    }

    private void navigateToAdminPage() {
        this.navigateTo();
        this.getLink("Administration").click();
    }
}

