/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.federation;

import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.core.Response;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.adapters.HttpClientBuilder;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.federation.kerberos.CommonKerberosConfig;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserFederationProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.adapter.AbstractServletsAdapterTest;
import org.keycloak.testsuite.adapter.federation.KeycloakSPNegoSchemeFactory;
import org.keycloak.testsuite.adapter.page.KerberosPortal;
import org.keycloak.testsuite.adapter.servlet.KerberosCredDelegServlet;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.auth.page.account.ChangePassword;
import org.keycloak.testsuite.util.IOUtil;
import org.keycloak.testsuite.util.LDAPTestConfiguration;
import org.keycloak.util.ldap.KerberosEmbeddedServer;
import org.keycloak.util.ldap.LDAPEmbeddedServer;

public abstract class AbstractKerberosAdapterTest
extends AbstractServletsAdapterTest {
    protected static LDAPTestConfiguration ldapTestConfiguration;
    protected KeycloakSPNegoSchemeFactory spnegoSchemeFactory;
    protected ResteasyClient client;
    protected static LDAPEmbeddedServer ldapEmbeddedServer;
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected ChangePassword changePasswordPage;
    @Page
    protected KerberosPortal kerberosPortal;

    protected abstract String getConnectionPropertiesLocation();

    protected abstract CommonKerberosConfig getKerberosConfig(UserFederationProviderModel var1);

    @Deployment(name="kerberos-portal")
    protected static WebArchive kerberosPortal() {
        return AbstractKerberosAdapterTest.servletDeployment("kerberos-portal", "keycloak.json", KerberosCredDelegServlet.class);
    }

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((String)"/adapter-test/kerberosrealm.json"));
    }

    @Before
    public void before() throws Exception {
        this.testRealmPage.setAuthRealm("test");
        this.changePasswordPage.setAuthRealm(this.testRealmPage);
        ldapTestConfiguration = LDAPTestConfiguration.readConfiguration((String)this.getConnectionPropertiesLocation());
        String krb5ConfPath = LDAPTestConfiguration.getResource((String)"test-krb5.conf");
        this.log.info((Object)("Krb5.conf file location is: " + krb5ConfPath));
        System.setProperty("java.security.krb5.conf", krb5ConfPath);
        if (ldapTestConfiguration.isStartEmbeddedLdapServer() && ldapEmbeddedServer == null) {
            ldapEmbeddedServer = AbstractKerberosAdapterTest.createServer();
            ldapEmbeddedServer.init();
            ldapEmbeddedServer.start();
        }
        UserFederationProviderModel model = new UserFederationProviderModel();
        model.setConfig(ldapTestConfiguration.getLDAPConfig());
        this.spnegoSchemeFactory = new KeycloakSPNegoSchemeFactory(this.getKerberosConfig(model));
        this.initHttpClient(true);
        this.removeAllUsers();
    }

    @After
    public void after() {
        this.client.close();
        this.client = null;
    }

    @AfterClass
    public static void afterClass() {
        try {
            if (ldapEmbeddedServer != null) {
                ldapEmbeddedServer.stop();
                ldapEmbeddedServer = null;
            }
            ldapTestConfiguration = null;
        }
        catch (Exception e) {
            throw new RuntimeException("Error tearDown Embedded LDAP server.", e);
        }
    }

    @Test
    public void spnegoNotAvailableTest() throws Exception {
        this.initHttpClient(false);
        String kcLoginPageLocation = this.client.target(this.kerberosPortal.getInjectedUrl().toString()).request().get().getLocation().toString();
        Response response = this.client.target(kcLoginPageLocation).request().get();
        Assert.assertEquals((long)401L, (long)response.getStatus());
        Assert.assertEquals((Object)"Negotiate", (Object)response.getHeaderString("WWW-Authenticate"));
        String responseText = (String)response.readEntity(String.class);
        responseText.contains("Log in to test");
        response.close();
    }

    protected void spnegoLoginTestImpl() throws Exception {
        Response spnegoResponse = this.spnegoLogin("hnelson", "secret");
        Assert.assertEquals((long)302L, (long)spnegoResponse.getStatus());
        List users = this.testRealmResource().users().search("hnelson", Integer.valueOf(0), Integer.valueOf(1));
        String userId = ((UserRepresentation)users.get(0)).getId();
        this.events.expectLogin().client("kerberos-app").user(userId).detail("redirect_uri", this.kerberosPortal.toString()).detail("username", "hnelson").assertEvent();
        String location = spnegoResponse.getLocation().toString();
        this.driver.navigate().to(location);
        String pageSource = this.driver.getPageSource();
        Assert.assertTrue((pageSource.contains("Kerberos Test") && pageSource.contains("Kerberos servlet secured content") ? 1 : 0) != 0);
        spnegoResponse.close();
        this.events.clear();
    }

    @Test
    public void spnegoCaseInsensitiveTest() throws Exception {
        Response spnegoResponse = this.spnegoLogin(ldapTestConfiguration.isCaseSensitiveLogin() ? "MyDuke" : "myduke", "theduke");
        Assert.assertEquals((long)302L, (long)spnegoResponse.getStatus());
        List users = this.testRealmResource().users().search("myduke", Integer.valueOf(0), Integer.valueOf(1));
        String userId = ((UserRepresentation)users.get(0)).getId();
        this.events.expectLogin().client("kerberos-app").user(userId).detail("redirect_uri", this.kerberosPortal.toString()).detail("username", "myduke").assertEvent();
        String location = spnegoResponse.getLocation().toString();
        this.driver.navigate().to(location);
        String pageSource = this.driver.getPageSource();
        Assert.assertTrue((pageSource.contains("Kerberos Test") && pageSource.contains("Kerberos servlet secured content") ? 1 : 0) != 0);
        spnegoResponse.close();
        this.events.clear();
    }

    @Test
    public void usernamePasswordLoginTest() throws Exception {
        this.updateProviderEditMode(UserFederationProvider.EditMode.READ_ONLY);
        this.changePasswordPage.navigateTo();
        this.testRealmLoginPage.isCurrent();
        this.testRealmLoginPage.form().login("jduke", "theduke");
        this.changePasswordPage.isCurrent();
        this.changePasswordPage.changePasswords("theduke-invalid", "newPass", "newPass");
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Invalid existing password."));
        this.changePasswordPage.changePasswords("theduke", "newPass", "newPass");
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("You can't update your password as your account is read only"));
        this.updateProviderEditMode(UserFederationProvider.EditMode.UNSYNCED);
        this.changePasswordPage.changePasswords("theduke", "newPass", "newPass");
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Your password has been updated."));
        this.changePasswordPage.logOut();
        this.testRealmLoginPage.form().login("jduke", "theduke");
        this.testRealmLoginPage.isCurrent();
        this.testRealmLoginPage.form().login("jduke", "newPass");
        this.changePasswordPage.isCurrent();
        this.changePasswordPage.logOut();
        this.events.clear();
        Response spnegoResponse = this.spnegoLogin("jduke", "theduke");
        Assert.assertEquals((long)302L, (long)spnegoResponse.getStatus());
        UserRepresentation user = ApiUtil.findUserByUsername(this.testRealmResource(), "jduke");
        this.events.expectLogin().client("kerberos-app").user(user != null ? user.getId() : null).detail("redirect_uri", this.kerberosPortal.toString()).detail("username", "jduke").assertEvent();
        spnegoResponse.close();
    }

    protected Response spnegoLogin(String username, String password) {
        this.kerberosPortal.navigateTo();
        Response res = this.client.target(this.kerberosPortal.getInjectedUrl().toString()).request().get();
        String kcLoginPageLocation = res.getLocation().toString();
        if (this.driver.manage().getCookieNamed("OAuth_Token_Request_State") != null) {
            kcLoginPageLocation = res.getLocation().toString().replaceFirst("state=.*&", "state=" + this.driver.manage().getCookieNamed("OAuth_Token_Request_State").getValue() + "&");
        }
        this.spnegoSchemeFactory.setCredentials(username, password);
        Response response = this.client.target(kcLoginPageLocation).request().get();
        if (response.getStatus() == 302) {
            if (response.getLocation() == null) {
                return response;
            }
            String uri = response.getLocation().toString();
            if (uri.contains("login-actions/required-action")) {
                response = this.client.target(uri).request().get();
            }
        }
        return response;
    }

    protected void initHttpClient(boolean useSpnego) {
        if (this.client != null) {
            this.after();
        }
        DefaultHttpClient httpClient = (DefaultHttpClient)new HttpClientBuilder().build();
        httpClient.getAuthSchemes().register("Negotiate", (AuthSchemeFactory)this.spnegoSchemeFactory);
        if (useSpnego) {
            Credentials fake = new Credentials(){

                public String getPassword() {
                    return null;
                }

                public Principal getUserPrincipal() {
                    return null;
                }
            };
            httpClient.getCredentialsProvider().setCredentials(new AuthScope(null, -1, null), fake);
        }
        ApacheHttpClient4Engine engine = new ApacheHttpClient4Engine((HttpClient)httpClient);
        this.client = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)engine).build();
    }

    protected void removeAllUsers() {
        RealmResource realm = this.testRealmResource();
        List users = realm.users().search("", Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
        for (UserRepresentation user : users) {
            if (user.getUsername().equals("test-user@localhost")) continue;
            realm.users().get(user.getId()).remove();
        }
        Assert.assertEquals((long)1L, (long)realm.users().search("", Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE)).size());
    }

    protected void assertUser(String expectedUsername, String expectedEmail, String expectedFirstname, String expectedLastname, boolean updateProfileActionExpected) {
        UserRepresentation user = ApiUtil.findUserByUsername(this.testRealmResource(), expectedUsername);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)expectedEmail, (Object)user.getEmail());
        Assert.assertEquals((Object)expectedFirstname, (Object)user.getFirstName());
        Assert.assertEquals((Object)expectedLastname, (Object)user.getLastName());
        if (updateProfileActionExpected) {
            Assert.assertEquals((Object)UserModel.RequiredAction.UPDATE_PROFILE.toString(), user.getRequiredActions().iterator().next());
        } else {
            Assert.assertTrue((boolean)user.getRequiredActions().isEmpty());
        }
    }

    protected void updateProviderEditMode(UserFederationProvider.EditMode editMode) {
        RealmResource realm = this.testRealmResource();
        RealmRepresentation realmRepresentation = realm.toRepresentation();
        UserFederationProviderRepresentation kerberosProviderRepresentation = (UserFederationProviderRepresentation)realmRepresentation.getUserFederationProviders().get(0);
        kerberosProviderRepresentation.getConfig().put("editMode", editMode.toString());
        realm.update(realmRepresentation);
    }

    @Override
    public RealmResource testRealmResource() {
        return this.adminClient.realm("test");
    }

    public Map<String, String> getConfig() {
        return ldapTestConfiguration.getLDAPConfig();
    }

    protected static LDAPEmbeddedServer createServer() {
        Properties defaultProperties = new Properties();
        defaultProperties.setProperty("ldap.dsf", "mem");
        defaultProperties.setProperty("ldap.ldif", "classpath:kerberos/users-kerberos.ldif");
        return new KerberosEmbeddedServer(defaultProperties);
    }

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testRealmPage.setAuthRealm("test");
    }
}

