/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.federation;

import java.util.Arrays;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.federation.kerberos.CommonKerberosConfig;
import org.keycloak.federation.ldap.kerberos.LDAPProviderKerberosConfig;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserFederationProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.adapter.federation.AbstractKerberosAdapterTest;
import org.keycloak.testsuite.admin.ApiUtil;

public abstract class AbstractKerberosLdapAdapterTest
extends AbstractKerberosAdapterTest {
    private static final String PROVIDER_CONFIG_LOCATION = "kerberos-ldap-connection.properties";

    @Before
    public void init() throws Exception {
        Map<String, String> ldapConfig = this.getConfig();
        UserFederationProviderRepresentation userFederationProviderRepresentation = new UserFederationProviderRepresentation();
        userFederationProviderRepresentation.setProviderName("ldap");
        userFederationProviderRepresentation.setConfig(ldapConfig);
        userFederationProviderRepresentation.setPriority(0);
        userFederationProviderRepresentation.setDisplayName("kerberos-ldap");
        userFederationProviderRepresentation.setFullSyncPeriod(-1);
        userFederationProviderRepresentation.setChangedSyncPeriod(-1);
        userFederationProviderRepresentation.setLastSync(0);
        RealmRepresentation realmRepresentation = this.testRealmResource().toRepresentation();
        realmRepresentation.setUserFederationProviders(Arrays.asList(userFederationProviderRepresentation));
        realmRepresentation.setEventsEnabled(true);
        this.testRealmResource().update(realmRepresentation);
    }

    @Override
    protected CommonKerberosConfig getKerberosConfig(UserFederationProviderModel model) {
        return new LDAPProviderKerberosConfig(model);
    }

    @Test
    public void spnegoLoginTest() throws Exception {
        this.spnegoLoginTestImpl();
        this.assertUser("hnelson", "hnelson@keycloak.org", "Horatio", "Nelson", false);
    }

    @Test
    public void writableEditModeTest() throws Exception {
        this.updateProviderEditMode(UserFederationProvider.EditMode.WRITABLE);
        this.changePasswordPage.navigateTo();
        this.loginPage.isCurrent();
        this.loginPage.form().login("jduke", "theduke");
        this.changePasswordPage.isCurrent();
        this.changePasswordPage.changePasswords("theduke", "newPass", "newPass");
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Your password has been updated."));
        this.changePasswordPage.logOut();
        this.loginPage.form().login("jduke", "theduke");
        this.loginPage.isCurrent();
        this.loginPage.form().login("jduke", "newPass");
        this.changePasswordPage.isCurrent();
        this.changePasswordPage.logOut();
        this.events.clear();
        Response spnegoResponse = this.spnegoLogin("jduke", "newPass");
        Assert.assertEquals((long)302L, (long)spnegoResponse.getStatus());
        UserRepresentation user = ApiUtil.findUserByUsername(this.testRealmResource(), "jduke");
        this.events.expectLogin().client("kerberos-app").user(user != null ? user.getId() : null).detail("redirect_uri", this.kerberosPortal.toString()).detail("username", "jduke").assertEvent();
        this.changePasswordPage.navigateTo();
        this.loginPage.form().login("jduke", "newPass");
        this.changePasswordPage.isCurrent();
        this.changePasswordPage.changePasswords("newPass", "theduke", "theduke");
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Your password has been updated."));
        this.changePasswordPage.logOut();
        spnegoResponse.close();
        this.events.clear();
    }

    @Override
    protected String getConnectionPropertiesLocation() {
        return PROVIDER_CONFIG_LOCATION;
    }
}

