/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.federation;

import java.util.Arrays;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.federation.kerberos.CommonKerberosConfig;
import org.keycloak.federation.kerberos.KerberosConfig;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserFederationProviderRepresentation;
import org.keycloak.testsuite.adapter.federation.AbstractKerberosAdapterTest;

public abstract class AbstractKerberosStandaloneAdapterTest
extends AbstractKerberosAdapterTest {
    protected static final String PROVIDER_CONFIG_LOCATION = "kerberos-standalone-connection.properties";

    @Before
    public void init() throws Exception {
        Map<String, String> ldapConfig = this.getConfig();
        UserFederationProviderRepresentation userFederationProviderRepresentation = new UserFederationProviderRepresentation();
        userFederationProviderRepresentation.setProviderName("kerberos");
        userFederationProviderRepresentation.setConfig(ldapConfig);
        userFederationProviderRepresentation.setPriority(0);
        userFederationProviderRepresentation.setDisplayName("kerberos-standalone");
        userFederationProviderRepresentation.setFullSyncPeriod(-1);
        userFederationProviderRepresentation.setChangedSyncPeriod(-1);
        userFederationProviderRepresentation.setLastSync(0);
        RealmRepresentation realmRepresentation = this.testRealmResource().toRepresentation();
        realmRepresentation.setUserFederationProviders(Arrays.asList(userFederationProviderRepresentation));
        realmRepresentation.setEventsEnabled(true);
        this.testRealmResource().update(realmRepresentation);
    }

    @Override
    protected CommonKerberosConfig getKerberosConfig(UserFederationProviderModel model) {
        return new KerberosConfig(model);
    }

    @Override
    protected String getConnectionPropertiesLocation() {
        return PROVIDER_CONFIG_LOCATION;
    }

    @Test
    public void spnegoLoginTest() throws Exception {
        this.spnegoLoginTestImpl();
        this.assertUser("hnelson", "hnelson@" + this.getConfig().get("kerberosRealm").toLowerCase(), null, null, false);
    }

    @Override
    @Test
    public void usernamePasswordLoginTest() throws Exception {
        super.usernamePasswordLoginTest();
    }

    @Test
    public void updateProfileEnabledTest() throws Exception {
        RealmRepresentation realm = this.testRealmResource().toRepresentation();
        UserFederationProviderRepresentation kerberosProviderRepresentation = (UserFederationProviderRepresentation)realm.getUserFederationProviders().get(0);
        kerberosProviderRepresentation.getConfig().put("updateProfileFirstLogin", "true");
        this.testRealmResource().update(realm);
        Response spnegoResponse = this.spnegoLogin("hnelson", "secret");
        Assert.assertEquals((long)200L, (long)spnegoResponse.getStatus());
        String responseText = (String)spnegoResponse.readEntity(String.class);
        Assert.assertTrue((boolean)responseText.contains("You need to update your user profile to activate your account."));
        Assert.assertTrue((boolean)responseText.contains("hnelson@" + this.getConfig().get("kerberosRealm").toLowerCase()));
        spnegoResponse.close();
        this.assertUser("hnelson", "hnelson@" + this.getConfig().get("kerberosRealm").toLowerCase(), null, null, true);
        kerberosProviderRepresentation = (UserFederationProviderRepresentation)realm.getUserFederationProviders().get(0);
        kerberosProviderRepresentation.getConfig().put("updateProfileFirstLogin", "false");
        this.testRealmResource().update(realm);
    }
}

