/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.keycloak.common.util.Time;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.VersionRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.adapter.AbstractServletsAdapterTest;
import org.keycloak.testsuite.adapter.filter.AdapterActionsFilter;
import org.keycloak.testsuite.adapter.page.CustomerDb;
import org.keycloak.testsuite.adapter.page.CustomerDbErrorPage;
import org.keycloak.testsuite.adapter.page.CustomerPortal;
import org.keycloak.testsuite.adapter.page.CustomerPortalSubsystem;
import org.keycloak.testsuite.adapter.page.InputPortal;
import org.keycloak.testsuite.adapter.page.ProductPortal;
import org.keycloak.testsuite.adapter.page.SecurePortal;
import org.keycloak.testsuite.adapter.page.TokenMinTTLPage;
import org.keycloak.testsuite.adapter.servlet.AbstractShowTokensServlet;
import org.keycloak.testsuite.adapter.servlet.CallAuthenticatedServlet;
import org.keycloak.testsuite.adapter.servlet.CustomerDatabaseServlet;
import org.keycloak.testsuite.adapter.servlet.CustomerServlet;
import org.keycloak.testsuite.adapter.servlet.ErrorServlet;
import org.keycloak.testsuite.adapter.servlet.InputServlet;
import org.keycloak.testsuite.adapter.servlet.ProductServlet;
import org.keycloak.testsuite.adapter.servlet.TokenMinTTLServlet;
import org.keycloak.testsuite.auth.page.login.PageWithLoginUrl;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.URLUtils;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.util.BasicAuthHelper;
import org.openqa.selenium.WebDriver;

public abstract class AbstractDemoServletsAdapterTest
extends AbstractServletsAdapterTest {
    @Page
    private CustomerPortal customerPortal;
    @Page
    private CustomerPortalSubsystem customerPortalSubsystem;
    @Page
    private SecurePortal securePortal;
    @Page
    private CustomerDb customerDb;
    @Page
    private CustomerDbErrorPage customerDbErrorPage;
    @Page
    private ProductPortal productPortal;
    @Page
    private InputPortal inputPortal;
    @Page
    private TokenMinTTLPage tokenMinTTLPage;

    @Deployment(name="customer-portal")
    protected static WebArchive customerPortal() {
        return AbstractDemoServletsAdapterTest.servletDeployment("customer-portal", CustomerServlet.class, ErrorServlet.class);
    }

    @Deployment(name="customer-portal-subsystem")
    protected static WebArchive customerPortalSubsystem() {
        return AbstractDemoServletsAdapterTest.servletDeployment("customer-portal-subsystem", CustomerServlet.class, ErrorServlet.class);
    }

    @Deployment(name="secure-portal")
    protected static WebArchive securePortal() {
        return AbstractDemoServletsAdapterTest.servletDeployment("secure-portal", CallAuthenticatedServlet.class);
    }

    @Deployment(name="customer-db")
    protected static WebArchive customerDb() {
        return AbstractDemoServletsAdapterTest.servletDeployment("customer-db", CustomerDatabaseServlet.class);
    }

    @Deployment(name="customer-db-error-page")
    protected static WebArchive customerDbErrorPage() {
        return AbstractDemoServletsAdapterTest.servletDeployment("customer-db-error-page", CustomerDatabaseServlet.class, ErrorServlet.class);
    }

    @Deployment(name="product-portal")
    protected static WebArchive productPortal() {
        return AbstractDemoServletsAdapterTest.servletDeployment("product-portal", ProductServlet.class);
    }

    @Deployment(name="input-portal")
    protected static WebArchive inputPortal() {
        return AbstractDemoServletsAdapterTest.servletDeployment("input-portal", "keycloak.json", InputServlet.class);
    }

    @Deployment(name="token-min-ttl")
    protected static WebArchive tokenMinTTLPage() {
        return AbstractDemoServletsAdapterTest.servletDeployment("token-min-ttl", AdapterActionsFilter.class, AbstractShowTokensServlet.class, TokenMinTTLServlet.class, ErrorServlet.class);
    }

    @Before
    public void beforeDemoServletsAdapterTest() {
        this.tokenMinTTLPage.navigateTo();
        this.driver.manage().deleteAllCookies();
    }

    @Test
    public void testCustomerPortalWithSubsystemSettings() {
        this.customerPortalSubsystem.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        Assert.assertTrue((this.driver.getPageSource().contains("Bill Burke") && this.driver.getPageSource().contains("Stian Thorgersen") ? 1 : 0) != 0);
    }

    @Test
    public void testSavedPostRequest() throws InterruptedException {
        this.inputPortal.navigateTo();
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.inputPortal);
        this.inputPortal.execute("hello");
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        Assert.assertEquals((Object)this.driver.getCurrentUrl(), (Object)(this.inputPortal + "/secured/post"));
        String pageSource = this.driver.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains("parameter=hello"));
        String logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)this.authServerPage.createUriBuilder()).queryParam("redirect_uri", new Object[]{this.customerPortal.toString()}).build(new Object[]{"demo"}).toString();
        this.driver.navigate().to(logoutUri);
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.productPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.customerPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        Client client = ClientBuilder.newClient();
        Form form = new Form();
        form.param("parameter", "hello");
        String text = (String)client.target(this.inputPortal + "/unsecured").request().post(Entity.form((Form)form), String.class);
        Assert.assertTrue((boolean)text.contains("parameter=hello"));
        client.close();
    }

    @Test
    public void testLoginSSOAndLogout() {
        this.customerPortal.navigateTo();
        this.testRealmLoginPage.form().waitForUsernameInputPresent();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.customerPortal);
        String pageSource = this.driver.getPageSource();
        Assert.assertTrue((pageSource.contains("Bill Burke") && pageSource.contains("Stian Thorgersen") ? 1 : 0) != 0);
        this.productPortal.navigateTo();
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.productPortal);
        pageSource = this.driver.getPageSource();
        Assert.assertTrue((pageSource.contains("iPhone") && pageSource.contains("iPad") ? 1 : 0) != 0);
        List stats = this.testRealmResource().getClientSessionStats();
        Map customerPortalStats = null;
        Map productPortalStats = null;
        for (Map s : stats) {
            switch ((String)s.get("clientId")) {
                case "customer-portal": {
                    customerPortalStats = s;
                    break;
                }
                case "product-portal": {
                    productPortalStats = s;
                }
            }
        }
        Assert.assertEquals((long)1L, (long)Integer.parseInt((String)customerPortalStats.get("active")));
        Assert.assertEquals((long)1L, (long)Integer.parseInt((String)productPortalStats.get("active")));
        String logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)this.authServerPage.createUriBuilder()).queryParam("redirect_uri", new Object[]{this.customerPortal.toString()}).build(new Object[]{"demo"}).toString();
        this.driver.navigate().to(logoutUri);
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.productPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.customerPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
    }

    @Test
    public void testServletRequestLogout() {
        this.customerPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.customerPortal);
        String pageSource = this.driver.getPageSource();
        Assert.assertTrue((pageSource.contains("Bill Burke") && pageSource.contains("Stian Thorgersen") ? 1 : 0) != 0);
        this.productPortal.navigateTo();
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.productPortal);
        pageSource = this.driver.getPageSource();
        Assert.assertTrue((pageSource.contains("iPhone") && pageSource.contains("iPad") ? 1 : 0) != 0);
        this.customerPortal.navigateTo();
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.customerPortal);
        pageSource = this.driver.getPageSource();
        Assert.assertTrue((pageSource.contains("Bill Burke") && pageSource.contains("Stian Thorgersen") ? 1 : 0) != 0);
        this.driver.navigate().to(this.customerPortal + "/logout");
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("servlet logout ok"));
        this.customerPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.productPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
    }

    @Test
    public void testLoginSSOIdle() {
        this.customerPortal.navigateTo();
        this.testRealmLoginPage.form().waitForUsernameInputPresent();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.customerPortal);
        String pageSource = this.driver.getPageSource();
        Assert.assertTrue((pageSource.contains("Bill Burke") && pageSource.contains("Stian Thorgersen") ? 1 : 0) != 0);
        RealmRepresentation demoRealmRep = this.testRealmResource().toRepresentation();
        int originalIdle = demoRealmRep.getSsoSessionIdleTimeout();
        demoRealmRep.setSsoSessionIdleTimeout(Integer.valueOf(1));
        this.testRealmResource().update(demoRealmRep);
        WaitUtils.pause((long)2000L);
        this.productPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        demoRealmRep.setSsoSessionIdleTimeout(Integer.valueOf(originalIdle));
        this.testRealmResource().update(demoRealmRep);
    }

    @Test
    public void testLoginSSOIdleRemoveExpiredUserSessions() {
        this.customerPortal.navigateTo();
        this.log.info((Object)("Current url: " + this.driver.getCurrentUrl()));
        this.testRealmLoginPage.form().waitForUsernameInputPresent();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        this.log.info((Object)("Current url: " + this.driver.getCurrentUrl()));
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.customerPortal);
        String pageSource = this.driver.getPageSource();
        this.log.info((Object)pageSource);
        Assert.assertTrue((pageSource.contains("Bill Burke") && pageSource.contains("Stian Thorgersen") ? 1 : 0) != 0);
        RealmRepresentation demoRealmRep = this.testRealmResource().toRepresentation();
        int originalIdle = demoRealmRep.getSsoSessionIdleTimeout();
        demoRealmRep.setSsoSessionIdleTimeout(Integer.valueOf(1));
        this.testRealmResource().update(demoRealmRep);
        WaitUtils.pause((long)2000L);
        this.productPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        demoRealmRep.setSsoSessionIdleTimeout(Integer.valueOf(originalIdle));
        this.testRealmResource().update(demoRealmRep);
    }

    @Test
    public void testLoginSSOMax() throws InterruptedException {
        this.customerPortal.navigateTo();
        this.testRealmLoginPage.form().waitForUsernameInputPresent();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.customerPortal);
        String pageSource = this.driver.getPageSource();
        Assert.assertTrue((pageSource.contains("Bill Burke") && pageSource.contains("Stian Thorgersen") ? 1 : 0) != 0);
        RealmRepresentation demoRealmRep = this.testRealmResource().toRepresentation();
        int originalIdle = demoRealmRep.getSsoSessionMaxLifespan();
        demoRealmRep.setSsoSessionMaxLifespan(Integer.valueOf(1));
        this.testRealmResource().update(demoRealmRep);
        TimeUnit.SECONDS.sleep(2L);
        this.productPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        demoRealmRep.setSsoSessionIdleTimeout(Integer.valueOf(originalIdle));
        this.testRealmResource().update(demoRealmRep);
    }

    @Test
    public void testNullBearerToken() {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(this.customerDb.toString());
        Response response = target.request().get();
        Assert.assertEquals((long)401L, (long)response.getStatus());
        response.close();
        response = target.request().header("Authorization", (Object)"Bearer null").get();
        Assert.assertEquals((long)401L, (long)response.getStatus());
        response.close();
        client.close();
    }

    @Test
    @Ignore
    public void testNullBearerTokenCustomErrorPage() {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(this.customerDbErrorPage.toString());
        Response response = target.request().get();
        if (response.getStatus() == 302) {
            String location = response.getHeaderString("Location");
            response.close();
            response = client.target(location).request().get();
        }
        Assert.assertEquals((long)200L, (long)response.getStatus());
        String errorPageResponse = (String)response.readEntity(String.class);
        Assert.assertTrue((boolean)errorPageResponse.contains("Error Page"));
        response.close();
        response = target.request().header("Authorization", (Object)"Bearer null").get();
        if (response.getStatus() == 302) {
            String location = response.getHeaderString("Location");
            response.close();
            response = client.target(location).request().get();
        }
        Assert.assertEquals((long)200L, (long)response.getStatus());
        errorPageResponse = (String)response.readEntity(String.class);
        Assert.assertTrue((boolean)errorPageResponse.contains("Error Page"));
        response.close();
        client.close();
    }

    @Test
    @Ignore
    public void testBadUser() {
        Client client = ClientBuilder.newClient();
        URI uri = OIDCLoginProtocolService.tokenUrl((UriBuilder)this.authServerPage.createUriBuilder()).build(new Object[]{"demo"});
        WebTarget target = client.target(uri);
        String header = BasicAuthHelper.createHeader((String)"customer-portal", (String)"password");
        Form form = new Form();
        form.param("grant_type", "password").param("username", "monkey@redhat.com").param("password", "password");
        Response response = target.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
        Assert.assertEquals((long)401L, (long)response.getStatus());
        response.close();
        client.close();
    }

    @Test
    public void testVersion() {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(this.authServerPage.createUriBuilder()).path("version");
        VersionRepresentation version = (VersionRepresentation)target.request().get(VersionRepresentation.class);
        Assert.assertNotNull((Object)version);
        Assert.assertNotNull((Object)version.getVersion());
        Assert.assertNotNull((Object)version.getBuildTime());
        Assert.assertNotEquals((Object)version.getVersion(), (Object)"UNKNOWN");
        Assert.assertNotEquals((Object)version.getBuildTime(), (Object)"UNKNOWN");
        VersionRepresentation version2 = (VersionRepresentation)client.target(this.securePortal.toString()).path("k_version").request().get(VersionRepresentation.class);
        Assert.assertNotNull((Object)version2);
        Assert.assertNotNull((Object)version2.getVersion());
        Assert.assertNotNull((Object)version2.getBuildTime());
        Assert.assertEquals((Object)version.getVersion(), (Object)version2.getVersion());
        Assert.assertEquals((Object)version.getBuildTime(), (Object)version2.getBuildTime());
        client.close();
    }

    @Test
    public void testAuthenticated() {
        this.securePortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.securePortal);
        String pageSource = this.driver.getPageSource();
        Assert.assertTrue((pageSource.contains("Bill Burke") && pageSource.contains("Stian Thorgersen") ? 1 : 0) != 0);
        String logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)this.authServerPage.createUriBuilder()).queryParam("redirect_uri", new Object[]{this.securePortal.toString()}).build(new Object[]{"demo"}).toString();
        this.driver.navigate().to(logoutUri);
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.securePortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
    }

    @Test
    public void testTokenMinTTL() {
        this.tokenMinTTLPage.navigateTo();
        this.testRealmLoginPage.form().waitForUsernameInputPresent();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.tokenMinTTLPage);
        AccessToken token = this.tokenMinTTLPage.getAccessToken();
        int tokenIssued1 = token.getIssuedAt();
        this.setAdapterAndServerTimeOffset(300, this.tokenMinTTLPage.toString());
        token = this.tokenMinTTLPage.getAccessToken();
        int tokenIssued2 = token.getIssuedAt();
        Assert.assertEquals((long)tokenIssued1, (long)tokenIssued2);
        Assert.assertFalse((boolean)token.isExpired());
        this.setAdapterAndServerTimeOffset(540, this.tokenMinTTLPage.toString());
        token = this.tokenMinTTLPage.getAccessToken();
        int tokenIssued3 = token.getIssuedAt();
        Assert.assertTrue((tokenIssued3 > tokenIssued1 ? 1 : 0) != 0);
        this.setAdapterAndServerTimeOffset(0, this.tokenMinTTLPage.toString());
    }

    @Test
    public void testOIDCParamsForwarding() {
        this.securePortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.securePortal);
        String pageSource = this.driver.getPageSource();
        Assert.assertTrue((pageSource.contains("Bill Burke") && pageSource.contains("Stian Thorgersen") ? 1 : 0) != 0);
        int currentTime = Time.currentTime();
        this.setAdapterAndServerTimeOffset(10, this.securePortal.toString());
        String appUri = this.tokenMinTTLPage.getUriBuilder().queryParam("prompt", new Object[]{"login"}).build(new Object[0]).toString();
        URLUtils.navigateToUri((WebDriver)this.driver, (String)appUri, (boolean)true);
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        AccessToken token = this.tokenMinTTLPage.getAccessToken();
        int authTime = token.getAuthTime();
        Assert.assertTrue((currentTime + 10 <= authTime ? 1 : 0) != 0);
        this.setAdapterAndServerTimeOffset(0, this.tokenMinTTLPage.toString());
    }
}

