/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.graphene.wait.StringMatcher;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.events.EventType;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.adapter.AbstractServletsAdapterTest;
import org.keycloak.testsuite.adapter.filter.AdapterActionsFilter;
import org.keycloak.testsuite.adapter.page.OfflineToken;
import org.keycloak.testsuite.adapter.servlet.AbstractShowTokensServlet;
import org.keycloak.testsuite.adapter.servlet.ErrorServlet;
import org.keycloak.testsuite.adapter.servlet.OfflineTokenServlet;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.pages.AccountApplicationsPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.OAuthGrantPage;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.IOUtil;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;

public abstract class AbstractOfflineServletsAdapterTest
extends AbstractServletsAdapterTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected OfflineToken offlineTokenPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected AccountApplicationsPage accountAppPage;
    @Page
    protected OAuthGrantPage oauthGrantPage;

    @Deployment(name="offline-client")
    protected static WebArchive offlineClient() {
        return AbstractOfflineServletsAdapterTest.servletDeployment("offline-client", AdapterActionsFilter.class, AbstractShowTokensServlet.class, OfflineTokenServlet.class, ErrorServlet.class);
    }

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testRealmPage.setAuthRealm("test");
        this.testRealmLoginPage.setAuthRealm("test");
    }

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((String)"/adapter-test/offline-client/offlinerealm.json"));
    }

    @Test
    public void testServlet() throws Exception {
        String servletUri = UriBuilder.fromUri((String)this.offlineTokenPage.toString()).queryParam("scope", new Object[]{"offline_access"}).build(new Object[0]).toString();
        this.driver.navigate().to(servletUri);
        WaitUtils.waitUntilElement((By)By.tagName((String)"body")).is().visible();
        this.loginPage.login("test-user@localhost", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.offlineTokenPage);
        Assert.assertEquals((Object)this.offlineTokenPage.getRefreshToken().getType(), (Object)"Offline");
        Assert.assertEquals((long)this.offlineTokenPage.getRefreshToken().getExpiration(), (long)0L);
        String accessTokenId = this.offlineTokenPage.getAccessToken().getId();
        String refreshTokenId = this.offlineTokenPage.getRefreshToken().getId();
        this.setAdapterAndServerTimeOffset(9999);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.offlineTokenPage);
        Assert.assertNotEquals((Object)this.offlineTokenPage.getRefreshToken().getId(), (Object)refreshTokenId);
        Assert.assertNotEquals((Object)this.offlineTokenPage.getAccessToken().getId(), (Object)accessTokenId);
        this.offlineTokenPage.logout();
        this.loginPage.assertCurrent();
        this.offlineTokenPage.navigateTo();
        this.loginPage.assertCurrent();
        this.setAdapterAndServerTimeOffset(0);
        this.events.clear();
    }

    @Test
    public void testServletWithRevoke() {
        String servletUri = UriBuilder.fromUri((String)this.offlineTokenPage.toString()).queryParam("scope", new Object[]{"offline_access"}).build(new Object[0]).toString();
        this.driver.navigate().to(servletUri);
        WaitUtils.waitUntilElement((By)By.tagName((String)"body")).is().visible();
        this.loginPage.login("test-user@localhost", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.offlineTokenPage);
        Assert.assertEquals((Object)this.offlineTokenPage.getRefreshToken().getType(), (Object)"Offline");
        this.setAdapterAndServerTimeOffset(9999);
        this.offlineTokenPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.offlineTokenPage);
        this.setAdapterAndServerTimeOffset(0);
        this.events.clear();
        this.accountAppPage.open();
        List additionalGrants = ((AccountApplicationsPage.AppEntry)this.accountAppPage.getApplications().get("offline-client")).getAdditionalGrants();
        Assert.assertEquals((long)additionalGrants.size(), (long)1L);
        Assert.assertEquals(additionalGrants.get(0), (Object)"Offline Token");
        this.accountAppPage.revokeGrant("offline-client");
        WaitUtils.pause((long)500L);
        Assert.assertEquals((long)((AccountApplicationsPage.AppEntry)this.accountAppPage.getApplications().get("offline-client")).getAdditionalGrants().size(), (long)0L);
        this.events.expect(EventType.REVOKE_GRANT).client("account").detail("revoked_client", "offline-client").assertEvent();
        this.setAdapterAndServerTimeOffset(9999);
        this.offlineTokenPage.navigateTo();
        URLAssert.assertCurrentUrlDoesntStartWith((AbstractPage)this.offlineTokenPage);
        this.loginPage.assertCurrent();
        this.setAdapterAndServerTimeOffset(0);
    }

    @Test
    public void testServletWithConsent() {
        ClientManager.realm(this.adminClient.realm("test")).clientId("offline-client").consentRequired(true);
        this.offlineTokenPage.navigateTo();
        this.loginPage.login("test-user@localhost", "password");
        this.oauthGrantPage.assertCurrent();
        ((StringMatcher)WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().not()).contains("Offline access");
        this.oauthGrantPage.cancel();
        String servletUri = UriBuilder.fromUri((String)this.offlineTokenPage.toString()).queryParam("scope", new Object[]{"offline_access"}).build(new Object[0]).toString();
        this.driver.navigate().to(servletUri);
        WaitUtils.waitUntilElement((By)By.tagName((String)"body")).is().visible();
        this.loginPage.login("test-user@localhost", "password");
        this.oauthGrantPage.assertCurrent();
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("Offline access");
        this.oauthGrantPage.accept();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.offlineTokenPage);
        Assert.assertEquals((Object)this.offlineTokenPage.getRefreshToken().getType(), (Object)"Offline");
        this.accountAppPage.open();
        AccountApplicationsPage.AppEntry offlineClient = (AccountApplicationsPage.AppEntry)this.accountAppPage.getApplications().get("offline-client");
        Assert.assertTrue((boolean)offlineClient.getRolesGranted().contains("Offline access"));
        Assert.assertTrue((boolean)offlineClient.getAdditionalGrants().contains("Offline Token"));
        this.offlineTokenPage.logout();
        this.loginPage.assertCurrent();
        this.events.clear();
        ClientManager.realm(this.adminClient.realm("test")).clientId("offline-client").consentRequired(false);
    }

    private void setAdapterAndServerTimeOffset(int timeOffset) {
        super.setAdapterAndServerTimeOffset(timeOffset, this.offlineTokenPage.toString());
    }
}

