/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.io.InputStream;
import java.util.List;
import javax.ws.rs.core.Response;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.graphene.wait.StringMatcher;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.adapter.AbstractServletsAdapterTest;
import org.keycloak.testsuite.adapter.page.BadClientSalesPostSigServlet;
import org.keycloak.testsuite.adapter.page.BadRealmSalesPostSigServlet;
import org.keycloak.testsuite.adapter.page.Employee2Servlet;
import org.keycloak.testsuite.adapter.page.EmployeeSigFrontServlet;
import org.keycloak.testsuite.adapter.page.EmployeeSigServlet;
import org.keycloak.testsuite.adapter.page.SAMLServlet;
import org.keycloak.testsuite.adapter.page.SalesMetadataServlet;
import org.keycloak.testsuite.adapter.page.SalesPostEncServlet;
import org.keycloak.testsuite.adapter.page.SalesPostPassiveServlet;
import org.keycloak.testsuite.adapter.page.SalesPostServlet;
import org.keycloak.testsuite.adapter.page.SalesPostSigEmailServlet;
import org.keycloak.testsuite.adapter.page.SalesPostSigPersistentServlet;
import org.keycloak.testsuite.adapter.page.SalesPostSigServlet;
import org.keycloak.testsuite.adapter.page.SalesPostSigTransientServlet;
import org.keycloak.testsuite.adapter.servlet.SendUsernameServlet;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.auth.page.login.Login;
import org.keycloak.testsuite.auth.page.login.SAMLIDPInitiatedLogin;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.IOUtil;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;
import org.w3c.dom.Document;

public abstract class AbstractSAMLServletsAdapterTest
extends AbstractServletsAdapterTest {
    @Page
    protected BadClientSalesPostSigServlet badClientSalesPostSigServletPage;
    @Page
    protected BadRealmSalesPostSigServlet badRealmSalesPostSigServletPage;
    @Page
    protected Employee2Servlet employee2ServletPage;
    @Page
    protected EmployeeSigServlet employeeSigServletPage;
    @Page
    protected EmployeeSigFrontServlet employeeSigFrontServletPage;
    @Page
    protected SalesMetadataServlet salesMetadataServletPage;
    @Page
    protected SalesPostServlet salesPostServletPage;
    @Page
    protected SalesPostEncServlet salesPostEncServletPage;
    @Page
    protected SalesPostPassiveServlet salesPostPassiveServletPage;
    @Page
    protected SalesPostSigServlet salesPostSigServletPage;
    @Page
    protected SalesPostSigEmailServlet salesPostSigEmailServletPage;
    @Page
    protected SalesPostSigPersistentServlet salesPostSigPersistentServletPage;
    @Page
    protected SalesPostSigTransientServlet salesPostSigTransientServletPage;
    @Page
    protected SAMLIDPInitiatedLogin samlidpInitiatedLogin;
    protected boolean forbiddenIfNotAuthenticated = true;

    @Deployment(name="bad-client-sales-post-sig")
    protected static WebArchive badClientSalesPostSig() {
        return AbstractSAMLServletsAdapterTest.samlServletDeployment("bad-client-sales-post-sig", SendUsernameServlet.class);
    }

    @Deployment(name="bad-realm-sales-post-sig")
    protected static WebArchive badRealmSalesPostSig() {
        return AbstractSAMLServletsAdapterTest.samlServletDeployment("bad-realm-sales-post-sig", SendUsernameServlet.class);
    }

    @Deployment(name="employee2")
    protected static WebArchive employee2() {
        return AbstractSAMLServletsAdapterTest.samlServletDeployment("employee2", SendUsernameServlet.class);
    }

    @Deployment(name="employee-sig")
    protected static WebArchive employeeSig() {
        return AbstractSAMLServletsAdapterTest.samlServletDeployment("employee-sig", SendUsernameServlet.class);
    }

    @Deployment(name="employee-sig-front")
    protected static WebArchive employeeSigFront() {
        return AbstractSAMLServletsAdapterTest.samlServletDeployment("employee-sig-front", SendUsernameServlet.class);
    }

    @Deployment(name="sales-metadata")
    protected static WebArchive salesMetadata() {
        return AbstractSAMLServletsAdapterTest.samlServletDeployment("sales-metadata", SendUsernameServlet.class);
    }

    @Deployment(name="sales-post")
    protected static WebArchive salesPost() {
        return AbstractSAMLServletsAdapterTest.samlServletDeployment("sales-post", SendUsernameServlet.class);
    }

    @Deployment(name="sales-post-enc")
    protected static WebArchive salesPostEnc() {
        return AbstractSAMLServletsAdapterTest.samlServletDeployment("sales-post-enc", SendUsernameServlet.class);
    }

    @Deployment(name="sales-post-passive")
    protected static WebArchive salesPostPassive() {
        return AbstractSAMLServletsAdapterTest.samlServletDeployment("sales-post-passive", SendUsernameServlet.class);
    }

    @Deployment(name="sales-post-sig")
    protected static WebArchive salesPostSig() {
        return AbstractSAMLServletsAdapterTest.samlServletDeployment("sales-post-sig", SendUsernameServlet.class);
    }

    @Deployment(name="sales-post-sig-email")
    protected static WebArchive salesPostSigEmail() {
        return AbstractSAMLServletsAdapterTest.samlServletDeployment("sales-post-sig-email", SendUsernameServlet.class);
    }

    @Deployment(name="sales-post-sig-persistent")
    protected static WebArchive salesPostSigPersistent() {
        return AbstractSAMLServletsAdapterTest.samlServletDeployment("sales-post-sig-persistent", SendUsernameServlet.class);
    }

    @Deployment(name="sales-post-sig-transient")
    protected static WebArchive salesPostSigTransient() {
        return AbstractSAMLServletsAdapterTest.samlServletDeployment("sales-post-sig-transient", SendUsernameServlet.class);
    }

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((String)"/adapter-test/keycloak-saml/testsaml.json"));
    }

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testRealmPage.setAuthRealm("demo");
        this.testRealmSAMLRedirectLoginPage.setAuthRealm("demo");
        this.testRealmSAMLPostLoginPage.setAuthRealm("demo");
    }

    private void assertForbidden(AbstractPage page) {
        page.navigateTo();
        ((StringMatcher)WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().not()).contains("principal=");
        Assert.assertTrue((this.driver.getPageSource().contains("Forbidden") || this.driver.getPageSource().contains("Status 403") ? 1 : 0) != 0);
    }

    private void assertSuccessfullyLoggedIn(AbstractPage page) {
        page.navigateTo();
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("principal=bburke");
    }

    private void assertForbiddenLogin(AbstractPage page, String username, String password, Login loginPage) {
        page.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)loginPage);
        loginPage.form().login(username, password);
        ((StringMatcher)WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().not()).contains("principal=");
        Assert.assertTrue((this.driver.getPageSource().contains("Forbidden") || this.driver.getPageSource().contains("Status 403") ? 1 : 0) != 0);
    }

    private void assertSuccessfulLogin(AbstractPage page, UserRepresentation user, Login loginPage) {
        page.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)loginPage);
        loginPage.form().login(user);
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("principal=bburke");
    }

    private void testSuccessfulAndUnauthorizedLogin(SAMLServlet page, Login loginPage) {
        this.assertSuccessfulLogin((AbstractPage)page, this.bburkeUser, loginPage);
        page.logout();
        this.assertForbiddenLogin((AbstractPage)page, "unauthorized", "password", loginPage);
        page.logout();
    }

    @Test
    public void disabledClientTest() {
        ClientResource clientResource = ApiUtil.findClientResourceByClientId(this.testRealmResource(), "http://localhost:8081/sales-post-sig/");
        ClientRepresentation client = clientResource.toRepresentation();
        client.setEnabled(Boolean.valueOf(false));
        clientResource.update(client);
        this.salesPostSigServletPage.navigateTo();
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("Login requester not enabled");
        client.setEnabled(Boolean.valueOf(true));
        clientResource.update(client);
    }

    @Test
    public void unauthorizedSSOTest() {
        this.assertForbiddenLogin((AbstractPage)this.salesPostServletPage, "unauthorized", "password", (Login)this.testRealmSAMLPostLoginPage);
        this.assertForbidden((AbstractPage)this.employee2ServletPage);
        this.assertForbidden((AbstractPage)this.employeeSigFrontServletPage);
        this.assertForbidden((AbstractPage)this.salesPostSigPersistentServletPage);
        this.salesPostServletPage.logout();
    }

    @Test
    public void singleLoginAndLogoutSAMLTest() {
        this.assertSuccessfulLogin((AbstractPage)this.salesPostServletPage, this.bburkeUser, (Login)this.testRealmSAMLPostLoginPage);
        this.assertSuccessfullyLoggedIn((AbstractPage)this.salesPostSigServletPage);
        this.assertSuccessfullyLoggedIn((AbstractPage)this.employee2ServletPage);
        this.assertSuccessfullyLoggedIn((AbstractPage)this.salesPostEncServletPage);
        this.employeeSigFrontServletPage.logout();
        this.employeeSigFrontServletPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmSAMLRedirectLoginPage);
        this.employeeSigServletPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmSAMLRedirectLoginPage);
        this.salesPostPassiveServletPage.navigateTo();
        if (this.forbiddenIfNotAuthenticated) {
            ((StringMatcher)WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().not()).contains("principal=");
            Assert.assertTrue((this.driver.getPageSource().contains("Forbidden") || this.driver.getPageSource().contains("<body></body>") || this.driver.getPageSource().equals("") ? 1 : 0) != 0);
        } else {
            WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("principal=null");
        }
        this.salesPostSigEmailServletPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void badClientSalesPostSigTest() {
        this.badClientSalesPostSigServletPage.navigateTo();
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("Invalid requester");
    }

    @Test
    public void badRealmSalesPostSigTest() {
        this.badRealmSalesPostSigServletPage.navigateTo();
        this.testRealmSAMLRedirectLoginPage.form().login(this.bburkeUser);
        ((StringMatcher)WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().not()).contains("principal=");
        Assert.assertTrue((this.driver.getPageSource().contains("Forbidden") || this.driver.getPageSource().contains("Status 403") ? 1 : 0) != 0);
    }

    @Test
    public void employee2Test() {
        this.testSuccessfulAndUnauthorizedLogin((SAMLServlet)this.employee2ServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void employeeSigTest() {
        this.testSuccessfulAndUnauthorizedLogin((SAMLServlet)this.employeeSigServletPage, (Login)this.testRealmSAMLRedirectLoginPage);
    }

    @Test
    public void employeeSigFrontTest() {
        this.testSuccessfulAndUnauthorizedLogin((SAMLServlet)this.employeeSigFrontServletPage, (Login)this.testRealmSAMLRedirectLoginPage);
    }

    @Test
    public void salesMetadataTest() throws Exception {
        Document doc = IOUtil.loadXML((InputStream)AbstractSAMLServletsAdapterTest.class.getResourceAsStream("/adapter-test/keycloak-saml/sp-metadata.xml"));
        IOUtil.modifyDocElementAttribute((Document)doc, (String)"SingleLogoutService", (String)"Location", (String)"8080", (String)System.getProperty("app.server.http.port", null));
        IOUtil.modifyDocElementAttribute((Document)doc, (String)"AssertionConsumerService", (String)"Location", (String)"8080", (String)System.getProperty("app.server.http.port", null));
        ClientRepresentation clientRep = this.testRealmResource().convertClientDescription(IOUtil.documentToString((Document)doc));
        String appServerUrl = Boolean.parseBoolean(System.getProperty("app.server.ssl.required")) ? "https://localhost:" + System.getProperty("app.server.https.port", "8543") + "/" : "http://localhost:" + System.getProperty("app.server.http.port", "8280") + "/";
        clientRep.setAdminUrl(appServerUrl + "sales-metadata/saml");
        Response response = this.testRealmResource().clients().create(clientRep);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        response.close();
        this.testSuccessfulAndUnauthorizedLogin((SAMLServlet)this.salesMetadataServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void salesPostTest() {
        this.testSuccessfulAndUnauthorizedLogin((SAMLServlet)this.salesPostServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void salesPostEncTest() {
        this.testSuccessfulAndUnauthorizedLogin((SAMLServlet)this.salesPostEncServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void salesPostPassiveTest() {
        this.salesPostPassiveServletPage.navigateTo();
        if (this.forbiddenIfNotAuthenticated) {
            ((StringMatcher)WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().not()).contains("principal=");
            Assert.assertTrue((this.driver.getPageSource().contains("Forbidden") || this.driver.getPageSource().contains("<body></body>") || this.driver.getPageSource().equals("") ? 1 : 0) != 0);
        } else {
            WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("principal=null");
        }
        this.assertSuccessfulLogin((AbstractPage)this.salesPostServletPage, this.bburkeUser, (Login)this.testRealmSAMLPostLoginPage);
        this.assertSuccessfullyLoggedIn((AbstractPage)this.salesPostPassiveServletPage);
        this.salesPostPassiveServletPage.logout();
        this.salesPostPassiveServletPage.navigateTo();
        if (this.forbiddenIfNotAuthenticated) {
            ((StringMatcher)WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().not()).contains("principal=");
            Assert.assertTrue((this.driver.getPageSource().contains("Forbidden") || this.driver.getPageSource().contains("<body></body>") || this.driver.getPageSource().equals("") ? 1 : 0) != 0);
        } else {
            WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("principal=null");
        }
        this.assertForbiddenLogin((AbstractPage)this.salesPostServletPage, "unauthorized", "password", (Login)this.testRealmSAMLPostLoginPage);
        this.assertForbidden((AbstractPage)this.salesPostPassiveServletPage);
        this.salesPostPassiveServletPage.logout();
    }

    @Test
    public void salesPostSigTest() {
        this.testSuccessfulAndUnauthorizedLogin((SAMLServlet)this.salesPostSigServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void salesPostSigEmailTest() {
        this.testSuccessfulAndUnauthorizedLogin((SAMLServlet)this.salesPostSigEmailServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void salesPostSigPersistentTest() {
        this.salesPostSigPersistentServletPage.navigateTo();
        this.testRealmSAMLPostLoginPage.form().login(this.bburkeUser);
        ((StringMatcher)WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().not()).contains("bburke");
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("principal=G-");
        this.salesPostSigPersistentServletPage.logout();
        this.assertForbiddenLogin((AbstractPage)this.salesPostSigPersistentServletPage, "unauthorized", "password", (Login)this.testRealmSAMLPostLoginPage);
        this.salesPostSigPersistentServletPage.logout();
    }

    @Test
    public void salesPostSigTransientTest() {
        this.salesPostSigTransientServletPage.navigateTo();
        this.testRealmSAMLPostLoginPage.form().login(this.bburkeUser);
        ((StringMatcher)WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().not()).contains("bburke");
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("principal=G-");
        this.salesPostSigTransientServletPage.logout();
        this.assertForbiddenLogin((AbstractPage)this.salesPostSigTransientServletPage, "unauthorized", "password", (Login)this.testRealmSAMLPostLoginPage);
        this.salesPostSigTransientServletPage.logout();
    }

    @Test
    public void idpInitiatedLogin() {
        this.samlidpInitiatedLogin.setAuthRealm("demo");
        this.samlidpInitiatedLogin.setUrlName("employee2");
        this.samlidpInitiatedLogin.navigateTo();
        this.samlidpInitiatedLogin.form().login(this.bburkeUser);
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("principal=bburke");
        this.assertSuccessfullyLoggedIn((AbstractPage)this.salesPostSigServletPage);
        this.employee2ServletPage.logout();
    }

    @Test
    public void idpInitiatedUnauthorizedLoginTest() {
        this.samlidpInitiatedLogin.setAuthRealm("demo");
        this.samlidpInitiatedLogin.setUrlName("employee2");
        this.samlidpInitiatedLogin.navigateTo();
        this.samlidpInitiatedLogin.form().login("unauthorized", "password");
        ((StringMatcher)WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().not()).contains("bburke");
        Assert.assertTrue((this.driver.getPageSource().contains("Forbidden") || this.driver.getPageSource().contains("Status 403") ? 1 : 0) != 0);
        this.assertForbidden((AbstractPage)this.employee2ServletPage);
        this.employee2ServletPage.logout();
    }
}

