/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import javax.ws.rs.core.UriBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.adapter.AbstractServletsAdapterTest;
import org.keycloak.testsuite.adapter.page.SessionPortal;
import org.keycloak.testsuite.adapter.servlet.SessionServlet;
import org.keycloak.testsuite.auth.page.account.Sessions;
import org.keycloak.testsuite.auth.page.login.Login;
import org.keycloak.testsuite.auth.page.login.PageWithLoginUrl;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.SecondBrowser;
import org.keycloak.testsuite.util.URLAssert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public abstract class AbstractSessionServletAdapterTest
extends AbstractServletsAdapterTest {
    @Page
    private SessionPortal sessionPortalPage;
    @Page
    private Sessions testRealmSessions;
    @Drone
    @SecondBrowser
    protected WebDriver driver2;

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testRealmSessions.setAuthRealm("demo");
    }

    @Deployment(name="session-portal")
    protected static WebArchive sessionPortal() {
        return AbstractSessionServletAdapterTest.servletDeployment("session-portal", "keycloak.json", SessionServlet.class);
    }

    @After
    public void afterSessionServletAdapterTest() {
        this.sessionPortalPage.navigateTo();
        this.driver.manage().deleteAllCookies();
    }

    @Test
    public void testSingleSessionInvalidated() {
        this.loginAndCheckSession(this.driver, (Login)this.testRealmLoginPage);
        this.driver2.navigate().to(this.sessionPortalPage.toString());
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf(this.driver2, (PageWithLoginUrl)this.testRealmPage);
        this.driver2.findElement(By.id((String)"username")).sendKeys(new CharSequence[]{"bburke@redhat.com"});
        this.driver2.findElement(By.id((String)"password")).sendKeys(new CharSequence[]{"password"});
        this.driver2.findElement(By.id((String)"password")).submit();
        URLAssert.assertCurrentUrlEquals(this.driver2, (AbstractPage)this.sessionPortalPage);
        String pageSource = this.driver2.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains("Counter=1"));
        this.driver2.navigate().to(this.sessionPortalPage.toString());
        pageSource = this.driver2.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains("Counter=2"));
        String logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)this.authServerPage.createUriBuilder()).queryParam("redirect_uri", new Object[]{this.sessionPortalPage.toString()}).build(new Object[]{"demo"}).toString();
        this.driver.navigate().to(logoutUri);
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.sessionPortalPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.driver2.navigate().to(this.sessionPortalPage.toString());
        URLAssert.assertCurrentUrlEquals(this.driver2, (AbstractPage)this.sessionPortalPage);
        pageSource = this.driver2.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains("Counter=3"));
        this.driver2.navigate().to(logoutUri);
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf(this.driver2, (PageWithLoginUrl)this.testRealmPage);
    }

    @Test
    public void testSessionInvalidatedAfterFailedRefresh() {
        RealmRepresentation testRealmRep = this.testRealmResource().toRepresentation();
        ClientResource sessionPortalRes = null;
        for (ClientRepresentation clientRep : this.testRealmResource().clients().findAll()) {
            if (!"session-portal".equals(clientRep.getClientId())) continue;
            sessionPortalRes = this.testRealmResource().clients().get(clientRep.getId());
        }
        Assert.assertNotNull(sessionPortalRes);
        sessionPortalRes.toRepresentation().setAdminUrl("");
        int origTokenLifespan = testRealmRep.getAccessCodeLifespan();
        testRealmRep.setAccessCodeLifespan(Integer.valueOf(1));
        this.testRealmResource().update(testRealmRep);
        this.loginAndCheckSession(this.driver, (Login)this.testRealmLoginPage);
        String logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)this.authServerPage.createUriBuilder()).queryParam("redirect_uri", new Object[]{this.sessionPortalPage.toString()}).build(new Object[]{"demo"}).toString();
        this.driver.navigate().to(logoutUri);
        this.sessionPortalPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        Assert.assertEquals((Object)this.driver.getCurrentUrl(), (Object)this.sessionPortalPage.toString());
        String pageSource = this.driver.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains("Counter=1"));
        sessionPortalRes.toRepresentation().setAdminUrl(this.sessionPortalPage.toString());
        testRealmRep.setAccessCodeLifespan(Integer.valueOf(origTokenLifespan));
        this.testRealmResource().update(testRealmRep);
    }

    @Test
    public void testAdminApplicationLogout() {
        this.loginAndCheckSession(this.driver, (Login)this.testRealmLoginPage);
        UserRepresentation mposolda = (UserRepresentation)this.testRealmResource().users().search("mposolda", null, null, null, null, null).get(0);
        this.testRealmResource().users().get(mposolda.getId()).logout();
        this.sessionPortalPage.navigateTo();
        Assert.assertEquals((Object)this.driver.getCurrentUrl(), (Object)this.sessionPortalPage.toString());
        String pageSource = this.driver.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains("Counter=3"));
        String logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)this.authServerPage.createUriBuilder()).queryParam("redirect_uri", new Object[]{this.sessionPortalPage.toString()}).build(new Object[]{"demo"}).toString();
        this.driver.navigate().to(logoutUri);
    }

    @Test
    public void testAccountManagementSessionsLogout() {
        this.loginAndCheckSession(this.driver, (Login)this.testRealmLoginPage);
        this.testRealmSessions.navigateTo();
        this.testRealmSessions.logoutAll();
        this.loginAndCheckSession(this.driver, (Login)this.testRealmLoginPage);
    }

    private void loginAndCheckSession(WebDriver driver, Login login) {
        this.sessionPortalPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        login.form().login("bburke@redhat.com", "password");
        Assert.assertEquals((Object)driver.getCurrentUrl(), (Object)this.sessionPortalPage.toString());
        String pageSource = driver.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains("Counter=1"));
        this.sessionPortalPage.navigateTo();
        pageSource = driver.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains("Counter=2"));
    }
}

