/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.TestRealmKeycloakTest;
import org.keycloak.testsuite.util.AssertAdminEvents;
import org.keycloak.util.JsonSerialization;

public abstract class AbstractAdminTest
extends TestRealmKeycloakTest {
    protected static final String REALM_NAME = "admin-client-test";
    protected RealmResource realm;
    protected String realmId;
    @Rule
    public AssertAdminEvents assertAdminEvents = new AssertAdminEvents(this);

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        this.findTestApp(testRealm).setDirectAccessGrantsEnabled(Boolean.valueOf(true));
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        super.addTestRealms(testRealms);
        RealmRepresentation adminRealmRep = new RealmRepresentation();
        adminRealmRep.setRealm(REALM_NAME);
        adminRealmRep.setEnabled(Boolean.valueOf(true));
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("from", "auto@keycloak.org");
        config.put("host", "localhost");
        config.put("port", "3025");
        adminRealmRep.setSmtpServer(config);
        ArrayList<String> eventListeners = new ArrayList<String>();
        eventListeners.add("jboss-logging");
        eventListeners.add("event-queue");
        adminRealmRep.setEventsListeners(eventListeners);
        testRealms.add(adminRealmRep);
    }

    @Before
    public void setRealm() {
        this.realm = this.adminClient.realm(REALM_NAME);
        this.realmId = this.realm.toRepresentation().getId();
    }

    @After
    public void after() {
        for (RealmRepresentation r : this.adminClient.realms().findAll()) {
            if (!r.getRealm().equals(REALM_NAME)) continue;
            this.removeRealm(r);
        }
    }

    public static <T> T loadJson(InputStream is, Class<T> type) {
        try {
            return (T)JsonSerialization.readValue((InputStream)is, type);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse json", e);
        }
    }
}

