/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

public class ApiUtil {
    private static final Logger log = Logger.getLogger(ApiUtil.class);

    public static String getCreatedId(Response response) {
        URI location = response.getLocation();
        if (!response.getStatusInfo().equals(Response.Status.CREATED)) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new RuntimeException("Create method returned status " + statusInfo.getReasonPhrase() + " (Code: " + statusInfo.getStatusCode() + "); expected status: Created (201)");
        }
        if (location == null) {
            return null;
        }
        String path = location.getPath();
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static ClientResource findClientResourceById(RealmResource realm, String id) {
        for (ClientRepresentation c : realm.clients().findAll()) {
            if (!c.getId().equals(id)) continue;
            return realm.clients().get(c.getId());
        }
        return null;
    }

    public static ClientResource findClientResourceByClientId(RealmResource realm, String clientId) {
        for (ClientRepresentation c : realm.clients().findAll()) {
            if (!c.getClientId().equals(clientId)) continue;
            return realm.clients().get(c.getId());
        }
        return null;
    }

    public static ClientResource findClientResourceByName(RealmResource realm, String name) {
        for (ClientRepresentation c : realm.clients().findAll()) {
            if (!c.getName().equals(name)) continue;
            return realm.clients().get(c.getId());
        }
        return null;
    }

    public static ClientResource findClientByClientId(RealmResource realm, String clientId) {
        for (ClientRepresentation c : realm.clients().findAll()) {
            if (!c.getClientId().equals(clientId)) continue;
            return realm.clients().get(c.getId());
        }
        return null;
    }

    public static RoleResource findClientRoleByName(ClientResource client, String role) {
        return client.roles().get(role);
    }

    public static ProtocolMapperRepresentation findProtocolMapperByName(ClientResource client, String name) {
        for (ProtocolMapperRepresentation p : client.getProtocolMappers().getMappers()) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public static RoleResource findRealmRoleByName(RealmResource realm, String role) {
        return realm.roles().get(role);
    }

    public static UserRepresentation findUserByUsername(RealmResource realm, String username) {
        UserRepresentation user = null;
        List ur = realm.users().search(username, null, null);
        if (ur.size() == 1) {
            user = (UserRepresentation)ur.get(0);
        }
        if (ur.size() > 1) {
            for (UserRepresentation rep : ur) {
                if (!rep.getUsername().equalsIgnoreCase(username)) continue;
                return rep;
            }
        }
        return user;
    }

    public static UserResource findUserByUsernameId(RealmResource realm, String username) {
        return realm.users().get(ApiUtil.findUserByUsername(realm, username).getId());
    }

    public static String createUserWithAdminClient(RealmResource realm, UserRepresentation user) {
        Response response = realm.users().create(user);
        String createdId = ApiUtil.getCreatedId(response);
        response.close();
        return createdId;
    }

    public static String createUserAndResetPasswordWithAdminClient(RealmResource realm, UserRepresentation user, String password) {
        String id = ApiUtil.createUserWithAdminClient(realm, user);
        ApiUtil.resetUserPassword(realm.users().get(id), password, false);
        return id;
    }

    public static void resetUserPassword(UserResource userResource, String newPassword, boolean temporary) {
        CredentialRepresentation newCredential = new CredentialRepresentation();
        newCredential.setType("password");
        newCredential.setValue(newPassword);
        newCredential.setTemporary(Boolean.valueOf(temporary));
        userResource.resetPassword(newCredential);
    }

    public static void assignClientRoles(RealmResource realm, String userId, String clientName, String ... roles) {
        String realmName = realm.toRepresentation().getRealm();
        String clientId = "";
        for (ClientRepresentation clientRepresentation : realm.clients().findAll()) {
            if (!clientRepresentation.getClientId().equals(clientName)) continue;
            clientId = clientRepresentation.getId();
        }
        if (!clientId.isEmpty()) {
            ClientResource clientResource = realm.clients().get(clientId);
            ArrayList<RoleRepresentation> roleRepresentations = new ArrayList<RoleRepresentation>();
            for (String roleName : roles) {
                RoleRepresentation role = clientResource.roles().get(roleName).toRepresentation();
                roleRepresentations.add(role);
            }
            UserResource userResource = realm.users().get(userId);
            log.debug((Object)("assigning role: " + Arrays.toString(roles) + " to user: \"" + userResource.toRepresentation().getUsername() + "\" of client: \"" + clientName + "\" in realm: \"" + realmName + "\""));
            userResource.roles().clientLevel(clientId).add(roleRepresentations);
        } else {
            log.warn((Object)("client with name " + clientName + " doesn't exist in realm " + realmName));
        }
    }

    public static boolean groupContainsSubgroup(GroupRepresentation group, GroupRepresentation subgroup) {
        boolean contains = false;
        for (GroupRepresentation sg : group.getSubGroups()) {
            if (!subgroup.getId().equals(sg.getId())) continue;
            contains = true;
            break;
        }
        return contains;
    }
}

