/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.admin.client.resource.RoleMappingResource;
import org.keycloak.common.util.Time;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.adapters.action.GlobalRequestResult;
import org.keycloak.representations.adapters.action.PushNotBeforeAction;
import org.keycloak.representations.adapters.action.TestAvailabilityAction;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.CredentialBuilder;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.UserBuilder;

public class ClientTest
extends AbstractAdminTest {
    @Test
    public void getClients() {
        Assert.assertNames(this.realm.clients().findAll(), "account", "realm-management", "security-admin-console", "broker", "admin-cli");
    }

    private ClientRepresentation createClient() {
        ClientRepresentation rep = new ClientRepresentation();
        rep.setClientId("my-app");
        rep.setDescription("my-app description");
        rep.setEnabled(Boolean.valueOf(true));
        Response response = this.realm.clients().create(rep);
        response.close();
        String id = ApiUtil.getCreatedId(response);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientResourcePath(id), (Object)rep, ResourceType.CLIENT);
        rep.setId(id);
        return rep;
    }

    @Test
    public void createClientVerify() {
        String id = this.createClient().getId();
        org.junit.Assert.assertNotNull((Object)this.realm.clients().get(id));
        Assert.assertNames(this.realm.clients().findAll(), "account", "realm-management", "security-admin-console", "broker", "my-app", "admin-cli");
    }

    @Test
    public void removeClient() {
        String id = this.createClient().getId();
        this.realm.clients().get(id).remove();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.clientResourcePath(id), ResourceType.CLIENT);
    }

    @Test
    public void getClientRepresentation() {
        String id = this.createClient().getId();
        ClientRepresentation rep = this.realm.clients().get(id).toRepresentation();
        org.junit.Assert.assertEquals((Object)id, (Object)rep.getId());
        org.junit.Assert.assertEquals((Object)"my-app", (Object)rep.getClientId());
        org.junit.Assert.assertTrue((boolean)rep.isEnabled());
    }

    @Test
    public void getClientDescription() {
        String id = this.createClient().getId();
        ClientRepresentation rep = this.realm.clients().get(id).toRepresentation();
        org.junit.Assert.assertEquals((Object)id, (Object)rep.getId());
        org.junit.Assert.assertEquals((Object)"my-app description", (Object)rep.getDescription());
    }

    @Test
    public void getClientSessions() throws Exception {
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "password");
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        OAuthClient.AuthorizationEndpointResponse codeResponse = this.oauth.doLogin("test-user@localhost", "password");
        OAuthClient.AccessTokenResponse response2 = this.oauth.doAccessTokenRequest(codeResponse.getCode(), "password");
        org.junit.Assert.assertEquals((long)200L, (long)response2.getStatusCode());
        ClientResource app = ApiUtil.findClientByClientId(this.adminClient.realm("test"), "test-app");
        org.junit.Assert.assertEquals((long)2L, (long)((Integer)app.getApplicationSessionCount().get("count")).intValue());
        List userSessions = app.getUserSessions(Integer.valueOf(0), Integer.valueOf(100));
        org.junit.Assert.assertEquals((long)2L, (long)userSessions.size());
        org.junit.Assert.assertEquals((long)1L, (long)((UserSessionRepresentation)userSessions.get(0)).getClients().size());
    }

    @Test
    public void deleteDefaultRole() {
        ClientRepresentation rep = this.createClient();
        String id = rep.getId();
        RoleRepresentation role = new RoleRepresentation("test", "test", false);
        this.realm.clients().get(id).roles().create(role);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(id, "test"), (Object)role, ResourceType.CLIENT_ROLE);
        ClientRepresentation foundClientRep = this.realm.clients().get(id).toRepresentation();
        foundClientRep.setDefaultRoles(new String[]{"test"});
        this.realm.clients().get(id).update(foundClientRep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.clientResourcePath(id), (Object)rep, ResourceType.CLIENT);
        org.junit.Assert.assertArrayEquals((Object[])new String[]{"test"}, (Object[])this.realm.clients().get(id).toRepresentation().getDefaultRoles());
        this.realm.clients().get(id).roles().deleteRole("test");
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.clientRoleResourcePath(id, "test"), ResourceType.CLIENT_ROLE);
        org.junit.Assert.assertNull((Object)this.realm.clients().get(id).toRepresentation().getDefaultRoles());
    }

    @Test
    public void testProtocolMappers() {
        String clientDbId = this.createClient().getId();
        ProtocolMappersResource mappersResource = ApiUtil.findClientByClientId(this.realm, "my-app").getProtocolMappers();
        this.protocolMappersTest(clientDbId, mappersResource);
    }

    @Test
    public void updateClient() {
        ClientRepresentation client = this.createClient();
        ClientRepresentation newClient = new ClientRepresentation();
        newClient.setId(client.getId());
        newClient.setClientId(client.getClientId());
        newClient.setBaseUrl("http://baseurl");
        this.realm.clients().get(client.getId()).update(newClient);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.clientResourcePath(client.getId()), (Object)newClient, ResourceType.CLIENT);
        ClientRepresentation storedClient = this.realm.clients().get(client.getId()).toRepresentation();
        ClientTest.assertClient(client, storedClient);
        newClient.setSecret("new-secret");
        this.realm.clients().get(client.getId()).update(newClient);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.clientResourcePath(client.getId()), (Object)newClient, ResourceType.CLIENT);
        storedClient = this.realm.clients().get(client.getId()).toRepresentation();
        ClientTest.assertClient(client, storedClient);
    }

    @Test
    public void serviceAccount() {
        Response response = this.realm.clients().create(ClientBuilder.create().clientId("serviceClient").serviceAccount().build());
        String id = ApiUtil.getCreatedId(response);
        UserRepresentation userRep = this.realm.clients().get(id).getServiceAccountUser();
        org.junit.Assert.assertEquals((Object)"service-account-serviceclient", (Object)userRep.getUsername());
    }

    @Test
    public void pushRevocation() {
        this.testingClient.testApp().clearAdminActions();
        ClientRepresentation client = this.createAppClient();
        String id = client.getId();
        this.realm.clients().get(id).pushRevocation();
        PushNotBeforeAction pushNotBefore = this.testingClient.testApp().getAdminPushNotBefore();
        org.junit.Assert.assertEquals((long)client.getNotBefore().intValue(), (long)pushNotBefore.getNotBefore());
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.clientPushRevocationPath(id), ResourceType.CLIENT);
    }

    private ClientRepresentation createAppClient() {
        String redirectUri = this.oauth.getRedirectUri().replace("/master/", "/admin-client-test/");
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId("test-app");
        client.setAdminUrl(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth/realms/master/app/admin");
        client.setRedirectUris(Collections.singletonList(redirectUri));
        client.setSecret("secret");
        int notBefore = Time.currentTime() - 60;
        client.setNotBefore(Integer.valueOf(notBefore));
        Response response = this.realm.clients().create(client);
        String id = ApiUtil.getCreatedId(response);
        response.close();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientResourcePath(id), (Object)client, ResourceType.CLIENT);
        client.setId(id);
        return client;
    }

    @Test
    public void nodes() {
        this.testingClient.testApp().clearAdminActions();
        ClientRepresentation client = this.createAppClient();
        String id = client.getId();
        String myhost = this.suiteContext.getAuthServerInfo().getContextRoot().getHost();
        this.realm.clients().get(id).registerNode(Collections.singletonMap("node", myhost));
        this.realm.clients().get(id).registerNode(Collections.singletonMap("node", "invalid"));
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientNodePath(id, myhost), ResourceType.CLUSTER_NODE);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientNodePath(id, "invalid"), ResourceType.CLUSTER_NODE);
        GlobalRequestResult result = this.realm.clients().get(id).testNodesAvailable();
        org.junit.Assert.assertEquals((long)1L, (long)result.getSuccessRequests().size());
        org.junit.Assert.assertEquals((long)1L, (long)result.getFailedRequests().size());
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.clientTestNodesAvailablePath(id), (Object)result, ResourceType.CLUSTER_NODE);
        TestAvailabilityAction testAvailable = this.testingClient.testApp().getTestAvailable();
        org.junit.Assert.assertEquals((Object)"test-app", (Object)testAvailable.getResource());
        org.junit.Assert.assertEquals((long)2L, (long)this.realm.clients().get(id).toRepresentation().getRegisteredNodes().size());
        this.realm.clients().get(id).unregisterNode("invalid");
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.clientNodePath(id, "invalid"), ResourceType.CLUSTER_NODE);
        org.junit.Assert.assertEquals((long)1L, (long)this.realm.clients().get(id).toRepresentation().getRegisteredNodes().size());
    }

    @Test
    public void offlineUserSessions() throws IOException {
        ClientRepresentation client = this.createAppClient();
        String id = client.getId();
        Response response = this.realm.users().create(UserBuilder.create().username("testuser").build());
        String userId = ApiUtil.getCreatedId(response);
        response.close();
        this.realm.users().get(userId).resetPassword(CredentialBuilder.create().password("password").build());
        Map offlineSessionCount = this.realm.clients().get(id).getOfflineSessionCount();
        org.junit.Assert.assertEquals((Object)new Long(0L), offlineSessionCount.get("count"));
        List userSessions = this.realm.users().get(userId).getOfflineSessions(id);
        org.junit.Assert.assertEquals((String)"There should be no offline sessions", (long)0L, (long)userSessions.size());
        this.oauth.realm("admin-client-test");
        this.oauth.redirectUri((String)client.getRedirectUris().get(0));
        this.oauth.scope("offline_access");
        this.oauth.doLogin("testuser", "password");
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest((String)this.oauth.getCurrentQuery().get("code"), "secret");
        org.junit.Assert.assertEquals((long)200L, (long)accessTokenResponse.getStatusCode());
        offlineSessionCount = this.realm.clients().get(id).getOfflineSessionCount();
        org.junit.Assert.assertEquals((Object)new Long(1L), offlineSessionCount.get("count"));
        List offlineUserSessions = this.realm.clients().get(id).getOfflineUserSessions(Integer.valueOf(0), Integer.valueOf(100));
        org.junit.Assert.assertEquals((long)1L, (long)offlineUserSessions.size());
        org.junit.Assert.assertEquals((Object)"testuser", (Object)((UserSessionRepresentation)offlineUserSessions.get(0)).getUsername());
        userSessions = this.realm.users().get(userId).getOfflineSessions(id);
        org.junit.Assert.assertEquals((String)"There should be one offline session", (long)1L, (long)userSessions.size());
        this.assertOfflineSession((UserSessionRepresentation)offlineUserSessions.get(0), (UserSessionRepresentation)userSessions.get(0));
    }

    private void assertOfflineSession(UserSessionRepresentation expected, UserSessionRepresentation actual) {
        org.junit.Assert.assertEquals((String)"id", (Object)expected.getId(), (Object)actual.getId());
        org.junit.Assert.assertEquals((String)"userId", (Object)expected.getUserId(), (Object)actual.getUserId());
        org.junit.Assert.assertEquals((String)"userName", (Object)expected.getUsername(), (Object)actual.getUsername());
        org.junit.Assert.assertEquals((String)"clients", (Object)expected.getClients(), (Object)actual.getClients());
    }

    @Test
    public void scopes() {
        Response response = this.realm.clients().create(ClientBuilder.create().clientId("client").fullScopeEnabled(false).build());
        String id = ApiUtil.getCreatedId(response);
        response.close();
        this.assertAdminEvents.poll();
        RoleMappingResource scopesResource = this.realm.clients().get(id).getScopeMappings();
        RoleRepresentation roleRep1 = RoleBuilder.create().name("role1").build();
        RoleRepresentation roleRep2 = RoleBuilder.create().name("role2").build();
        this.realm.roles().create(roleRep1);
        this.realm.roles().create(roleRep2);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourcePath("role1"), (Object)roleRep1, ResourceType.REALM_ROLE);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourcePath("role2"), (Object)roleRep2, ResourceType.REALM_ROLE);
        roleRep1 = this.realm.roles().get("role1").toRepresentation();
        roleRep2 = this.realm.roles().get("role2").toRepresentation();
        this.realm.roles().get("role1").addComposites(Collections.singletonList(roleRep2));
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourceCompositesPath("role1"), Collections.singletonList(roleRep2), ResourceType.REALM_ROLE);
        String accountMgmtId = ((ClientRepresentation)this.realm.clients().findByClientId("account").get(0)).getId();
        RoleRepresentation viewAccountRoleRep = this.realm.clients().get(accountMgmtId).roles().get("view-profile").toRepresentation();
        scopesResource.realmLevel().add(Collections.singletonList(roleRep1));
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientScopeMappingsRealmLevelPath(id), Collections.singletonList(roleRep1), ResourceType.REALM_SCOPE_MAPPING);
        scopesResource.clientLevel(accountMgmtId).add(Collections.singletonList(viewAccountRoleRep));
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientScopeMappingsClientLevelPath(id, accountMgmtId), Collections.singletonList(viewAccountRoleRep), ResourceType.CLIENT_SCOPE_MAPPING);
        Assert.assertNames(scopesResource.realmLevel().listAll(), "role1");
        Assert.assertNames(scopesResource.realmLevel().listEffective(), "role1", "role2");
        Assert.assertNames(scopesResource.realmLevel().listAvailable(), "offline_access", "uma_authorization");
        Assert.assertNames(scopesResource.clientLevel(accountMgmtId).listAll(), "view-profile");
        Assert.assertNames(scopesResource.clientLevel(accountMgmtId).listEffective(), "view-profile");
        Assert.assertNames(scopesResource.clientLevel(accountMgmtId).listAvailable(), "manage-account");
        Assert.assertNames(scopesResource.getAll().getRealmMappings(), "role1");
        Assert.assertNames(((ClientMappingsRepresentation)scopesResource.getAll().getClientMappings().get("account")).getMappings(), "view-profile");
        scopesResource.realmLevel().remove(Collections.singletonList(roleRep1));
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.clientScopeMappingsRealmLevelPath(id), Collections.singletonList(roleRep1), ResourceType.REALM_SCOPE_MAPPING);
        scopesResource.clientLevel(accountMgmtId).remove(Collections.singletonList(viewAccountRoleRep));
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.clientScopeMappingsClientLevelPath(id, accountMgmtId), Collections.singletonList(viewAccountRoleRep), ResourceType.CLIENT_SCOPE_MAPPING);
        Assert.assertNames(scopesResource.realmLevel().listAll(), new String[0]);
        Assert.assertNames(scopesResource.realmLevel().listEffective(), new String[0]);
        Assert.assertNames(scopesResource.realmLevel().listAvailable(), "offline_access", "uma_authorization", "role1", "role2");
        Assert.assertNames(scopesResource.clientLevel(accountMgmtId).listAll(), new String[0]);
        Assert.assertNames(scopesResource.clientLevel(accountMgmtId).listAvailable(), "view-profile", "manage-account");
        Assert.assertNames(scopesResource.clientLevel(accountMgmtId).listEffective(), new String[0]);
    }

    public void protocolMappersTest(String clientDbId, ProtocolMappersResource mappersResource) {
        List protocolMappers = mappersResource.getMappers();
        String emailMapperId = null;
        String usernameMapperId = null;
        String fooMapperId = null;
        for (ProtocolMapperRepresentation mapper : protocolMappers) {
            if (mapper.getName().equals("email")) {
                emailMapperId = mapper.getId();
                continue;
            }
            if (mapper.getName().equals("username")) {
                usernameMapperId = mapper.getId();
                continue;
            }
            if (!mapper.getName().equals("foo")) continue;
            fooMapperId = mapper.getId();
        }
        org.junit.Assert.assertNotNull(emailMapperId);
        org.junit.Assert.assertNotNull(usernameMapperId);
        org.junit.Assert.assertNull(fooMapperId);
        ProtocolMapperRepresentation fooMapper = new ProtocolMapperRepresentation();
        fooMapper.setName("foo");
        fooMapper.setProtocol("fooProtocol");
        fooMapper.setProtocolMapper("fooMapper");
        fooMapper.setConsentRequired(true);
        Response response = mappersResource.createMapper(fooMapper);
        String location = response.getLocation().toString();
        fooMapperId = location.substring(location.lastIndexOf("/") + 1);
        response.close();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientProtocolMapperPath(clientDbId, fooMapperId), (Object)fooMapper, ResourceType.PROTOCOL_MAPPER);
        fooMapper = mappersResource.getMapperById(fooMapperId);
        org.junit.Assert.assertEquals((Object)fooMapper.getName(), (Object)"foo");
        fooMapper.setProtocolMapper("foo-mapper-updated");
        mappersResource.update(fooMapperId, fooMapper);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.clientProtocolMapperPath(clientDbId, fooMapperId), (Object)fooMapper, ResourceType.PROTOCOL_MAPPER);
        fooMapper = mappersResource.getMapperById(fooMapperId);
        org.junit.Assert.assertEquals((Object)fooMapper.getProtocolMapper(), (Object)"foo-mapper-updated");
        mappersResource.delete(fooMapperId);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.clientProtocolMapperPath(clientDbId, fooMapperId), ResourceType.PROTOCOL_MAPPER);
        try {
            mappersResource.getMapperById(fooMapperId);
            org.junit.Assert.fail((String)"Not expected to find deleted mapper");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public static void assertClient(ClientRepresentation client, ClientRepresentation storedClient) {
        List webOrigins;
        List redirectUris;
        if (client.getClientId() != null) {
            Assert.assertEquals((Object)client.getClientId(), (Object)storedClient.getClientId());
        }
        if (client.getName() != null) {
            Assert.assertEquals((Object)client.getName(), (Object)storedClient.getName());
        }
        if (client.isEnabled() != null) {
            Assert.assertEquals((Object)client.isEnabled(), (Object)storedClient.isEnabled());
        }
        if (client.isBearerOnly() != null) {
            Assert.assertEquals((Object)client.isBearerOnly(), (Object)storedClient.isBearerOnly());
        }
        if (client.isPublicClient() != null) {
            Assert.assertEquals((Object)client.isPublicClient(), (Object)storedClient.isPublicClient());
        }
        if (client.isFullScopeAllowed() != null) {
            Assert.assertEquals((Object)client.isFullScopeAllowed(), (Object)storedClient.isFullScopeAllowed());
        }
        if (client.getRootUrl() != null) {
            Assert.assertEquals((Object)client.getRootUrl(), (Object)storedClient.getRootUrl());
        }
        if (client.getAdminUrl() != null) {
            Assert.assertEquals((Object)client.getAdminUrl(), (Object)storedClient.getAdminUrl());
        }
        if (client.getBaseUrl() != null) {
            Assert.assertEquals((Object)client.getBaseUrl(), (Object)storedClient.getBaseUrl());
        }
        if (client.isSurrogateAuthRequired() != null) {
            Assert.assertEquals((Object)client.isSurrogateAuthRequired(), (Object)storedClient.isSurrogateAuthRequired());
        }
        if (client.getClientAuthenticatorType() != null) {
            Assert.assertEquals((Object)client.getClientAuthenticatorType(), (Object)storedClient.getClientAuthenticatorType());
        }
        if (client.getNotBefore() != null) {
            Assert.assertEquals((Object)client.getNotBefore(), (Object)storedClient.getNotBefore());
        }
        if (client.getDefaultRoles() != null) {
            HashSet<String> set = new HashSet<String>();
            for (String val : client.getDefaultRoles()) {
                set.add(val);
            }
            HashSet<String> storedSet = new HashSet<String>();
            for (String val : storedClient.getDefaultRoles()) {
                storedSet.add(val);
            }
            Assert.assertEquals(set, storedSet);
        }
        if ((redirectUris = client.getRedirectUris()) != null) {
            HashSet<String> set = new HashSet<String>();
            for (String val : client.getRedirectUris()) {
                set.add(val);
            }
            HashSet<String> storedSet = new HashSet<String>();
            for (String val : storedClient.getRedirectUris()) {
                storedSet.add(val);
            }
            Assert.assertEquals(set, storedSet);
        }
        if ((webOrigins = client.getWebOrigins()) != null) {
            HashSet<String> set = new HashSet<String>();
            for (String val : client.getWebOrigins()) {
                set.add(val);
            }
            HashSet<String> storedSet = new HashSet<String>();
            for (String val : storedClient.getWebOrigins()) {
                storedSet.add(val);
            }
            Assert.assertEquals(set, storedSet);
        }
    }
}

