/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;

public class ConcurrencyTest
extends AbstractAdminTest {
    private static final Logger log = Logger.getLogger(ConcurrencyTest.class);
    private static final int DEFAULT_THREADS = 5;
    private static final int DEFAULT_ITERATIONS = 20;
    private static final boolean SYNCHRONIZED = false;
    boolean passedCreateClient = false;
    boolean passedCreateRole = false;

    public void testAllConcurrently() throws Throwable {
        Thread client = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ConcurrencyTest.this.createClient();
                    ConcurrencyTest.this.passedCreateClient = true;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        });
        Thread role = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ConcurrencyTest.this.createRole();
                    ConcurrencyTest.this.passedCreateRole = true;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        });
        client.start();
        role.start();
        client.join();
        role.join();
        Assert.assertTrue((boolean)this.passedCreateClient);
        Assert.assertTrue((boolean)this.passedCreateRole);
    }

    @Test
    public void createClient() throws Throwable {
        System.out.println("***************************");
        long start = System.currentTimeMillis();
        this.run(new KeycloakRunnable(){

            @Override
            public void run(Keycloak keycloak, RealmResource realm, int threadNum, int iterationNum) {
                String name = "c-" + threadNum + "-" + iterationNum;
                ClientRepresentation c = new ClientRepresentation();
                c.setClientId(name);
                Response response = realm.clients().create(c);
                String id = ApiUtil.getCreatedId(response);
                response.close();
                c = realm.clients().get(id).toRepresentation();
                Assert.assertNotNull((Object)c);
                boolean found = false;
                for (ClientRepresentation r : realm.clients().findAll()) {
                    if (!r.getClientId().equals(name)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    Assert.fail((String)("Client " + name + " not found in client list"));
                }
            }
        });
        long end = System.currentTimeMillis() - start;
        System.out.println("createClient took " + end);
    }

    @Test
    public void createGroup() throws Throwable {
        System.out.println("***************************");
        long start = System.currentTimeMillis();
        this.run(new KeycloakRunnable(){

            @Override
            public void run(Keycloak keycloak, RealmResource realm, int threadNum, int iterationNum) {
                String name = "c-" + threadNum + "-" + iterationNum;
                GroupRepresentation c = new GroupRepresentation();
                c.setName(name);
                Response response = realm.groups().add(c);
                String id = ApiUtil.getCreatedId(response);
                response.close();
                c = realm.groups().group(id).toRepresentation();
                Assert.assertNotNull((Object)c);
                boolean found = false;
                for (GroupRepresentation r : realm.groups().groups()) {
                    if (!r.getName().equals(name)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    Assert.fail((String)("Group " + name + " not found in group list"));
                }
            }
        });
        long end = System.currentTimeMillis() - start;
        System.out.println("createGroup took " + end);
    }

    @Test
    @Ignore
    public void createRemoveClient() throws Throwable {
        System.out.println("***************************");
        long start = System.currentTimeMillis();
        this.run(new KeycloakRunnable(){

            @Override
            public void run(Keycloak keycloak, RealmResource realm, int threadNum, int iterationNum) {
                String name = "c-" + threadNum + "-" + iterationNum;
                ClientRepresentation c = new ClientRepresentation();
                c.setClientId(name);
                Response response = realm.clients().create(c);
                String id = ApiUtil.getCreatedId(response);
                response.close();
                c = realm.clients().get(id).toRepresentation();
                Assert.assertNotNull((Object)c);
                boolean found = false;
                for (ClientRepresentation r : realm.clients().findAll()) {
                    if (!r.getClientId().equals(name)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    Assert.fail((String)("Client " + name + " not found in client list"));
                }
                realm.clients().get(id).remove();
                try {
                    c = realm.clients().get(id).toRepresentation();
                    Assert.fail((String)("Client " + name + " should not be found.  Should throw a 404"));
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
                found = false;
                for (ClientRepresentation r : realm.clients().findAll()) {
                    if (!r.getClientId().equals(name)) continue;
                    found = true;
                    break;
                }
                Assert.assertFalse((String)("Client " + name + " should not be in client list"), (boolean)found);
            }
        });
        long end = System.currentTimeMillis() - start;
        System.out.println("createClient took " + end);
    }

    @Test
    public void createRole() throws Throwable {
        long start = System.currentTimeMillis();
        this.run(new KeycloakRunnable(){

            @Override
            public void run(Keycloak keycloak, RealmResource realm, int threadNum, int iterationNum) {
                String name = "r-" + threadNum + "-" + iterationNum;
                RoleRepresentation r = new RoleRepresentation(name, null, false);
                realm.roles().create(r);
                Assert.assertNotNull((Object)realm.roles().get(name).toRepresentation());
            }
        });
        long end = System.currentTimeMillis() - start;
        System.out.println("createRole took " + end);
    }

    @Test
    public void createClientRole() throws Throwable {
        long start = System.currentTimeMillis();
        ClientRepresentation c = new ClientRepresentation();
        c.setClientId("client");
        Response response = this.realm.clients().create(c);
        final String clientId = ApiUtil.getCreatedId(response);
        response.close();
        System.out.println("*********************************************");
        this.run(new KeycloakRunnable(){

            @Override
            public void run(Keycloak keycloak, RealmResource realm, int threadNum, int iterationNum) {
                String name = "r-" + threadNum + "-" + iterationNum;
                RoleRepresentation r = new RoleRepresentation(name, null, false);
                ClientResource client = realm.clients().get(clientId);
                client.roles().create(r);
                Assert.assertNotNull((Object)client.roles().get(name).toRepresentation());
            }
        });
        long end = System.currentTimeMillis() - start;
        System.out.println("createClientRole took " + end);
        System.out.println("*********************************************");
    }

    private void run(KeycloakRunnable runnable) throws Throwable {
        this.run(runnable, 5, 20);
    }

    private void run(final KeycloakRunnable runnable, int numThreads, final int numIterationsPerThread) throws Throwable {
        final CountDownLatch latch = new CountDownLatch(numThreads);
        final AtomicReference failed = new AtomicReference();
        LinkedList<8> threads = new LinkedList<8>();
        final Lock lock = null;
        int t = 0;
        while (t < numThreads) {
            final int n = t++;
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (lock != null) {
                            lock.lock();
                        }
                        Keycloak keycloak = Keycloak.getInstance((String)ConcurrencyTest.this.getAuthServerRoot().toString(), (String)"master", (String)"admin", (String)"admin", (String)"admin-cli");
                        RealmResource realm = keycloak.realm("admin-client-test");
                        for (int i = 0; i < numIterationsPerThread && latch.getCount() > 0L; ++i) {
                            log.infov("thread {0}, iteration {1}", (Object)n, (Object)i);
                            runnable.run(keycloak, realm, n, i);
                        }
                        latch.countDown();
                    }
                    catch (Throwable t) {
                        failed.compareAndSet(null, t);
                        while (latch.getCount() > 0L) {
                            latch.countDown();
                        }
                    }
                    finally {
                        if (lock != null) {
                            lock.unlock();
                        }
                    }
                }
            };
            thread.start();
            threads.add(thread);
        }
        latch.await();
        for (Thread thread : threads) {
            thread.join();
        }
        if (failed.get() != null) {
            throw (Throwable)failed.get();
        }
    }

    static interface KeycloakRunnable {
        public void run(Keycloak var1, RealmResource var2, int var3, int var4);
    }
}

