/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.pages.ConsentPage;
import org.keycloak.testsuite.pages.LoginPage;

public class ConsentsTest
extends AbstractKeycloakTest {
    static final String REALM_PROV_NAME = "provider";
    static final String REALM_CONS_NAME = "consumer";
    static final String IDP_OIDC_ALIAS = "kc-oidc-idp";
    static final String IDP_OIDC_PROVIDER_ID = "keycloak-oidc";
    static final String CLIENT_ID = "brokerapp";
    static final String CLIENT_SECRET = "secret";
    static final String USER_LOGIN = "testuser";
    static final String USER_EMAIL = "user@localhost.com";
    static final String USER_PASSWORD = "password";
    static final String USER_FIRSTNAME = "User";
    static final String USER_LASTNAME = "Tester";
    @Page
    protected LoginPage accountLoginPage;
    @Page
    protected ConsentPage consentPage;

    protected RealmRepresentation createProviderRealm() {
        RealmRepresentation realm = new RealmRepresentation();
        realm.setRealm(REALM_PROV_NAME);
        realm.setEnabled(Boolean.valueOf(true));
        return realm;
    }

    protected RealmRepresentation createConsumerRealm() {
        RealmRepresentation realm = new RealmRepresentation();
        realm.setRealm(REALM_CONS_NAME);
        realm.setEnabled(Boolean.valueOf(true));
        return realm;
    }

    protected List<ClientRepresentation> createProviderClients() {
        ClientRepresentation client = new ClientRepresentation();
        client.setId(CLIENT_ID);
        client.setName(CLIENT_ID);
        client.setSecret(CLIENT_SECRET);
        client.setEnabled(Boolean.valueOf(true));
        client.setConsentRequired(Boolean.valueOf(true));
        client.setRedirectUris(Collections.singletonList(this.getAuthRoot() + "/auth/realms/" + REALM_CONS_NAME + "/broker/" + IDP_OIDC_ALIAS + "/endpoint/*"));
        client.setAdminUrl(this.getAuthRoot() + "/auth/realms/" + REALM_CONS_NAME + "/broker/" + IDP_OIDC_ALIAS + "/endpoint");
        return Collections.singletonList(client);
    }

    protected IdentityProviderRepresentation setUpIdentityProvider() {
        IdentityProviderRepresentation idp = this.createIdentityProvider(IDP_OIDC_ALIAS, IDP_OIDC_PROVIDER_ID);
        Map config = idp.getConfig();
        config.put("clientId", CLIENT_ID);
        config.put("clientSecret", CLIENT_SECRET);
        config.put("prompt", "login");
        config.put("authorizationUrl", this.getAuthRoot() + "/auth/realms/" + REALM_PROV_NAME + "/protocol/openid-connect/auth");
        config.put("tokenUrl", this.getAuthRoot() + "/auth/realms/" + REALM_PROV_NAME + "/protocol/openid-connect/token");
        config.put("logoutUrl", this.getAuthRoot() + "/auth/realms/" + REALM_PROV_NAME + "/protocol/openid-connect/logout");
        config.put("userInfoUrl", this.getAuthRoot() + "/auth/realms/" + REALM_PROV_NAME + "/protocol/openid-connect/userinfo");
        config.put("defaultScope", "email profile");
        config.put("backchannelSupported", "true");
        return idp;
    }

    protected String getUserLogin() {
        return USER_LOGIN;
    }

    protected String getUserPassword() {
        return USER_PASSWORD;
    }

    protected String getUserEmail() {
        return USER_EMAIL;
    }

    protected String getUserFirstName() {
        return USER_FIRSTNAME;
    }

    protected String getUserLastName() {
        return USER_LASTNAME;
    }

    protected String providerRealmName() {
        return REALM_PROV_NAME;
    }

    protected String consumerRealmName() {
        return REALM_CONS_NAME;
    }

    protected String getIDPAlias() {
        return IDP_OIDC_ALIAS;
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation providerRealm = this.createProviderRealm();
        RealmRepresentation consumerRealm = this.createConsumerRealm();
        testRealms.add(providerRealm);
        testRealms.add(consumerRealm);
    }

    @Before
    public void createUser() {
        this.log.debug((Object)("creating user for realm " + this.providerRealmName()));
        UserRepresentation user = new UserRepresentation();
        user.setUsername(this.getUserLogin());
        user.setEmail(this.getUserEmail());
        user.setFirstName(this.getUserFirstName());
        user.setLastName(this.getUserLastName());
        user.setEmailVerified(Boolean.valueOf(true));
        user.setEnabled(Boolean.valueOf(true));
        RealmResource realmResource = this.adminClient.realm(this.providerRealmName());
        String userId = ApiUtil.createUserWithAdminClient(realmResource, user);
        ApiUtil.resetUserPassword(realmResource.users().get(userId), this.getUserPassword(), false);
    }

    @Before
    public void addIdentityProviderToProviderRealm() {
        this.log.debug((Object)("adding identity provider to realm " + this.consumerRealmName()));
        RealmResource realm = this.adminClient.realm(this.consumerRealmName());
        realm.identityProviders().create(this.setUpIdentityProvider());
    }

    @Before
    public void addClients() {
        List<ClientRepresentation> clients = this.createProviderClients();
        if (clients != null) {
            RealmResource providerRealm = this.adminClient.realm(this.providerRealmName());
            for (ClientRepresentation client : clients) {
                this.log.debug((Object)("adding client " + client.getName() + " to realm " + this.providerRealmName()));
                providerRealm.clients().create(client);
            }
        }
    }

    protected String getAuthRoot() {
        return this.suiteContext.getAuthServerInfo().getContextRoot().toString();
    }

    protected IdentityProviderRepresentation createIdentityProvider(String alias, String providerId) {
        IdentityProviderRepresentation identityProviderRepresentation = new IdentityProviderRepresentation();
        identityProviderRepresentation.setAlias(alias);
        identityProviderRepresentation.setProviderId(providerId);
        identityProviderRepresentation.setEnabled(true);
        return identityProviderRepresentation;
    }

    private void waitForPage(String title) {
        long startAt = System.currentTimeMillis();
        while (!this.driver.getTitle().toLowerCase().contains(title) && System.currentTimeMillis() - startAt < 200L) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Test
    public void testConsents() {
        this.driver.navigate().to(this.getAccountUrl(this.consumerRealmName()));
        this.log.debug((Object)("Clicking social " + this.getIDPAlias()));
        this.accountLoginPage.clickSocial(this.getIDPAlias());
        if (!this.driver.getCurrentUrl().contains("/auth/realms/" + this.providerRealmName() + "/")) {
            this.log.debug((Object)("Not on provider realm page, url: " + this.driver.getCurrentUrl()));
        }
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.providerRealmName() + "/"));
        this.log.debug((Object)"Logging in");
        this.accountLoginPage.login(this.getUserLogin(), this.getUserPassword());
        this.waitForPage("grant access");
        Assert.assertTrue((boolean)this.consentPage.isCurrent());
        this.consentPage.confirm();
        Assert.assertTrue((String)"We must be on correct realm right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.consumerRealmName() + "/"));
        UsersResource consumerUsers = this.adminClient.realm(this.consumerRealmName()).users();
        Assert.assertTrue((String)"There must be at least one user", (consumerUsers.count() > 0 ? 1 : 0) != 0);
        List users = consumerUsers.search("", Integer.valueOf(0), Integer.valueOf(5));
        UserRepresentation foundUser = null;
        for (UserRepresentation user : users) {
            if (!user.getUsername().equals(this.getUserLogin()) || !user.getEmail().equals(this.getUserEmail())) continue;
            foundUser = user;
            break;
        }
        Assert.assertNotNull((String)("There must be user " + this.getUserLogin() + " in realm " + this.consumerRealmName()), foundUser);
        RealmResource providerRealm = this.adminClient.realm(this.providerRealmName());
        users = providerRealm.users().search(null, foundUser.getFirstName(), foundUser.getLastName(), null, Integer.valueOf(0), Integer.valueOf(1));
        Assert.assertEquals((String)"Same user should be in provider realm", (long)1L, (long)users.size());
        String userId = ((UserRepresentation)users.get(0)).getId();
        UserResource userResource = providerRealm.users().get(userId);
        List consents = userResource.getConsents();
        Assert.assertEquals((String)"There should be one consent", (long)1L, (long)consents.size());
        Map consent = (Map)consents.get(0);
        Assert.assertEquals((String)"Consent should be given to brokerapp", (Object)CLIENT_ID, consent.get("clientId"));
        List sessions = userResource.getUserSessions();
        Assert.assertEquals((String)"There should be one active session", (long)1L, (long)sessions.size());
        userResource.revokeConsent(CLIENT_ID);
        consents = userResource.getConsents();
        Assert.assertEquals((String)"There should be no consents", (long)0L, (long)consents.size());
        sessions = userResource.getUserSessions();
        Assert.assertEquals((String)"There should be no active session", (long)0L, (long)sessions.size());
    }

    private String getAccountUrl(String realmName) {
        return this.getAuthRoot() + "/auth/realms/" + realmName + "/account";
    }
}

