/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.junit.Test;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.IndexedEndpointType;
import org.keycloak.dom.saml.v2.metadata.KeyDescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.dom.saml.v2.metadata.SPSSODescriptorType;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperTypeRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLEntityDescriptorParser;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.util.AdminEventPaths;

public class IdentityProviderTest
extends AbstractAdminTest {
    @Test
    public void testFindAll() {
        this.create(this.createRep("google", "google"));
        this.create(this.createRep("facebook", "facebook"));
        Assert.assertNames(this.realm.identityProviders().findAll(), "google", "facebook");
    }

    @Test
    public void testCreate() {
        IdentityProviderRepresentation newIdentityProvider = this.createRep("new-identity-provider", "oidc");
        newIdentityProvider.getConfig().put("clientId", "clientId");
        newIdentityProvider.getConfig().put("clientSecret", "clientSecret");
        this.create(newIdentityProvider);
        IdentityProviderResource identityProviderResource = this.realm.identityProviders().get("new-identity-provider");
        org.junit.Assert.assertNotNull((Object)identityProviderResource);
        IdentityProviderRepresentation representation = identityProviderResource.toRepresentation();
        org.junit.Assert.assertNotNull((Object)representation);
        org.junit.Assert.assertNotNull((Object)representation.getInternalId());
        org.junit.Assert.assertEquals((Object)"new-identity-provider", (Object)representation.getAlias());
        org.junit.Assert.assertEquals((Object)"oidc", (Object)representation.getProviderId());
        org.junit.Assert.assertEquals((Object)"clientId", representation.getConfig().get("clientId"));
        org.junit.Assert.assertEquals((Object)"clientSecret", representation.getConfig().get("clientSecret"));
        org.junit.Assert.assertTrue((boolean)representation.isEnabled());
        org.junit.Assert.assertFalse((boolean)representation.isStoreToken());
        org.junit.Assert.assertFalse((boolean)representation.isTrustEmail());
    }

    @Test
    public void testUpdate() {
        IdentityProviderRepresentation newIdentityProvider = this.createRep("update-identity-provider", "oidc");
        newIdentityProvider.getConfig().put("clientId", "clientId");
        newIdentityProvider.getConfig().put("clientSecret", "clientSecret");
        this.create(newIdentityProvider);
        IdentityProviderResource identityProviderResource = this.realm.identityProviders().get("update-identity-provider");
        org.junit.Assert.assertNotNull((Object)identityProviderResource);
        IdentityProviderRepresentation representation = identityProviderResource.toRepresentation();
        org.junit.Assert.assertNotNull((Object)representation);
        org.junit.Assert.assertEquals((Object)"update-identity-provider", (Object)representation.getAlias());
        representation.setAlias("changed-alias");
        representation.setEnabled(false);
        representation.setStoreToken(true);
        representation.getConfig().put("clientId", "changedClientId");
        identityProviderResource.update(representation);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.identityProviderPath("update-identity-provider"), (Object)representation, ResourceType.IDENTITY_PROVIDER);
        identityProviderResource = this.realm.identityProviders().get(representation.getInternalId());
        org.junit.Assert.assertNotNull((Object)identityProviderResource);
        representation = identityProviderResource.toRepresentation();
        org.junit.Assert.assertFalse((boolean)representation.isEnabled());
        org.junit.Assert.assertTrue((boolean)representation.isStoreToken());
        org.junit.Assert.assertEquals((Object)"changedClientId", representation.getConfig().get("clientId"));
    }

    @Test
    public void testRemove() {
        IdentityProviderRepresentation newIdentityProvider = this.createRep("remove-identity-provider", "saml");
        this.create(newIdentityProvider);
        IdentityProviderResource identityProviderResource = this.realm.identityProviders().get("remove-identity-provider");
        org.junit.Assert.assertNotNull((Object)identityProviderResource);
        IdentityProviderRepresentation representation = identityProviderResource.toRepresentation();
        org.junit.Assert.assertNotNull((Object)representation);
        identityProviderResource.remove();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.identityProviderPath("remove-identity-provider"), ResourceType.IDENTITY_PROVIDER);
        try {
            this.realm.identityProviders().get("remove-identity-provider").toRepresentation();
            Assert.fail((String)"Not expected to found");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void create(IdentityProviderRepresentation idpRep) {
        Response response = this.realm.identityProviders().create(idpRep);
        Assert.assertNotNull((Object)ApiUtil.getCreatedId(response));
        response.close();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.identityProviderPath(idpRep.getAlias()), (Object)idpRep, ResourceType.IDENTITY_PROVIDER);
    }

    private IdentityProviderRepresentation createRep(String id, String providerId) {
        return this.createRep(id, providerId, null);
    }

    private IdentityProviderRepresentation createRep(String id, String providerId, Map<String, String> config) {
        IdentityProviderRepresentation idp = new IdentityProviderRepresentation();
        idp.setAlias(id);
        idp.setProviderId(providerId);
        idp.setEnabled(true);
        if (config != null) {
            idp.setConfig(config);
        }
        return idp;
    }

    @Test
    public void testMapperTypes() {
        this.create(this.createRep("google", "google"));
        IdentityProviderResource provider = this.realm.identityProviders().get("google");
        Map mapperTypes = provider.getMapperTypes();
        this.assertMapperTypes(mapperTypes, "google-user-attribute-mapper");
        this.create(this.createRep("facebook", "facebook"));
        provider = this.realm.identityProviders().get("facebook");
        mapperTypes = provider.getMapperTypes();
        this.assertMapperTypes(mapperTypes, "facebook-user-attribute-mapper");
        this.create(this.createRep("github", "github"));
        provider = this.realm.identityProviders().get("github");
        mapperTypes = provider.getMapperTypes();
        this.assertMapperTypes(mapperTypes, "github-user-attribute-mapper");
        this.create(this.createRep("twitter", "twitter"));
        provider = this.realm.identityProviders().get("twitter");
        mapperTypes = provider.getMapperTypes();
        this.assertMapperTypes(mapperTypes, new String[0]);
        this.create(this.createRep("linkedin", "linkedin"));
        provider = this.realm.identityProviders().get("linkedin");
        mapperTypes = provider.getMapperTypes();
        this.assertMapperTypes(mapperTypes, "linkedin-user-attribute-mapper");
        this.create(this.createRep("microsoft", "microsoft"));
        provider = this.realm.identityProviders().get("microsoft");
        mapperTypes = provider.getMapperTypes();
        this.assertMapperTypes(mapperTypes, "microsoft-user-attribute-mapper");
        this.create(this.createRep("stackoverflow", "stackoverflow"));
        provider = this.realm.identityProviders().get("stackoverflow");
        mapperTypes = provider.getMapperTypes();
        this.assertMapperTypes(mapperTypes, "stackoverflow-user-attribute-mapper");
        this.create(this.createRep("keycloak-oidc", "keycloak-oidc"));
        provider = this.realm.identityProviders().get("keycloak-oidc");
        mapperTypes = provider.getMapperTypes();
        this.assertMapperTypes(mapperTypes, "keycloak-oidc-role-to-role-idp-mapper", "oidc-user-attribute-idp-mapper", "oidc-role-idp-mapper", "oidc-username-idp-mapper");
        this.create(this.createRep("oidc", "oidc"));
        provider = this.realm.identityProviders().get("oidc");
        mapperTypes = provider.getMapperTypes();
        this.assertMapperTypes(mapperTypes, "oidc-user-attribute-idp-mapper", "oidc-role-idp-mapper", "oidc-username-idp-mapper");
        this.create(this.createRep("saml", "saml"));
        provider = this.realm.identityProviders().get("saml");
        mapperTypes = provider.getMapperTypes();
        this.assertMapperTypes(mapperTypes, "saml-user-attribute-idp-mapper", "saml-role-idp-mapper", "saml-username-idp-mapper");
    }

    private void assertMapperTypes(Map<String, IdentityProviderMapperTypeRepresentation> mapperTypes, String ... mapperIds) {
        HashSet<String> expected = new HashSet<String>();
        expected.add("hardcoded-user-session-attribute-idp-mapper");
        expected.add("oidc-hardcoded-role-idp-mapper");
        expected.add("hardcoded-attribute-idp-mapper");
        for (String id : mapperIds) {
            expected.add(id);
        }
        Assert.assertEquals((String)"mapperTypes", expected, mapperTypes.keySet());
    }

    @Test
    public void testNoExport() {
        this.create(this.createRep("keycloak-oidc", "keycloak-oidc"));
        Response response = this.realm.identityProviders().get("keycloak-oidc").export("json");
        Assert.assertEquals((String)"status", (long)204L, (long)response.getStatus());
        String body = (String)response.readEntity(String.class);
        Assert.assertNull((String)"body", (Object)body);
        response.close();
    }

    @Test
    public void testSamlImportAndExport() throws URISyntaxException, IOException, ParsingException {
        MultipartFormDataOutput form = new MultipartFormDataOutput();
        form.addFormData("providerId", (Object)"saml", MediaType.TEXT_PLAIN_TYPE);
        URL idpMeta = this.getClass().getClassLoader().getResource("admin-test/saml-idp-metadata.xml");
        byte[] content = Files.readAllBytes(Paths.get(idpMeta.toURI()));
        String body = new String(content, Charset.forName("utf-8"));
        form.addFormData("file", (Object)body, MediaType.APPLICATION_XML_TYPE, "saml-idp-metadata.xml");
        Map result = this.realm.identityProviders().importFrom(form);
        this.assertSamlImport(result);
        this.create(this.createRep("saml", "saml", result));
        IdentityProviderResource provider = this.realm.identityProviders().get("saml");
        IdentityProviderRepresentation rep = provider.toRepresentation();
        this.assertCreatedSamlIdp(rep);
        List providers = this.realm.identityProviders().findAll();
        Assert.assertNotNull((String)"identityProviders not null", (Object)providers);
        Assert.assertEquals((String)"identityProviders instance count", (long)1L, (long)providers.size());
        this.assertEqual(rep, (IdentityProviderRepresentation)providers.get(0));
        Response response = this.realm.identityProviders().get("saml").export("xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        body = (String)response.readEntity(String.class);
        response.close();
        this.assertSamlExport(body);
    }

    @Test
    public void testMappers() {
        this.create(this.createRep("google", "google"));
        IdentityProviderResource provider = this.realm.identityProviders().get("google");
        IdentityProviderMapperRepresentation mapper = new IdentityProviderMapperRepresentation();
        mapper.setIdentityProviderAlias("google");
        mapper.setName("my_mapper");
        mapper.setIdentityProviderMapper("oidc-hardcoded-role-idp-mapper");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("role", "offline_access");
        mapper.setConfig(config);
        Response response = provider.addMapper(mapper);
        String id = ApiUtil.getCreatedId(response);
        Assert.assertNotNull((Object)id);
        response.close();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.identityProviderMapperPath("google", id), (Object)mapper, ResourceType.IDENTITY_PROVIDER_MAPPER);
        List mappers = provider.getMappers();
        Assert.assertEquals((String)"mappers count", (long)1L, (long)mappers.size());
        Assert.assertEquals((String)"newly created mapper id", (Object)id, (Object)((IdentityProviderMapperRepresentation)mappers.get(0)).getId());
        mapper = provider.getMapperById(id);
        Assert.assertNotNull((String)"mapperById not null", (Object)mapper);
        Assert.assertEquals((String)"mapper id", (Object)id, (Object)mapper.getId());
        Assert.assertNotNull((String)"mapper.config exists", (Object)mapper.getConfig());
        Assert.assertEquals((String)"config retained", (Object)"offline_access", mapper.getConfig().get("role"));
        mapper.getConfig().put("role", "master-realm.manage-realm");
        provider.update(id, mapper);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.identityProviderMapperPath("google", id), (Object)mapper, ResourceType.IDENTITY_PROVIDER_MAPPER);
        mapper = provider.getMapperById(id);
        Assert.assertNotNull((String)"mapperById not null", (Object)mapper);
        Assert.assertEquals((String)"config changed", (Object)"master-realm.manage-realm", mapper.getConfig().get("role"));
        provider.delete(id);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.identityProviderMapperPath("google", id), ResourceType.IDENTITY_PROVIDER_MAPPER);
        try {
            provider.getMapperById(id);
            Assert.fail((String)"Should fail with NotFoundException");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testInstalledIdentityProviders() {
        Response response = this.realm.identityProviders().getIdentityProviders("oidc");
        Assert.assertEquals((String)"Status", (long)200L, (long)response.getStatus());
        Map body = (Map)response.readEntity(Map.class);
        this.assertProviderInfo(body, "oidc", "OpenID Connect v1.0");
        response = this.realm.identityProviders().getIdentityProviders("keycloak-oidc");
        Assert.assertEquals((String)"Status", (long)200L, (long)response.getStatus());
        body = (Map)response.readEntity(Map.class);
        this.assertProviderInfo(body, "keycloak-oidc", "Keycloak OpenID Connect");
        response = this.realm.identityProviders().getIdentityProviders("saml");
        Assert.assertEquals((String)"Status", (long)200L, (long)response.getStatus());
        body = (Map)response.readEntity(Map.class);
        this.assertProviderInfo(body, "saml", "SAML v2.0");
        response = this.realm.identityProviders().getIdentityProviders("google");
        Assert.assertEquals((String)"Status", (long)200L, (long)response.getStatus());
        body = (Map)response.readEntity(Map.class);
        this.assertProviderInfo(body, "google", "Google");
        response = this.realm.identityProviders().getIdentityProviders("facebook");
        Assert.assertEquals((String)"Status", (long)200L, (long)response.getStatus());
        body = (Map)response.readEntity(Map.class);
        this.assertProviderInfo(body, "facebook", "Facebook");
        response = this.realm.identityProviders().getIdentityProviders("github");
        Assert.assertEquals((String)"Status", (long)200L, (long)response.getStatus());
        body = (Map)response.readEntity(Map.class);
        this.assertProviderInfo(body, "github", "GitHub");
        response = this.realm.identityProviders().getIdentityProviders("twitter");
        Assert.assertEquals((String)"Status", (long)200L, (long)response.getStatus());
        body = (Map)response.readEntity(Map.class);
        this.assertProviderInfo(body, "twitter", "Twitter");
        response = this.realm.identityProviders().getIdentityProviders("linkedin");
        Assert.assertEquals((String)"Status", (long)200L, (long)response.getStatus());
        body = (Map)response.readEntity(Map.class);
        this.assertProviderInfo(body, "linkedin", "LinkedIn");
        response = this.realm.identityProviders().getIdentityProviders("microsoft");
        Assert.assertEquals((String)"Status", (long)200L, (long)response.getStatus());
        body = (Map)response.readEntity(Map.class);
        this.assertProviderInfo(body, "microsoft", "Microsoft");
        response = this.realm.identityProviders().getIdentityProviders("stackoverflow");
        Assert.assertEquals((String)"Status", (long)200L, (long)response.getStatus());
        body = (Map)response.readEntity(Map.class);
        this.assertProviderInfo(body, "stackoverflow", "StackOverflow");
        response = this.realm.identityProviders().getIdentityProviders("nonexistent");
        Assert.assertEquals((String)"Status", (long)400L, (long)response.getStatus());
    }

    private void assertEqual(IdentityProviderRepresentation expected, IdentityProviderRepresentation actual) {
        Assert.assertNotNull((String)"expected IdentityProviderRepresentation not null", (Object)expected);
        Assert.assertNotNull((String)"actual IdentityProviderRepresentation not null", (Object)actual);
        Assert.assertEquals((String)"internalId", (Object)expected.getInternalId(), (Object)actual.getInternalId());
        Assert.assertEquals((String)"alias", (Object)expected.getAlias(), (Object)actual.getAlias());
        Assert.assertEquals((String)"providerId", (Object)expected.getProviderId(), (Object)actual.getProviderId());
        Assert.assertEquals((String)"enabled", (Object)expected.isEnabled(), (Object)actual.isEnabled());
        Assert.assertEquals((String)"firstBrokerLoginFlowAlias", (Object)expected.getFirstBrokerLoginFlowAlias(), (Object)actual.getFirstBrokerLoginFlowAlias());
        Assert.assertEquals((String)"config", (Object)expected.getConfig(), (Object)actual.getConfig());
    }

    private void assertCreatedSamlIdp(IdentityProviderRepresentation idp) {
        Assert.assertNotNull((String)"IdentityProviderRepresentation not null", (Object)idp);
        Assert.assertNotNull((String)"internalId", (Object)idp.getInternalId());
        Assert.assertEquals((String)"alias", (Object)"saml", (Object)idp.getAlias());
        Assert.assertEquals((String)"providerId", (Object)"saml", (Object)idp.getProviderId());
        Assert.assertTrue((String)"enabled", (boolean)idp.isEnabled());
        Assert.assertEquals((String)"firstBrokerLoginFlowAlias", (Object)"first broker login", (Object)idp.getFirstBrokerLoginFlowAlias());
        this.assertSamlConfig(idp.getConfig());
    }

    private void assertSamlConfig(Map<String, String> config) {
        Assert.assertEquals((String)"Config size", (long)7L, (long)config.size());
        Assert.assertEquals((String)"validateSignature", (Object)"true", (Object)config.get("validateSignature"));
        Assert.assertEquals((String)"singleLogoutServiceUrl", (Object)"http://localhost:8080/auth/realms/master/protocol/saml", (Object)config.get("singleLogoutServiceUrl"));
        Assert.assertEquals((String)"postBindingResponse", (Object)"true", (Object)config.get("postBindingResponse"));
        Assert.assertEquals((String)"postBindingAuthnRequest", (Object)"true", (Object)config.get("postBindingAuthnRequest"));
        Assert.assertEquals((String)"singleSignOnServiceUrl", (Object)"http://localhost:8080/auth/realms/master/protocol/saml", (Object)config.get("singleSignOnServiceUrl"));
        Assert.assertEquals((String)"wantAuthnRequestsSigned", (Object)"true", (Object)config.get("wantAuthnRequestsSigned"));
        Assert.assertNotNull((String)"signingCertificate not null", (Object)config.get("signingCertificate"));
    }

    private void assertSamlImport(Map<String, String> config) {
        this.assertSamlConfig(config);
    }

    private void assertSamlExport(String body) throws ParsingException, URISyntaxException {
        Object entBody = new SAMLEntityDescriptorParser().parse(StaxParserUtil.getXMLEventReader((InputStream)new ByteArrayInputStream(body.getBytes(Charset.forName("utf-8")))));
        Assert.assertEquals((String)"Parsed export type", EntityDescriptorType.class, entBody.getClass());
        EntityDescriptorType entity = (EntityDescriptorType)entBody;
        Assert.assertEquals((String)"EntityID", (Object)"http://localhost:8180/auth/realms/admin-client-test", (Object)entity.getEntityID());
        Assert.assertNotNull((String)"ChoiceType not null", (Object)entity.getChoiceType());
        Assert.assertEquals((String)"ChoiceType.size", (long)1L, (long)entity.getChoiceType().size());
        List descriptors = ((EntityDescriptorType.EDTChoiceType)entity.getChoiceType().get(0)).getDescriptors();
        Assert.assertNotNull((String)"Descriptors not null", (Object)descriptors);
        Assert.assertEquals((String)"Descriptors.size", (long)1L, (long)descriptors.size());
        SPSSODescriptorType desc = ((EntityDescriptorType.EDTDescriptorChoiceType)descriptors.get(0)).getSpDescriptor();
        Assert.assertNotNull((String)"SPSSODescriptor not null", (Object)desc);
        Assert.assertTrue((String)"AuthnRequestsSigned", (boolean)desc.isAuthnRequestsSigned());
        HashSet<String> expected = new HashSet<String>(Arrays.asList("urn:oasis:names:tc:SAML:2.0:protocol", "urn:oasis:names:tc:SAML:1.1:protocol", "http://schemas.xmlsoap.org/ws/2003/07/secext"));
        HashSet actual = new HashSet(desc.getProtocolSupportEnumeration());
        Assert.assertEquals((String)"ProtocolSupportEnumeration", expected, actual);
        Assert.assertNotNull((String)"AssertionConsumerService not null", (Object)desc.getAssertionConsumerService());
        Assert.assertEquals((String)"AssertionConsumerService.size", (long)1L, (long)desc.getAssertionConsumerService().size());
        IndexedEndpointType endpoint = (IndexedEndpointType)desc.getAssertionConsumerService().get(0);
        Assert.assertEquals((String)"AssertionConsumerService.Location", (Object)new URI("http://localhost:8180/auth/realms/admin-client-test/broker/saml/endpoint"), (Object)endpoint.getLocation());
        Assert.assertEquals((String)"AssertionConsumerService.Binding", (Object)new URI("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST"), (Object)endpoint.getBinding());
        Assert.assertTrue((String)"AssertionConsumerService.isDefault", (boolean)endpoint.isIsDefault());
        Assert.assertNotNull((String)"SingleLogoutService not null", (Object)desc.getSingleLogoutService());
        Assert.assertEquals((String)"SingleLogoutService.size", (long)1L, (long)desc.getSingleLogoutService().size());
        EndpointType sloEndpoint = (EndpointType)desc.getSingleLogoutService().get(0);
        Assert.assertEquals((String)"SingleLogoutService.Location", (Object)new URI("http://localhost:8180/auth/realms/admin-client-test/broker/saml/endpoint"), (Object)sloEndpoint.getLocation());
        Assert.assertEquals((String)"SingleLogoutService.Binding", (Object)new URI("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST"), (Object)sloEndpoint.getBinding());
        Assert.assertNotNull((String)"KeyDescriptor not null", (Object)desc.getKeyDescriptor());
        Assert.assertEquals((String)"KeyDescriptor.size", (long)1L, (long)desc.getKeyDescriptor().size());
        Assert.assertEquals((String)"KeyDescriptor.Use", (Object)KeyTypes.SIGNING, (Object)((KeyDescriptorType)desc.getKeyDescriptor().get(0)).getUse());
    }

    private void assertProviderInfo(Map<String, String> info, String id, String name) {
        System.out.println(info);
        Assert.assertEquals((String)"id", (Object)id, (Object)info.get("id"));
        Assert.assertEquals((String)"name", (Object)name, (Object)info.get("name"));
    }
}

