/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.Config;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.events.EventType;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ImpersonationConstants;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.AuthServerTestEnricher;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.CredentialBuilder;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserBuilder;

public class ImpersonationTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    private String impersonatedUserId;

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmBuilder realm = RealmBuilder.create().name("test").testEventListener();
        realm.client(ClientBuilder.create().clientId("myclient").publicClient().directAccessGrants());
        this.impersonatedUserId = KeycloakModelUtils.generateId();
        realm.user(UserBuilder.create().id(this.impersonatedUserId).username("test-user@localhost"));
        realm.user(UserBuilder.create().username("realm-admin").password("password").role("realm-management", AdminRoles.REALM_ADMIN));
        realm.user(UserBuilder.create().username("impersonator").password("password").role("realm-management", ImpersonationConstants.IMPERSONATION_ROLE).role("realm-management", AdminRoles.VIEW_USERS));
        realm.user(UserBuilder.create().username("bad-impersonator").password("password").role("realm-management", AdminRoles.MANAGE_USERS));
        testRealms.add(realm.build());
    }

    @Test
    public void testImpersonateByMasterAdmin() {
        this.testSuccessfulImpersonation("admin", Config.getAdminRealm());
    }

    @Test
    public void testImpersonateByMasterImpersonator() {
        Response response = this.adminClient.realm("master").users().create(UserBuilder.create().username("master-impersonator").build());
        String userId = ApiUtil.getCreatedId(response);
        response.close();
        UserResource user = this.adminClient.realm("master").users().get(userId);
        user.resetPassword(CredentialBuilder.create().password("password").build());
        ClientResource testRealmClient = ApiUtil.findClientResourceByClientId(this.adminClient.realm("master"), "test-realm");
        LinkedList<RoleRepresentation> roles = new LinkedList<RoleRepresentation>();
        roles.add(ApiUtil.findClientRoleByName(testRealmClient, AdminRoles.VIEW_USERS).toRepresentation());
        roles.add(ApiUtil.findClientRoleByName(testRealmClient, ImpersonationConstants.IMPERSONATION_ROLE).toRepresentation());
        user.roles().clientLevel(testRealmClient.toRepresentation().getId()).add(roles);
        this.testSuccessfulImpersonation("master-impersonator", Config.getAdminRealm());
        this.adminClient.realm("master").users().get(userId).remove();
    }

    @Test
    public void testImpersonateByTestImpersonator() {
        this.testSuccessfulImpersonation("impersonator", "test");
    }

    @Test
    public void testImpersonateByTestAdmin() {
        this.testSuccessfulImpersonation("realm-admin", "test");
    }

    @Test
    public void testImpersonateByTestBadImpersonator() {
        this.testForbiddenImpersonation("bad-impersonator", "test");
    }

    @Test
    public void testImpersonateByMastertBadImpersonator() {
        Response response = this.adminClient.realm("master").users().create(UserBuilder.create().username("master-bad-impersonator").build());
        String userId = ApiUtil.getCreatedId(response);
        response.close();
        this.adminClient.realm("master").users().get(userId).resetPassword(CredentialBuilder.create().password("password").build());
        this.testForbiddenImpersonation("master-bad-impersonator", Config.getAdminRealm());
        this.adminClient.realm("master").users().get(userId).remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testSuccessfulImpersonation(String admin, String adminRealm) {
        try (Keycloak client = this.login(admin, adminRealm);){
            Map data = client.realms().realm("test").users().get(this.impersonatedUserId).impersonate();
            Assert.assertNotNull((Object)data);
            Assert.assertNotNull(data.get("redirect"));
            this.events.expect(EventType.IMPERSONATE).session(AssertEvents.isUUID()).user(this.impersonatedUserId).detail("impersonator", admin).detail("impersonator_realm", adminRealm).client((String)null).assertEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testForbiddenImpersonation(String admin, String adminRealm) {
        try (Keycloak client = this.createAdminClient(adminRealm, this.establishClientId(adminRealm), admin);){
            client.realms().realm("test").users().get(this.impersonatedUserId).impersonate();
        }
    }

    Keycloak createAdminClient(String realm, String clientId, String username) {
        return this.createAdminClient(realm, clientId, username, null);
    }

    String establishClientId(String realm) {
        return realm.equals("master") ? "admin-cli" : "myclient";
    }

    Keycloak createAdminClient(String realm, String clientId, String username, String password) {
        if (password == null) {
            password = username.equals("admin") ? "admin" : "password";
        }
        return Keycloak.getInstance((String)(AuthServerTestEnricher.getAuthServerContextRoot() + "/auth"), (String)realm, (String)username, (String)password, (String)clientId);
    }

    private Keycloak login(String username, String realm) {
        String clientId = this.establishClientId(realm);
        Keycloak client = this.createAdminClient(realm, clientId, username);
        client.tokenManager().grantToken();
        if (!"master".equals(realm)) {
            EventRepresentation e = this.events.poll();
            Assert.assertEquals((String)"Event type", (Object)EventType.LOGIN.toString(), (Object)e.getType());
            Assert.assertEquals((String)"Client ID", (Object)clientId, (Object)e.getClientId());
            Assert.assertEquals((String)"Username", (Object)username, e.getDetails().get("username"));
        }
        return client;
    }
}

