/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientInitialAccessResource;
import org.keycloak.common.util.Time;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.ClientInitialAccessCreatePresentation;
import org.keycloak.representations.idm.ClientInitialAccessPresentation;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.util.AdminEventPaths;

public class InitialAccessTokenResourceTest
extends AbstractAdminTest {
    private ClientInitialAccessResource resource;

    @Before
    public void before() {
        this.resource = this.realm.clientInitialAccess();
    }

    @Test
    public void testInitialAccessTokens() {
        ClientInitialAccessCreatePresentation rep = new ClientInitialAccessCreatePresentation();
        rep.setCount(Integer.valueOf(2));
        rep.setExpiration(Integer.valueOf(100));
        int time = Time.currentTime();
        ClientInitialAccessPresentation response = this.resource.create(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientInitialAccessPath(response.getId()), (Object)rep, ResourceType.CLIENT_INITIAL_ACCESS_MODEL);
        Assert.assertNotNull((Object)response.getId());
        Assert.assertEquals((Object)new Integer(2), (Object)response.getCount());
        Assert.assertEquals((Object)new Integer(2), (Object)response.getRemainingCount());
        Assert.assertEquals((Object)new Integer(100), (Object)response.getExpiration());
        Assert.assertTrue((time <= response.getTimestamp() && response.getTimestamp() <= Time.currentTime() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)response.getToken());
        rep.setCount(Integer.valueOf(3));
        response = this.resource.create(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientInitialAccessPath(response.getId()), (Object)rep, ResourceType.CLIENT_INITIAL_ACCESS_MODEL);
        rep.setCount(Integer.valueOf(4));
        response = this.resource.create(rep);
        String lastId = response.getId();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientInitialAccessPath(lastId), (Object)rep, ResourceType.CLIENT_INITIAL_ACCESS_MODEL);
        List list = this.resource.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)9L, (long)(((ClientInitialAccessPresentation)list.get(0)).getCount() + ((ClientInitialAccessPresentation)list.get(1)).getCount() + ((ClientInitialAccessPresentation)list.get(2)).getCount()));
        Assert.assertNull((Object)((ClientInitialAccessPresentation)list.get(0)).getToken());
        this.resource.delete(lastId);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.clientInitialAccessPath(lastId), ResourceType.CLIENT_INITIAL_ACCESS_MODEL);
        list = this.resource.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)5L, (long)(((ClientInitialAccessPresentation)list.get(0)).getCount() + ((ClientInitialAccessPresentation)list.get(1)).getCount()));
    }
}

